/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Primitives;
import io.trino.metadata.SqlScalarFunction;
import io.trino.operator.scalar.ChoicesSpecializedSqlScalarFunction;
import io.trino.operator.scalar.SpecializedSqlScalarFunction;
import io.trino.spi.block.Block;
import io.trino.spi.function.BoundSignature;
import io.trino.spi.function.FunctionMetadata;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.function.Signature;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;
import io.trino.spi.type.TypeUtils;
import io.trino.sql.gen.lambda.BinaryFunctionInterface;
import io.trino.sql.gen.lambda.UnaryFunctionInterface;
import io.trino.util.Reflection;
import java.lang.invoke.MethodHandle;
import java.util.List;
import java.util.Optional;

public final class ArrayReduceFunction
extends SqlScalarFunction {
    public static final ArrayReduceFunction ARRAY_REDUCE_FUNCTION = new ArrayReduceFunction();
    private static final MethodHandle METHOD_HANDLE = Reflection.methodHandle(ArrayReduceFunction.class, "reduce", Type.class, Block.class, Object.class, BinaryFunctionInterface.class, UnaryFunctionInterface.class);

    private ArrayReduceFunction() {
        super(FunctionMetadata.scalarBuilder().signature(Signature.builder().name("reduce").typeVariable("T").typeVariable("S").typeVariable("R").returnType(new TypeSignature("R", new TypeSignatureParameter[0])).argumentType(TypeSignature.arrayType((TypeSignature)new TypeSignature("T", new TypeSignatureParameter[0]))).argumentType(new TypeSignature("S", new TypeSignatureParameter[0])).argumentType(TypeSignature.functionType((TypeSignature)new TypeSignature("S", new TypeSignatureParameter[0]), (TypeSignature[])new TypeSignature[]{new TypeSignature("T", new TypeSignatureParameter[0]), new TypeSignature("S", new TypeSignatureParameter[0])})).argumentType(TypeSignature.functionType((TypeSignature)new TypeSignature("S", new TypeSignatureParameter[0]), (TypeSignature[])new TypeSignature[]{new TypeSignature("R", new TypeSignatureParameter[0])})).build()).nullable().argumentNullability(new boolean[]{false, true, false, false}).nondeterministic().description("Reduce elements of the array into a single value").build());
    }

    @Override
    protected SpecializedSqlScalarFunction specialize(BoundSignature boundSignature) {
        ArrayType arrayType = (ArrayType)boundSignature.getArgumentTypes().get(0);
        Type inputType = arrayType.getElementType();
        Type intermediateType = (Type)boundSignature.getArgumentTypes().get(1);
        Type outputType = boundSignature.getReturnType();
        MethodHandle methodHandle = METHOD_HANDLE.bindTo(inputType);
        return new ChoicesSpecializedSqlScalarFunction(boundSignature, InvocationConvention.InvocationReturnConvention.NULLABLE_RETURN, (List<InvocationConvention.InvocationArgumentConvention>)ImmutableList.of((Object)InvocationConvention.InvocationArgumentConvention.NEVER_NULL, (Object)InvocationConvention.InvocationArgumentConvention.BOXED_NULLABLE, (Object)InvocationConvention.InvocationArgumentConvention.FUNCTION, (Object)InvocationConvention.InvocationArgumentConvention.FUNCTION), (List<Class<?>>)ImmutableList.of(BinaryFunctionInterface.class, UnaryFunctionInterface.class), methodHandle.asType(methodHandle.type().changeParameterType(1, Primitives.wrap((Class)intermediateType.getJavaType())).changeReturnType(Primitives.wrap((Class)outputType.getJavaType()))), Optional.empty());
    }

    public static Object reduce(Type inputType, Block block, Object initialIntermediateValue, BinaryFunctionInterface inputFunction, UnaryFunctionInterface outputFunction) {
        int positionCount = block.getPositionCount();
        Object intermediateValue = initialIntermediateValue;
        for (int position = 0; position < positionCount; ++position) {
            Object input = TypeUtils.readNativeValue((Type)inputType, (Block)block, (int)position);
            intermediateValue = inputFunction.apply(intermediateValue, input);
        }
        return outputFunction.apply(intermediateValue);
    }
}

