/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import com.google.common.collect.ImmutableList;
import io.trino.annotation.UsedByGeneratedCode;
import io.trino.metadata.SqlScalarFunction;
import io.trino.operator.scalar.ChoicesSpecializedSqlScalarFunction;
import io.trino.operator.scalar.SpecializedSqlScalarFunction;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.block.BufferedMapValueBuilder;
import io.trino.spi.block.DuplicateMapKeyException;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.function.BoundSignature;
import io.trino.spi.function.FunctionDependencies;
import io.trino.spi.function.FunctionDependencyDeclaration;
import io.trino.spi.function.FunctionMetadata;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.function.OperatorType;
import io.trino.spi.function.Signature;
import io.trino.spi.type.MapType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;
import io.trino.spi.type.TypeUtils;
import io.trino.util.Failures;
import io.trino.util.Reflection;
import java.lang.invoke.MethodHandle;
import java.util.List;
import java.util.Optional;

public final class MapConstructor
extends SqlScalarFunction {
    public static final MapConstructor MAP_CONSTRUCTOR = new MapConstructor();
    private static final MethodHandle METHOD_HANDLE = Reflection.methodHandle(MapConstructor.class, "createMap", MapType.class, MethodHandle.class, State.class, ConnectorSession.class, Block.class, Block.class);
    private static final String DESCRIPTION = "Constructs a map from the given key/value arrays";

    public MapConstructor() {
        super(FunctionMetadata.scalarBuilder().signature(Signature.builder().name("map").comparableTypeParameter("K").typeVariable("V").returnType(TypeSignature.mapType((TypeSignature)new TypeSignature("K", new TypeSignatureParameter[0]), (TypeSignature)new TypeSignature("V", new TypeSignatureParameter[0]))).argumentType(TypeSignature.arrayType((TypeSignature)new TypeSignature("K", new TypeSignatureParameter[0]))).argumentType(TypeSignature.arrayType((TypeSignature)new TypeSignature("V", new TypeSignatureParameter[0]))).build()).description(DESCRIPTION).build());
    }

    @Override
    public FunctionDependencyDeclaration getFunctionDependencies() {
        return FunctionDependencyDeclaration.builder().addOperatorSignature(OperatorType.HASH_CODE, (List)ImmutableList.of((Object)new TypeSignature("K", new TypeSignatureParameter[0]))).addOperatorSignature(OperatorType.EQUAL, (List)ImmutableList.of((Object)new TypeSignature("K", new TypeSignatureParameter[0]), (Object)new TypeSignature("K", new TypeSignatureParameter[0]))).addOperatorSignature(OperatorType.INDETERMINATE, (List)ImmutableList.of((Object)new TypeSignature("K", new TypeSignatureParameter[0]))).build();
    }

    @Override
    public SpecializedSqlScalarFunction specialize(BoundSignature boundSignature, FunctionDependencies functionDependencies) {
        MapType mapType = (MapType)boundSignature.getReturnType();
        MethodHandle keyIndeterminate = functionDependencies.getOperatorImplementation(OperatorType.INDETERMINATE, (List)ImmutableList.of((Object)mapType.getKeyType()), InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.NEVER_NULL})).getMethodHandle();
        MethodHandle instanceFactory = Reflection.constructorMethodHandle(State.class, MapType.class).bindTo(mapType);
        return new ChoicesSpecializedSqlScalarFunction(boundSignature, InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (List<InvocationConvention.InvocationArgumentConvention>)ImmutableList.of((Object)InvocationConvention.InvocationArgumentConvention.NEVER_NULL, (Object)InvocationConvention.InvocationArgumentConvention.NEVER_NULL), METHOD_HANDLE.bindTo(mapType).bindTo(keyIndeterminate), Optional.of(instanceFactory));
    }

    @UsedByGeneratedCode
    public static Block createMap(MapType mapType, MethodHandle keyIndeterminate, State state, ConnectorSession session, Block keyBlock, Block valueBlock) {
        Failures.checkCondition(keyBlock.getPositionCount() == valueBlock.getPositionCount(), (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Key and value arrays must be the same length", new Object[0]);
        try {
            return state.getMapValueBuilder().build(keyBlock.getPositionCount(), (keyBuilder, valueBuilder) -> {
                for (int i = 0; i < keyBlock.getPositionCount(); ++i) {
                    if (keyBlock.isNull(i)) {
                        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "map key cannot be null");
                    }
                    Object keyObject = TypeUtils.readNativeValue((Type)mapType.getKeyType(), (Block)keyBlock, (int)i);
                    try {
                        if (keyIndeterminate.invoke(keyObject)) {
                            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "map key cannot be indeterminate: " + mapType.getKeyType().getObjectValue(session, keyBlock, i));
                        }
                    }
                    catch (Throwable t) {
                        throw Failures.internalError(t);
                    }
                    mapType.getKeyType().appendTo(keyBlock, i, keyBuilder);
                    mapType.getValueType().appendTo(valueBlock, i, valueBuilder);
                }
            });
        }
        catch (DuplicateMapKeyException e) {
            throw e.withDetailedMessage(mapType.getKeyType(), session);
        }
    }

    public static final class State {
        private final BufferedMapValueBuilder mapValueBuilder;

        public State(MapType mapType) {
            this.mapValueBuilder = BufferedMapValueBuilder.createBufferedStrict((MapType)mapType);
        }

        public BufferedMapValueBuilder getMapValueBuilder() {
            return this.mapValueBuilder;
        }
    }
}

