/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import io.trino.annotation.UsedByGeneratedCode;
import io.trino.metadata.SqlScalarFunction;
import io.trino.operator.scalar.BlockSet;
import io.trino.operator.scalar.ChoicesSpecializedSqlScalarFunction;
import io.trino.operator.scalar.SpecializedSqlScalarFunction;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.MapValueBuilder;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.function.BoundSignature;
import io.trino.spi.function.FunctionDependencies;
import io.trino.spi.function.FunctionDependencyDeclaration;
import io.trino.spi.function.FunctionMetadata;
import io.trino.spi.function.FunctionNullability;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.function.OperatorType;
import io.trino.spi.function.Signature;
import io.trino.spi.type.MapType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;
import io.trino.type.BlockTypeOperators;
import io.trino.util.Failures;
import io.trino.util.Reflection;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.List;
import java.util.Objects;

public final class MapToMapCast
extends SqlScalarFunction {
    private static final MethodHandle METHOD_HANDLE = Reflection.methodHandle(MapToMapCast.class, "mapCast", MethodHandle.class, MethodHandle.class, Type.class, BlockTypeOperators.BlockPositionIsDistinctFrom.class, BlockTypeOperators.BlockPositionHashCode.class, ConnectorSession.class, Block.class);
    private static final MethodHandle CHECK_LONG_IS_NOT_NULL = Reflection.methodHandle(MapToMapCast.class, "checkLongIsNotNull", Long.class);
    private static final MethodHandle CHECK_DOUBLE_IS_NOT_NULL = Reflection.methodHandle(MapToMapCast.class, "checkDoubleIsNotNull", Double.class);
    private static final MethodHandle CHECK_BOOLEAN_IS_NOT_NULL = Reflection.methodHandle(MapToMapCast.class, "checkBooleanIsNotNull", Boolean.class);
    private static final MethodHandle CHECK_SLICE_IS_NOT_NULL = Reflection.methodHandle(MapToMapCast.class, "checkSliceIsNotNull", Slice.class);
    private static final MethodHandle CHECK_BLOCK_IS_NOT_NULL = Reflection.methodHandle(MapToMapCast.class, "checkBlockIsNotNull", Block.class);
    private static final MethodHandle WRITE_LONG = Reflection.methodHandle(Type.class, "writeLong", BlockBuilder.class, Long.TYPE);
    private static final MethodHandle WRITE_DOUBLE = Reflection.methodHandle(Type.class, "writeDouble", BlockBuilder.class, Double.TYPE);
    private static final MethodHandle WRITE_BOOLEAN = Reflection.methodHandle(Type.class, "writeBoolean", BlockBuilder.class, Boolean.TYPE);
    private static final MethodHandle WRITE_OBJECT = Reflection.methodHandle(Type.class, "writeObject", BlockBuilder.class, Object.class);
    private final BlockTypeOperators blockTypeOperators;

    public MapToMapCast(BlockTypeOperators blockTypeOperators) {
        super(FunctionMetadata.scalarBuilder().signature(Signature.builder().operatorType(OperatorType.CAST).castableToTypeParameter("FK", new TypeSignature("TK", new TypeSignatureParameter[0])).castableToTypeParameter("FV", new TypeSignature("TV", new TypeSignatureParameter[0])).typeVariable("TK").typeVariable("TV").returnType(TypeSignature.mapType((TypeSignature)new TypeSignature("TK", new TypeSignatureParameter[0]), (TypeSignature)new TypeSignature("TV", new TypeSignatureParameter[0]))).argumentType(TypeSignature.mapType((TypeSignature)new TypeSignature("FK", new TypeSignatureParameter[0]), (TypeSignature)new TypeSignature("FV", new TypeSignatureParameter[0]))).build()).nullable().build());
        this.blockTypeOperators = Objects.requireNonNull(blockTypeOperators, "blockTypeOperators is null");
    }

    @Override
    public FunctionDependencyDeclaration getFunctionDependencies() {
        return FunctionDependencyDeclaration.builder().addCastSignature(new TypeSignature("FK", new TypeSignatureParameter[0]), new TypeSignature("TK", new TypeSignatureParameter[0])).addCastSignature(new TypeSignature("FV", new TypeSignatureParameter[0]), new TypeSignature("TV", new TypeSignatureParameter[0])).build();
    }

    @Override
    public SpecializedSqlScalarFunction specialize(BoundSignature boundSignature, FunctionDependencies functionDependencies) {
        Preconditions.checkArgument((boundSignature.getArity() == 1 ? 1 : 0) != 0, (Object)"Expected arity to be 1");
        MapType fromMapType = (MapType)boundSignature.getArgumentType(0);
        Type fromKeyType = fromMapType.getKeyType();
        Type fromValueType = fromMapType.getValueType();
        MapType toMapType = (MapType)boundSignature.getReturnType();
        Type toKeyType = toMapType.getKeyType();
        Type toValueType = toMapType.getValueType();
        MethodHandle keyProcessor = this.buildProcessor(functionDependencies, fromKeyType, toKeyType, true);
        MethodHandle valueProcessor = this.buildProcessor(functionDependencies, fromValueType, toValueType, false);
        BlockTypeOperators.BlockPositionIsDistinctFrom keyEqual = this.blockTypeOperators.getDistinctFromOperator(toKeyType);
        BlockTypeOperators.BlockPositionHashCode keyHashCode = this.blockTypeOperators.getHashCodeOperator(toKeyType);
        MethodHandle target = MethodHandles.insertArguments(METHOD_HANDLE, 0, keyProcessor, valueProcessor, toMapType, keyEqual, keyHashCode);
        return new ChoicesSpecializedSqlScalarFunction(boundSignature, InvocationConvention.InvocationReturnConvention.NULLABLE_RETURN, (List<InvocationConvention.InvocationArgumentConvention>)ImmutableList.of((Object)InvocationConvention.InvocationArgumentConvention.NEVER_NULL), target);
    }

    private MethodHandle buildProcessor(FunctionDependencies functionDependencies, Type fromType, Type toType, boolean isKey) {
        FunctionNullability functionNullability = functionDependencies.getCastNullability(fromType, toType);
        InvocationConvention invocationConvention = new InvocationConvention((List)ImmutableList.of((Object)InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION), functionNullability.isReturnNullable() ? InvocationConvention.InvocationReturnConvention.NULLABLE_RETURN : InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, true, false);
        MethodHandle cast = functionDependencies.getCastImplementation(fromType, toType, invocationConvention).getMethodHandle();
        if (cast.type().parameterArray()[0] != ConnectorSession.class) {
            cast = MethodHandles.dropArguments(cast, 0, new Class[]{ConnectorSession.class});
        }
        cast = MethodHandles.permuteArguments(cast, MethodType.methodType(cast.type().returnType(), Block.class, new Class[]{Integer.TYPE, ConnectorSession.class}), 2, 0, 1);
        if (isKey && functionNullability.isReturnNullable()) {
            MethodHandle target = this.nullChecker((Class<?>)cast.type().returnType());
            cast = MethodHandles.foldArguments(MethodHandles.dropArguments(target, 1, cast.type().parameterList()), cast);
        }
        MethodHandle writer = MapToMapCast.nativeValueWriter(toType);
        writer = MethodHandles.permuteArguments(writer, MethodType.methodType(Void.TYPE, writer.type().parameterArray()[1], BlockBuilder.class), 1, 0);
        cast = cast.asType(MethodType.methodType(writer.type().parameterType(0), cast.type().parameterArray()));
        return MethodHandles.foldArguments(MethodHandles.dropArguments(writer, 1, cast.type().parameterList()), cast);
    }

    private MethodHandle nullChecker(Class<?> javaType) {
        if (javaType == Long.class) {
            return CHECK_LONG_IS_NOT_NULL;
        }
        if (javaType == Double.class) {
            return CHECK_DOUBLE_IS_NOT_NULL;
        }
        if (javaType == Boolean.class) {
            return CHECK_BOOLEAN_IS_NOT_NULL;
        }
        if (javaType == Slice.class) {
            return CHECK_SLICE_IS_NOT_NULL;
        }
        if (javaType == Block.class) {
            return CHECK_BLOCK_IS_NOT_NULL;
        }
        throw new IllegalArgumentException("Unknown java type " + javaType);
    }

    @UsedByGeneratedCode
    public static long checkLongIsNotNull(Long value) {
        if (value == null) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, "map key is null");
        }
        return value;
    }

    @UsedByGeneratedCode
    public static double checkDoubleIsNotNull(Double value) {
        if (value == null) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, "map key is null");
        }
        return value;
    }

    @UsedByGeneratedCode
    public static boolean checkBooleanIsNotNull(Boolean value) {
        if (value == null) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, "map key is null");
        }
        return value;
    }

    @UsedByGeneratedCode
    public static Slice checkSliceIsNotNull(Slice value) {
        if (value == null) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, "map key is null");
        }
        return value;
    }

    @UsedByGeneratedCode
    public static Block checkBlockIsNotNull(Block value) {
        if (value == null) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, "map key is null");
        }
        return value;
    }

    @UsedByGeneratedCode
    public static Block mapCast(MethodHandle keyProcessFunction, MethodHandle valueProcessFunction, Type targetType, BlockTypeOperators.BlockPositionIsDistinctFrom keyDistinctOperator, BlockTypeOperators.BlockPositionHashCode keyHashCode, ConnectorSession session, Block fromMap) {
        MapType mapType = (MapType)targetType;
        Type toKeyType = mapType.getKeyType();
        BlockBuilder tempKeyBlockBuilder = toKeyType.createBlockBuilder(null, fromMap.getPositionCount() / 2);
        for (int i = 0; i < fromMap.getPositionCount(); i += 2) {
            try {
                keyProcessFunction.invokeExact(fromMap, i, session, tempKeyBlockBuilder);
                continue;
            }
            catch (Throwable t) {
                throw Failures.internalError(t);
            }
        }
        Block keyBlock = tempKeyBlockBuilder.build();
        return MapValueBuilder.buildMapValue((MapType)mapType, (int)(fromMap.getPositionCount() / 2), (keyBuilder, valueBuilder) -> {
            BlockSet resultKeys = new BlockSet(toKeyType, keyDistinctOperator, keyHashCode, fromMap.getPositionCount() / 2);
            for (int i = 0; i < fromMap.getPositionCount(); i += 2) {
                if (resultKeys.add(keyBlock, i / 2)) {
                    toKeyType.appendTo(keyBlock, i / 2, keyBuilder);
                    if (fromMap.isNull(i + 1)) {
                        valueBuilder.appendNull();
                        continue;
                    }
                    try {
                        valueProcessFunction.invokeExact(fromMap, i + 1, session, valueBuilder);
                        continue;
                    }
                    catch (Throwable t) {
                        throw Failures.internalError(t);
                    }
                }
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, "duplicate keys");
            }
        });
    }

    public static MethodHandle nativeValueWriter(Type type) {
        MethodHandle methodHandle;
        Class javaType = type.getJavaType();
        if (javaType == Long.TYPE) {
            methodHandle = WRITE_LONG;
        } else if (javaType == Double.TYPE) {
            methodHandle = WRITE_DOUBLE;
        } else if (javaType == Boolean.TYPE) {
            methodHandle = WRITE_BOOLEAN;
        } else if (!javaType.isPrimitive()) {
            methodHandle = WRITE_OBJECT;
        } else {
            throw new IllegalArgumentException("Unknown java type " + javaType + " from type " + type);
        }
        return methodHandle.bindTo(type);
    }
}

