/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import com.google.common.collect.ImmutableList;
import io.trino.annotation.UsedByGeneratedCode;
import io.trino.metadata.SqlScalarFunction;
import io.trino.operator.scalar.ChoicesSpecializedSqlScalarFunction;
import io.trino.operator.scalar.SpecializedSqlScalarFunction;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.RowBlockBuilder;
import io.trino.spi.function.BoundSignature;
import io.trino.spi.function.FunctionMetadata;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.function.Signature;
import io.trino.spi.function.TypeVariableConstraint;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;
import io.trino.util.Reflection;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.util.Collections;
import java.util.List;
import java.util.stream.IntStream;

public final class ZipFunction
extends SqlScalarFunction {
    public static final int MIN_ARITY = 2;
    public static final int MAX_ARITY = 5;
    public static final ZipFunction[] ZIP_FUNCTIONS;
    private static final MethodHandle METHOD_HANDLE;

    private ZipFunction(int arity) {
        this((List)IntStream.rangeClosed(1, arity).mapToObj(s -> "T" + s).collect(ImmutableList.toImmutableList()));
    }

    private ZipFunction(List<String> typeParameters) {
        super(FunctionMetadata.scalarBuilder().signature(Signature.builder().name("zip").typeVariableConstraints((List)typeParameters.stream().map(TypeVariableConstraint::typeVariable).collect(ImmutableList.toImmutableList())).returnType(TypeSignature.arrayType((TypeSignature)TypeSignature.rowType((List)((List)typeParameters.stream().map(x$0 -> new TypeSignature(x$0, new TypeSignatureParameter[0])).map(TypeSignatureParameter::anonymousField).collect(ImmutableList.toImmutableList()))))).argumentTypes((List)typeParameters.stream().map(name -> TypeSignature.arrayType((TypeSignature)new TypeSignature(name, new TypeSignatureParameter[0]))).collect(ImmutableList.toImmutableList())).build()).description("Merges the given arrays, element-wise, into a single array of rows.").build());
    }

    @Override
    protected SpecializedSqlScalarFunction specialize(BoundSignature boundSignature) {
        List types = (List)boundSignature.getArgumentTypes().stream().map(ArrayType.class::cast).map(ArrayType::getElementType).collect(ImmutableList.toImmutableList());
        List<Class<?>> javaArgumentTypes = Collections.nCopies(types.size(), Block.class);
        MethodHandle methodHandle = METHOD_HANDLE.bindTo(types).asVarargsCollector(Block[].class).asType(MethodType.methodType(Block.class, javaArgumentTypes));
        return new ChoicesSpecializedSqlScalarFunction(boundSignature, InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, Collections.nCopies(types.size(), InvocationConvention.InvocationArgumentConvention.NEVER_NULL), methodHandle);
    }

    @UsedByGeneratedCode
    public static Block zip(List<Type> types, Block ... arrays) {
        int biggestCardinality = 0;
        for (Block array : arrays) {
            biggestCardinality = Math.max(biggestCardinality, array.getPositionCount());
        }
        RowType rowType = RowType.anonymous(types);
        RowBlockBuilder outputBuilder = rowType.createBlockBuilder(null, biggestCardinality);
        for (int outputPosition = 0; outputPosition < biggestCardinality; ++outputPosition) {
            ZipFunction.buildRow(types, outputBuilder, outputPosition, arrays);
        }
        return outputBuilder.build();
    }

    private static void buildRow(List<Type> types, RowBlockBuilder outputBuilder, int outputPosition, Block[] arrays) {
        outputBuilder.buildEntry(fieldBuilders -> {
            for (int fieldIndex = 0; fieldIndex < arrays.length; ++fieldIndex) {
                if (arrays[fieldIndex].getPositionCount() <= outputPosition) {
                    ((BlockBuilder)fieldBuilders.get(fieldIndex)).appendNull();
                    continue;
                }
                ((Type)types.get(fieldIndex)).appendTo(arrays[fieldIndex], outputPosition, (BlockBuilder)fieldBuilders.get(fieldIndex));
            }
        });
    }

    static {
        METHOD_HANDLE = Reflection.methodHandle(ZipFunction.class, "zip", List.class, Block[].class);
        ZIP_FUNCTIONS = new ZipFunction[4];
        for (int arity = 2; arity <= 5; ++arity) {
            ZipFunction.ZIP_FUNCTIONS[arity - 2] = new ZipFunction(arity);
        }
    }
}

