/*
 * Decompiled with CFR 0.152.
 */
package io.trino.security;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.trino.metadata.QualifiedObjectName;
import io.trino.security.AccessControl;
import io.trino.security.SecurityContext;
import io.trino.spi.connector.CatalogSchemaName;
import io.trino.spi.connector.CatalogSchemaTableName;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.function.FunctionKind;
import io.trino.spi.security.AccessDeniedException;
import io.trino.spi.security.Identity;
import io.trino.spi.security.Privilege;
import io.trino.spi.security.TrinoPrincipal;
import java.security.Principal;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class DenyAllAccessControl
implements AccessControl {
    @Override
    public void checkCanImpersonateUser(Identity identity, String userName) {
        AccessDeniedException.denyImpersonateUser((String)identity.getUser(), (String)userName);
    }

    @Override
    public void checkCanSetUser(Optional<Principal> principal, String userName) {
        AccessDeniedException.denySetUser(principal, (String)userName);
    }

    @Override
    public void checkCanReadSystemInformation(Identity identity) {
        AccessDeniedException.denyReadSystemInformationAccess();
    }

    @Override
    public void checkCanWriteSystemInformation(Identity identity) {
        AccessDeniedException.denyWriteSystemInformationAccess();
    }

    @Override
    public void checkCanExecuteQuery(Identity identity) {
        AccessDeniedException.denyExecuteQuery();
    }

    @Override
    public void checkCanViewQueryOwnedBy(Identity identity, Identity queryOwner) {
        AccessDeniedException.denyViewQuery();
    }

    @Override
    public Collection<Identity> filterQueriesOwnedBy(Identity identity, Collection<Identity> queryOwners) {
        return ImmutableList.of();
    }

    @Override
    public void checkCanKillQueryOwnedBy(Identity identity, Identity queryOwner) {
        AccessDeniedException.denyKillQuery();
    }

    @Override
    public void checkCanCreateCatalog(SecurityContext context, String catalog) {
        AccessDeniedException.denyCreateCatalog((String)catalog);
    }

    @Override
    public void checkCanDropCatalog(SecurityContext context, String catalog) {
        AccessDeniedException.denyDropCatalog((String)catalog);
    }

    @Override
    public Set<String> filterCatalogs(SecurityContext context, Set<String> catalogs) {
        return ImmutableSet.of();
    }

    @Override
    public void checkCanCreateSchema(SecurityContext context, CatalogSchemaName schemaName, Map<String, Object> properties) {
        AccessDeniedException.denyCreateSchema((String)schemaName.toString());
    }

    @Override
    public void checkCanDropSchema(SecurityContext context, CatalogSchemaName schemaName) {
        AccessDeniedException.denyDropSchema((String)schemaName.toString());
    }

    @Override
    public void checkCanRenameSchema(SecurityContext context, CatalogSchemaName schemaName, String newSchemaName) {
        AccessDeniedException.denyRenameSchema((String)schemaName.toString(), (String)newSchemaName);
    }

    @Override
    public void checkCanShowCreateSchema(SecurityContext context, CatalogSchemaName schemaName) {
        AccessDeniedException.denyShowCreateSchema((String)schemaName.toString());
    }

    @Override
    public void checkCanShowCreateTable(SecurityContext context, QualifiedObjectName tableName) {
        AccessDeniedException.denyShowCreateTable((String)tableName.toString());
    }

    @Override
    public void checkCanSetSchemaAuthorization(SecurityContext context, CatalogSchemaName schemaName, TrinoPrincipal principal) {
        AccessDeniedException.denySetSchemaAuthorization((String)schemaName.toString(), (TrinoPrincipal)principal);
    }

    @Override
    public void checkCanCreateTable(SecurityContext context, QualifiedObjectName tableName, Map<String, Object> properties) {
        AccessDeniedException.denyCreateTable((String)tableName.toString());
    }

    @Override
    public void checkCanDropTable(SecurityContext context, QualifiedObjectName tableName) {
        AccessDeniedException.denyDropTable((String)tableName.toString());
    }

    @Override
    public void checkCanRenameTable(SecurityContext context, QualifiedObjectName tableName, QualifiedObjectName newTableName) {
        AccessDeniedException.denyRenameTable((String)tableName.toString(), (String)newTableName.toString());
    }

    @Override
    public void checkCanSetTableProperties(SecurityContext context, QualifiedObjectName tableName, Map<String, Optional<Object>> properties) {
        AccessDeniedException.denySetTableProperties((String)tableName.toString());
    }

    @Override
    public void checkCanSetTableComment(SecurityContext context, QualifiedObjectName tableName) {
        AccessDeniedException.denyCommentTable((String)tableName.toString());
    }

    @Override
    public void checkCanSetViewComment(SecurityContext context, QualifiedObjectName viewName) {
        AccessDeniedException.denyCommentView((String)viewName.toString());
    }

    @Override
    public void checkCanSetColumnComment(SecurityContext context, QualifiedObjectName tableName) {
        AccessDeniedException.denyCommentColumn((String)tableName.toString());
    }

    @Override
    public void checkCanShowTables(SecurityContext context, CatalogSchemaName schema) {
        AccessDeniedException.denyShowTables((String)schema.toString());
    }

    @Override
    public Set<SchemaTableName> filterTables(SecurityContext context, String catalogName, Set<SchemaTableName> tableNames) {
        return ImmutableSet.of();
    }

    @Override
    public void checkCanShowColumns(SecurityContext context, CatalogSchemaTableName table) {
        AccessDeniedException.denyShowColumns((String)table.toString());
    }

    @Override
    public Set<String> filterColumns(SecurityContext context, CatalogSchemaTableName tableName, Set<String> columns) {
        return ImmutableSet.of();
    }

    @Override
    public void checkCanShowSchemas(SecurityContext context, String catalogName) {
        AccessDeniedException.denyShowSchemas();
    }

    @Override
    public Set<String> filterSchemas(SecurityContext context, String catalogName, Set<String> schemaNames) {
        return ImmutableSet.of();
    }

    @Override
    public void checkCanAddColumns(SecurityContext context, QualifiedObjectName tableName) {
        AccessDeniedException.denyAddColumn((String)tableName.toString());
    }

    @Override
    public void checkCanAlterColumn(SecurityContext context, QualifiedObjectName tableName) {
        AccessDeniedException.denyAlterColumn((String)tableName.toString());
    }

    @Override
    public void checkCanRenameColumn(SecurityContext context, QualifiedObjectName tableName) {
        AccessDeniedException.denyRenameColumn((String)tableName.toString());
    }

    @Override
    public void checkCanDropColumn(SecurityContext context, QualifiedObjectName tableName) {
        AccessDeniedException.denyDropColumn((String)tableName.toString());
    }

    @Override
    public void checkCanSetTableAuthorization(SecurityContext context, QualifiedObjectName tableName, TrinoPrincipal principal) {
        AccessDeniedException.denySetTableAuthorization((String)tableName.toString(), (TrinoPrincipal)principal);
    }

    @Override
    public void checkCanInsertIntoTable(SecurityContext context, QualifiedObjectName tableName) {
        AccessDeniedException.denyInsertTable((String)tableName.toString());
    }

    @Override
    public void checkCanDeleteFromTable(SecurityContext context, QualifiedObjectName tableName) {
        AccessDeniedException.denyDeleteTable((String)tableName.toString());
    }

    @Override
    public void checkCanTruncateTable(SecurityContext context, QualifiedObjectName tableName) {
        AccessDeniedException.denyTruncateTable((String)tableName.toString());
    }

    @Override
    public void checkCanUpdateTableColumns(SecurityContext context, QualifiedObjectName tableName, Set<String> updatedColumnNames) {
        AccessDeniedException.denyUpdateTableColumns((String)tableName.toString(), updatedColumnNames);
    }

    @Override
    public void checkCanCreateView(SecurityContext context, QualifiedObjectName viewName) {
        AccessDeniedException.denyCreateView((String)viewName.toString());
    }

    @Override
    public void checkCanRenameView(SecurityContext context, QualifiedObjectName viewName, QualifiedObjectName newViewName) {
        AccessDeniedException.denyRenameView((String)viewName.toString(), (String)newViewName.toString());
    }

    @Override
    public void checkCanSetViewAuthorization(SecurityContext context, QualifiedObjectName view, TrinoPrincipal principal) {
        AccessDeniedException.denySetViewAuthorization((String)view.toString(), (TrinoPrincipal)principal);
    }

    @Override
    public void checkCanDropView(SecurityContext context, QualifiedObjectName viewName) {
        AccessDeniedException.denyDropView((String)viewName.toString());
    }

    @Override
    public void checkCanCreateViewWithSelectFromColumns(SecurityContext context, QualifiedObjectName tableName, Set<String> columnNames) {
        AccessDeniedException.denyCreateViewWithSelect((String)tableName.toString(), (Identity)context.getIdentity());
    }

    @Override
    public void checkCanCreateMaterializedView(SecurityContext context, QualifiedObjectName materializedViewName, Map<String, Object> properties) {
        AccessDeniedException.denyCreateMaterializedView((String)materializedViewName.toString());
    }

    @Override
    public void checkCanRefreshMaterializedView(SecurityContext context, QualifiedObjectName materializedViewName) {
        AccessDeniedException.denyRefreshMaterializedView((String)materializedViewName.toString());
    }

    @Override
    public void checkCanDropMaterializedView(SecurityContext context, QualifiedObjectName materializedViewName) {
        AccessDeniedException.denyDropMaterializedView((String)materializedViewName.toString());
    }

    @Override
    public void checkCanRenameMaterializedView(SecurityContext context, QualifiedObjectName viewName, QualifiedObjectName newViewName) {
        AccessDeniedException.denyRenameMaterializedView((String)viewName.toString(), (String)newViewName.toString());
    }

    @Override
    public void checkCanSetMaterializedViewProperties(SecurityContext context, QualifiedObjectName materializedViewName, Map<String, Optional<Object>> properties) {
        AccessDeniedException.denySetMaterializedViewProperties((String)materializedViewName.toString());
    }

    @Override
    public void checkCanGrantExecuteFunctionPrivilege(SecurityContext context, String functionName, Identity grantee, boolean grantOption) {
        AccessDeniedException.denyGrantExecuteFunctionPrivilege((String)functionName, (Identity)context.getIdentity(), (Identity)grantee);
    }

    @Override
    public void checkCanGrantExecuteFunctionPrivilege(SecurityContext context, FunctionKind functionKind, QualifiedObjectName functionName, Identity grantee, boolean grantOption) {
        AccessDeniedException.denyGrantExecuteFunctionPrivilege((String)functionName.toString(), (Identity)context.getIdentity(), (Identity)grantee);
    }

    @Override
    public void checkCanGrantSchemaPrivilege(SecurityContext context, Privilege privilege, CatalogSchemaName schemaName, TrinoPrincipal grantee, boolean grantOption) {
        AccessDeniedException.denyGrantSchemaPrivilege((String)privilege.name(), (String)schemaName.toString());
    }

    @Override
    public void checkCanDenySchemaPrivilege(SecurityContext context, Privilege privilege, CatalogSchemaName schemaName, TrinoPrincipal grantee) {
        AccessDeniedException.denyDenySchemaPrivilege((String)privilege.name(), (String)schemaName.toString());
    }

    @Override
    public void checkCanRevokeSchemaPrivilege(SecurityContext context, Privilege privilege, CatalogSchemaName schemaName, TrinoPrincipal revokee, boolean grantOption) {
        AccessDeniedException.denyRevokeSchemaPrivilege((String)privilege.name(), (String)schemaName.toString());
    }

    @Override
    public void checkCanGrantTablePrivilege(SecurityContext context, Privilege privilege, QualifiedObjectName tableName, TrinoPrincipal grantee, boolean grantOption) {
        AccessDeniedException.denyGrantTablePrivilege((String)privilege.name(), (String)tableName.toString());
    }

    @Override
    public void checkCanDenyTablePrivilege(SecurityContext context, Privilege privilege, QualifiedObjectName tableName, TrinoPrincipal grantee) {
        AccessDeniedException.denyDenyTablePrivilege((String)privilege.name(), (String)tableName.toString());
    }

    @Override
    public void checkCanRevokeTablePrivilege(SecurityContext context, Privilege privilege, QualifiedObjectName tableName, TrinoPrincipal revokee, boolean grantOption) {
        AccessDeniedException.denyRevokeTablePrivilege((String)privilege.name(), (String)tableName.toString());
    }

    @Override
    public void checkCanSetSystemSessionProperty(Identity identity, String propertyName) {
        AccessDeniedException.denySetSystemSessionProperty((String)propertyName);
    }

    @Override
    public void checkCanSetCatalogSessionProperty(SecurityContext context, String catalogName, String propertyName) {
        AccessDeniedException.denySetCatalogSessionProperty((String)catalogName, (String)propertyName);
    }

    @Override
    public void checkCanSelectFromColumns(SecurityContext context, QualifiedObjectName tableName, Set<String> columnNames) {
        AccessDeniedException.denySelectColumns((String)tableName.toString(), columnNames);
    }

    @Override
    public void checkCanCreateRole(SecurityContext context, String role, Optional<TrinoPrincipal> grantor, Optional<String> catalogName) {
        AccessDeniedException.denyCreateRole((String)role);
    }

    @Override
    public void checkCanDropRole(SecurityContext context, String role, Optional<String> catalogName) {
        AccessDeniedException.denyDropRole((String)role);
    }

    @Override
    public void checkCanGrantRoles(SecurityContext context, Set<String> roles, Set<TrinoPrincipal> grantees, boolean adminOption, Optional<TrinoPrincipal> grantor, Optional<String> catalogName) {
        AccessDeniedException.denyGrantRoles(roles, grantees);
    }

    @Override
    public void checkCanRevokeRoles(SecurityContext context, Set<String> roles, Set<TrinoPrincipal> grantees, boolean adminOption, Optional<TrinoPrincipal> grantor, Optional<String> catalogName) {
        AccessDeniedException.denyRevokeRoles(roles, grantees);
    }

    @Override
    public void checkCanSetCatalogRole(SecurityContext context, String role, String catalog) {
        AccessDeniedException.denySetRole((String)role);
    }

    @Override
    public void checkCanShowRoles(SecurityContext context, Optional<String> catalogName) {
        AccessDeniedException.denyShowRoles();
    }

    @Override
    public void checkCanShowCurrentRoles(SecurityContext context, Optional<String> catalogName) {
        AccessDeniedException.denyShowCurrentRoles();
    }

    @Override
    public void checkCanShowRoleGrants(SecurityContext context, Optional<String> catalogName) {
        AccessDeniedException.denyShowRoleGrants();
    }

    @Override
    public void checkCanExecuteProcedure(SecurityContext context, QualifiedObjectName procedureName) {
        AccessDeniedException.denyExecuteProcedure((String)procedureName.toString());
    }

    @Override
    public void checkCanExecuteFunction(SecurityContext context, String functionName) {
        AccessDeniedException.denyExecuteFunction((String)functionName);
    }

    @Override
    public void checkCanExecuteFunction(SecurityContext context, FunctionKind functionKind, QualifiedObjectName functionName) {
        AccessDeniedException.denyExecuteFunction((String)functionName.toString());
    }

    @Override
    public void checkCanExecuteTableProcedure(SecurityContext context, QualifiedObjectName tableName, String procedureName) {
        AccessDeniedException.denyExecuteTableProcedure((String)tableName.toString(), (String)procedureName);
    }
}

