/*
 * Decompiled with CFR 0.152.
 */
package io.trino.split;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.SizeOf;
import io.trino.spi.HostAddress;
import io.trino.spi.connector.CatalogHandle;
import io.trino.spi.connector.ConnectorSplit;
import java.util.List;
import java.util.Objects;

public class EmptySplit
implements ConnectorSplit {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(EmptySplit.class);
    private final CatalogHandle catalogHandle;

    @JsonCreator
    public EmptySplit(@JsonProperty(value="catalogHandle") CatalogHandle catalogHandle) {
        this.catalogHandle = Objects.requireNonNull(catalogHandle, "catalogHandle is null");
    }

    public boolean isRemotelyAccessible() {
        return true;
    }

    public List<HostAddress> getAddresses() {
        return ImmutableList.of();
    }

    public Object getInfo() {
        return this;
    }

    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + this.catalogHandle.getRetainedSizeInBytes();
    }

    @JsonProperty
    public CatalogHandle getCatalogHandle() {
        return this.catalogHandle;
    }
}

