/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.trino.Session;
import io.trino.matching.Capture;
import io.trino.matching.Captures;
import io.trino.matching.Pattern;
import io.trino.metadata.Metadata;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.sql.planner.PlanNodeIdAllocator;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.SymbolAllocator;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.DataOrganizationSpecification;
import io.trino.sql.planner.plan.FilterNode;
import io.trino.sql.planner.plan.LimitNode;
import io.trino.sql.planner.plan.Patterns;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.ProjectNode;
import io.trino.sql.planner.plan.WindowNode;
import io.trino.sql.tree.ComparisonExpression;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.GenericLiteral;
import io.trino.sql.tree.QualifiedName;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class ImplementLimitWithTies
implements Rule<LimitNode> {
    private static final Capture<PlanNode> CHILD = Capture.newCapture();
    private static final Pattern<LimitNode> PATTERN = Patterns.limit().matching(LimitNode::isWithTies).with(Patterns.Limit.requiresPreSortedInputs().equalTo((Object)false)).with(Patterns.source().capturedAs(CHILD));
    private final Metadata metadata;

    public ImplementLimitWithTies(Metadata metadata) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
    }

    @Override
    public Pattern<LimitNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(LimitNode parent, Captures captures, Rule.Context context) {
        PlanNode child = (PlanNode)captures.get(CHILD);
        PlanNode rewritten = ImplementLimitWithTies.rewriteLimitWithTies(parent, child, context.getSession(), this.metadata, context.getIdAllocator(), context.getSymbolAllocator());
        ProjectNode projectNode = new ProjectNode(context.getIdAllocator().getNextId(), rewritten, Assignments.identity(parent.getOutputSymbols()));
        return Rule.Result.ofPlanNode(projectNode);
    }

    private static PlanNode rewriteLimitWithTies(LimitNode limitNode, PlanNode source, Session session, Metadata metadata, PlanNodeIdAllocator idAllocator, SymbolAllocator symbolAllocator) {
        return ImplementLimitWithTies.rewriteLimitWithTiesWithPartitioning(limitNode, source, session, metadata, idAllocator, symbolAllocator, (List<Symbol>)ImmutableList.of());
    }

    public static PlanNode rewriteLimitWithTiesWithPartitioning(LimitNode limitNode, PlanNode source, Session session, Metadata metadata, PlanNodeIdAllocator idAllocator, SymbolAllocator symbolAllocator, List<Symbol> partitionBy) {
        Preconditions.checkArgument((boolean)limitNode.isWithTies(), (Object)"Expected LimitNode with ties");
        Symbol rankSymbol = symbolAllocator.newSymbol("rank_num", (Type)BigintType.BIGINT);
        WindowNode.Function rankFunction = new WindowNode.Function(metadata.resolveFunction(session, QualifiedName.of((String)"rank"), (List<TypeSignatureProvider>)ImmutableList.of()), (List<Expression>)ImmutableList.of(), WindowNode.Frame.DEFAULT_FRAME, false);
        WindowNode windowNode = new WindowNode(idAllocator.getNextId(), source, new DataOrganizationSpecification(partitionBy, limitNode.getTiesResolvingScheme()), (Map<Symbol, WindowNode.Function>)ImmutableMap.of((Object)rankSymbol, (Object)rankFunction), Optional.empty(), (Set<Symbol>)ImmutableSet.of(), 0);
        return new FilterNode(idAllocator.getNextId(), windowNode, (Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, (Expression)rankSymbol.toSymbolReference(), (Expression)new GenericLiteral("BIGINT", Long.toString(limitNode.getCount()))));
    }
}

