/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.sanity;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.trino.Session;
import io.trino.execution.warnings.WarningCollector;
import io.trino.spi.connector.WriterScalingOptions;
import io.trino.sql.PlannerContext;
import io.trino.sql.planner.PartitioningHandle;
import io.trino.sql.planner.TypeAnalyzer;
import io.trino.sql.planner.TypeProvider;
import io.trino.sql.planner.plan.ExchangeNode;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.PlanVisitor;
import io.trino.sql.planner.plan.TableWriterNode;
import io.trino.sql.planner.sanity.PlanSanityChecker;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class ValidateScaledWritersUsage
implements PlanSanityChecker.Checker {
    @Override
    public void validate(PlanNode planNode, Session session, PlannerContext plannerContext, TypeAnalyzer typeAnalyzer, TypeProvider types, WarningCollector warningCollector) {
        planNode.accept(new Visitor(session, plannerContext), null);
    }

    private static class Visitor
    extends PlanVisitor<List<ExchangeNode>, Void> {
        private final Session session;
        private final PlannerContext plannerContext;

        private Visitor(Session session, PlannerContext plannerContext) {
            this.session = Objects.requireNonNull(session, "session is null");
            this.plannerContext = Objects.requireNonNull(plannerContext, "plannerContext is null");
        }

        @Override
        protected List<ExchangeNode> visitPlan(PlanNode node, Void context) {
            return this.collectExchanges(node.getSources());
        }

        @Override
        public List<ExchangeNode> visitTableWriter(TableWriterNode node, Void context) {
            List scaleWriterExchanges = (List)this.collectExchanges(node.getSources()).stream().filter(exchangeNode -> exchangeNode.getPartitioningScheme().getPartitioning().getHandle().isScaleWriters()).collect(ImmutableList.toImmutableList());
            TableWriterNode.WriterTarget target = node.getTarget();
            scaleWriterExchanges.forEach(exchangeNode -> {
                PartitioningHandle handle = exchangeNode.getPartitioningScheme().getPartitioning().getHandle();
                WriterScalingOptions scalingOptions = target.getWriterScalingOptions(this.plannerContext.getMetadata(), this.session);
                if (exchangeNode.getScope() == ExchangeNode.Scope.LOCAL) {
                    Preconditions.checkState((boolean)scalingOptions.isPerTaskWriterScalingEnabled(), (String)"The scaled writer per task partitioning scheme is set but writer target %s doesn't support it", (Object)target);
                }
                if (exchangeNode.getScope() == ExchangeNode.Scope.REMOTE) {
                    Preconditions.checkState((boolean)scalingOptions.isWriterTasksScalingEnabled(), (String)"The scaled writer across tasks partitioning scheme is set but writer target %s doesn't support it", (Object)target);
                }
                if (PartitioningHandle.isScaledWriterHashDistribution(handle)) {
                    Preconditions.checkState((boolean)target.supportsMultipleWritersPerPartition(this.plannerContext.getMetadata(), this.session), (String)"The hash scaled writer partitioning scheme is set for the partitioned write but writer target %s doesn't support multiple writers per partition", (Object)target);
                }
            });
            return scaleWriterExchanges;
        }

        @Override
        public List<ExchangeNode> visitExchange(ExchangeNode node, Void context) {
            return ImmutableList.builder().add((Object)node).addAll(this.collectExchanges(node.getSources())).build();
        }

        private List<ExchangeNode> collectExchanges(List<PlanNode> nodes) {
            return nodes.stream().map(node -> node.accept(this, null)).flatMap(Collection::stream).filter(Objects::nonNull).collect(Collectors.toList());
        }
    }
}

