/*
 * Decompiled with CFR 0.152.
 */
package io.trino.testing;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.Closer;
import com.google.common.util.concurrent.MoreExecutors;
import io.airlift.concurrent.MoreFutures;
import io.airlift.concurrent.Threads;
import io.airlift.node.NodeInfo;
import io.airlift.tracing.Tracing;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.Tracer;
import io.trino.FeaturesConfig;
import io.trino.Session;
import io.trino.SystemSessionProperties;
import io.trino.SystemSessionPropertiesProvider;
import io.trino.client.NodeVersion;
import io.trino.connector.CatalogFactory;
import io.trino.connector.CatalogServiceProviderModule;
import io.trino.connector.ConnectorName;
import io.trino.connector.ConnectorServicesProvider;
import io.trino.connector.CoordinatorDynamicCatalogManager;
import io.trino.connector.DefaultCatalogFactory;
import io.trino.connector.InMemoryCatalogStore;
import io.trino.connector.LazyCatalogFactory;
import io.trino.connector.system.AnalyzePropertiesSystemTable;
import io.trino.connector.system.CatalogSystemTable;
import io.trino.connector.system.ColumnPropertiesSystemTable;
import io.trino.connector.system.GlobalSystemConnector;
import io.trino.connector.system.MaterializedViewPropertiesSystemTable;
import io.trino.connector.system.MaterializedViewSystemTable;
import io.trino.connector.system.NodeSystemTable;
import io.trino.connector.system.SchemaPropertiesSystemTable;
import io.trino.connector.system.TableCommentSystemTable;
import io.trino.connector.system.TablePropertiesSystemTable;
import io.trino.connector.system.TransactionsSystemTable;
import io.trino.cost.ComposableStatsCalculator;
import io.trino.cost.CostCalculator;
import io.trino.cost.CostCalculatorUsingExchanges;
import io.trino.cost.CostCalculatorWithEstimatedExchanges;
import io.trino.cost.CostComparator;
import io.trino.cost.FilterStatsCalculator;
import io.trino.cost.ScalarStatsCalculator;
import io.trino.cost.StatsCalculator;
import io.trino.cost.StatsCalculatorModule;
import io.trino.cost.StatsNormalizer;
import io.trino.cost.TaskCountEstimator;
import io.trino.eventlistener.EventListenerConfig;
import io.trino.eventlistener.EventListenerManager;
import io.trino.exchange.ExchangeManagerRegistry;
import io.trino.execution.DynamicFilterConfig;
import io.trino.execution.FailureInjector;
import io.trino.execution.NodeTaskMap;
import io.trino.execution.ParameterExtractor;
import io.trino.execution.QueryManagerConfig;
import io.trino.execution.QueryPreparer;
import io.trino.execution.ScheduledSplit;
import io.trino.execution.SplitAssignment;
import io.trino.execution.TableExecuteContextManager;
import io.trino.execution.TaskManagerConfig;
import io.trino.execution.querystats.PlanOptimizersStatsCollector;
import io.trino.execution.resourcegroups.NoOpResourceGroupManager;
import io.trino.execution.scheduler.NodeScheduler;
import io.trino.execution.scheduler.NodeSchedulerConfig;
import io.trino.execution.scheduler.UniformNodeSelectorFactory;
import io.trino.execution.warnings.WarningCollector;
import io.trino.index.IndexManager;
import io.trino.memory.MemoryManagerConfig;
import io.trino.memory.NodeMemoryConfig;
import io.trino.metadata.AnalyzePropertyManager;
import io.trino.metadata.BlockEncodingManager;
import io.trino.metadata.CatalogManager;
import io.trino.metadata.ColumnPropertyManager;
import io.trino.metadata.DisabledSystemSecurityMetadata;
import io.trino.metadata.FunctionBundle;
import io.trino.metadata.FunctionManager;
import io.trino.metadata.GlobalFunctionCatalog;
import io.trino.metadata.HandleResolver;
import io.trino.metadata.InMemoryNodeManager;
import io.trino.metadata.InternalBlockEncodingSerde;
import io.trino.metadata.InternalFunctionBundle;
import io.trino.metadata.InternalNode;
import io.trino.metadata.InternalNodeManager;
import io.trino.metadata.LiteralFunction;
import io.trino.metadata.MaterializedViewPropertyManager;
import io.trino.metadata.Metadata;
import io.trino.metadata.MetadataManager;
import io.trino.metadata.MetadataUtil;
import io.trino.metadata.QualifiedObjectName;
import io.trino.metadata.QualifiedTablePrefix;
import io.trino.metadata.SchemaPropertyManager;
import io.trino.metadata.SessionPropertyManager;
import io.trino.metadata.Split;
import io.trino.metadata.SystemFunctionBundle;
import io.trino.metadata.SystemSecurityMetadata;
import io.trino.metadata.TableFunctionRegistry;
import io.trino.metadata.TableHandle;
import io.trino.metadata.TableProceduresPropertyManager;
import io.trino.metadata.TableProceduresRegistry;
import io.trino.metadata.TablePropertyManager;
import io.trino.metadata.TypeRegistry;
import io.trino.operator.Driver;
import io.trino.operator.DriverContext;
import io.trino.operator.DriverFactory;
import io.trino.operator.GroupByHashPageIndexerFactory;
import io.trino.operator.OperatorContext;
import io.trino.operator.OutputFactory;
import io.trino.operator.PagesIndex;
import io.trino.operator.PagesIndexPageSorter;
import io.trino.operator.TaskContext;
import io.trino.operator.index.IndexJoinLookupStats;
import io.trino.operator.scalar.json.JsonExistsFunction;
import io.trino.operator.scalar.json.JsonQueryFunction;
import io.trino.operator.scalar.json.JsonValueFunction;
import io.trino.operator.table.ExcludeColumns;
import io.trino.security.GroupProviderManager;
import io.trino.server.PluginManager;
import io.trino.server.SessionPropertyDefaults;
import io.trino.server.security.CertificateAuthenticatorManager;
import io.trino.server.security.HeaderAuthenticatorConfig;
import io.trino.server.security.HeaderAuthenticatorManager;
import io.trino.server.security.PasswordAuthenticatorConfig;
import io.trino.server.security.PasswordAuthenticatorManager;
import io.trino.spi.ErrorType;
import io.trino.spi.Plugin;
import io.trino.spi.connector.CatalogHandle;
import io.trino.spi.connector.ConnectorFactory;
import io.trino.spi.connector.Constraint;
import io.trino.spi.connector.DynamicFilter;
import io.trino.spi.connector.SystemTable;
import io.trino.spi.exchange.ExchangeManager;
import io.trino.spi.function.table.ConnectorTableFunction;
import io.trino.spi.procedure.Procedure;
import io.trino.spi.session.PropertyMetadata;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.TypeOperators;
import io.trino.spiller.FileSingleStreamSpillerFactory;
import io.trino.spiller.GenericPartitioningSpillerFactory;
import io.trino.spiller.GenericSpillerFactory;
import io.trino.spiller.NodeSpillConfig;
import io.trino.spiller.PartitioningSpillerFactory;
import io.trino.spiller.SpillerFactory;
import io.trino.spiller.SpillerStats;
import io.trino.split.PageSinkManager;
import io.trino.split.PageSourceManager;
import io.trino.split.SplitManager;
import io.trino.split.SplitSource;
import io.trino.sql.ParsingUtil;
import io.trino.sql.PlannerContext;
import io.trino.sql.analyzer.Analysis;
import io.trino.sql.analyzer.Analyzer;
import io.trino.sql.analyzer.AnalyzerFactory;
import io.trino.sql.analyzer.QueryExplainer;
import io.trino.sql.analyzer.QueryExplainerFactory;
import io.trino.sql.analyzer.SessionTimeProvider;
import io.trino.sql.analyzer.StatementAnalyzerFactory;
import io.trino.sql.gen.ExpressionCompiler;
import io.trino.sql.gen.JoinCompiler;
import io.trino.sql.gen.JoinFilterFunctionCompiler;
import io.trino.sql.gen.OrderingCompiler;
import io.trino.sql.gen.PageFunctionCompiler;
import io.trino.sql.parser.ParsingOptions;
import io.trino.sql.parser.SqlParser;
import io.trino.sql.planner.LocalExecutionPlanner;
import io.trino.sql.planner.LogicalPlanner;
import io.trino.sql.planner.NodePartitioningManager;
import io.trino.sql.planner.OptimizerConfig;
import io.trino.sql.planner.Plan;
import io.trino.sql.planner.PlanFragmenter;
import io.trino.sql.planner.PlanNodeIdAllocator;
import io.trino.sql.planner.PlanOptimizers;
import io.trino.sql.planner.RuleStatsRecorder;
import io.trino.sql.planner.SubPlan;
import io.trino.sql.planner.TypeAnalyzer;
import io.trino.sql.planner.optimizations.PlanNodeSearcher;
import io.trino.sql.planner.optimizations.PlanOptimizer;
import io.trino.sql.planner.plan.OutputNode;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.sql.planner.plan.TableScanNode;
import io.trino.sql.planner.planprinter.PlanPrinter;
import io.trino.sql.planner.sanity.PlanSanityChecker;
import io.trino.sql.rewrite.DescribeInputRewrite;
import io.trino.sql.rewrite.DescribeOutputRewrite;
import io.trino.sql.rewrite.ExplainRewrite;
import io.trino.sql.rewrite.ShowQueriesRewrite;
import io.trino.sql.rewrite.ShowStatsRewrite;
import io.trino.sql.rewrite.StatementRewrite;
import io.trino.sql.testing.TreeAssertions;
import io.trino.sql.tree.Node;
import io.trino.testing.MaterializedResult;
import io.trino.testing.PageConsumerOperator;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingAccessControlManager;
import io.trino.testing.TestingGroupProviderManager;
import io.trino.testing.TestingTaskContext;
import io.trino.transaction.InMemoryTransactionManager;
import io.trino.transaction.TransactionBuilder;
import io.trino.transaction.TransactionId;
import io.trino.transaction.TransactionManager;
import io.trino.transaction.TransactionManagerConfig;
import io.trino.type.BlockTypeOperators;
import io.trino.type.InternalTypeManager;
import io.trino.type.JsonPath2016Type;
import io.trino.type.TypeDeserializer;
import io.trino.util.FinalizerService;
import io.trino.version.EmbedVersion;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Function;
import org.intellij.lang.annotations.Language;

public class LocalQueryRunner
implements QueryRunner {
    private final EventListenerManager eventListenerManager = new EventListenerManager(new EventListenerConfig());
    private final Session defaultSession;
    private final ExecutorService notificationExecutor;
    private final ScheduledExecutorService yieldExecutor;
    private final FinalizerService finalizerService;
    private final SqlParser sqlParser;
    private final PlanFragmenter planFragmenter;
    private final InternalNodeManager nodeManager;
    private final TypeOperators typeOperators;
    private final BlockTypeOperators blockTypeOperators;
    private final PlannerContext plannerContext;
    private final TypeRegistry typeRegistry;
    private final GlobalFunctionCatalog globalFunctionCatalog;
    private final FunctionManager functionManager;
    private final StatsCalculator statsCalculator;
    private final ScalarStatsCalculator scalarStatsCalculator;
    private final CostCalculator costCalculator;
    private final CostCalculator estimatedExchangesCostCalculator;
    private final TaskCountEstimator taskCountEstimator;
    private final TestingGroupProviderManager groupProvider;
    private final TestingAccessControlManager accessControl;
    private final SplitManager splitManager;
    private final PageSourceManager pageSourceManager;
    private final IndexManager indexManager;
    private final NodePartitioningManager nodePartitioningManager;
    private final PageSinkManager pageSinkManager;
    private final TransactionManager transactionManager;
    private final FileSingleStreamSpillerFactory singleStreamSpillerFactory;
    private final SpillerFactory spillerFactory;
    private final PartitioningSpillerFactory partitioningSpillerFactory;
    private final SessionPropertyManager sessionPropertyManager;
    private final SchemaPropertyManager schemaPropertyManager;
    private final ColumnPropertyManager columnPropertyManager;
    private final TablePropertyManager tablePropertyManager;
    private final MaterializedViewPropertyManager materializedViewPropertyManager;
    private final AnalyzePropertyManager analyzePropertyManager;
    private final PageFunctionCompiler pageFunctionCompiler;
    private final ExpressionCompiler expressionCompiler;
    private final JoinFilterFunctionCompiler joinFilterFunctionCompiler;
    private final JoinCompiler joinCompiler;
    private final CatalogFactory catalogFactory;
    private final CoordinatorDynamicCatalogManager catalogManager;
    private final PluginManager pluginManager;
    private final ExchangeManagerRegistry exchangeManagerRegistry;
    private final TaskManagerConfig taskManagerConfig;
    private final boolean alwaysRevokeMemory;
    private final DataSize maxSpillPerNode;
    private final DataSize queryMaxSpillPerNode;
    private final OptimizerConfig optimizerConfig;
    private final StatementAnalyzerFactory statementAnalyzerFactory;
    private boolean printPlan;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();

    public static LocalQueryRunner create(Session defaultSession) {
        return LocalQueryRunner.builder(defaultSession).build();
    }

    public static Builder builder(Session defaultSession) {
        return new Builder(defaultSession);
    }

    private LocalQueryRunner(Session defaultSession, FeaturesConfig featuresConfig, NodeSpillConfig nodeSpillConfig, boolean withInitialTransaction, boolean alwaysRevokeMemory, int nodeCountForStats, Map<String, List<PropertyMetadata<?>>> defaultSessionProperties, MetadataProvider metadataProvider, Set<SystemSessionPropertiesProvider> extraSessionProperties) {
        Objects.requireNonNull(defaultSession, "defaultSession is null");
        Objects.requireNonNull(defaultSessionProperties, "defaultSessionProperties is null");
        Preconditions.checkArgument((defaultSession.getTransactionId().isEmpty() || !withInitialTransaction ? 1 : 0) != 0, (Object)"Already in transaction");
        Tracer tracer = Tracing.noopTracer();
        this.taskManagerConfig = new TaskManagerConfig().setTaskConcurrency(4);
        Objects.requireNonNull(nodeSpillConfig, "nodeSpillConfig is null");
        this.maxSpillPerNode = nodeSpillConfig.getMaxSpillPerNode();
        this.queryMaxSpillPerNode = nodeSpillConfig.getQueryMaxSpillPerNode();
        this.alwaysRevokeMemory = alwaysRevokeMemory;
        this.notificationExecutor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"local-query-runner-executor-%s"));
        this.yieldExecutor = Executors.newScheduledThreadPool(2, Threads.daemonThreadsNamed((String)"local-query-runner-scheduler-%s"));
        this.finalizerService = new FinalizerService();
        this.finalizerService.start();
        this.typeOperators = new TypeOperators();
        this.blockTypeOperators = new BlockTypeOperators(this.typeOperators);
        this.sqlParser = new SqlParser();
        this.nodeManager = new InMemoryNodeManager(new InternalNode[0]);
        PagesIndexPageSorter pageSorter = new PagesIndexPageSorter(new PagesIndex.TestingFactory(false));
        NodeSchedulerConfig nodeSchedulerConfig = new NodeSchedulerConfig().setIncludeCoordinator(true);
        Objects.requireNonNull(featuresConfig, "featuresConfig is null");
        this.optimizerConfig = new OptimizerConfig();
        LazyCatalogFactory catalogFactory = new LazyCatalogFactory();
        this.catalogFactory = catalogFactory;
        this.catalogManager = new CoordinatorDynamicCatalogManager(new InMemoryCatalogStore(), catalogFactory, MoreExecutors.directExecutor());
        this.transactionManager = InMemoryTransactionManager.create(new TransactionManagerConfig().setIdleTimeout(new Duration(1.0, TimeUnit.DAYS)), this.yieldExecutor, this.catalogManager, this.notificationExecutor);
        BlockEncodingManager blockEncodingManager = new BlockEncodingManager();
        this.typeRegistry = new TypeRegistry(this.typeOperators, featuresConfig);
        InternalTypeManager typeManager = new InternalTypeManager(this.typeRegistry);
        InternalBlockEncodingSerde blockEncodingSerde = new InternalBlockEncodingSerde(blockEncodingManager, typeManager);
        this.globalFunctionCatalog = new GlobalFunctionCatalog();
        this.globalFunctionCatalog.addFunctions(new InternalFunctionBundle(new LiteralFunction(blockEncodingSerde)));
        this.globalFunctionCatalog.addFunctions(SystemFunctionBundle.create(featuresConfig, this.typeOperators, this.blockTypeOperators, this.nodeManager.getCurrentNode().getNodeVersion()));
        Metadata metadata = metadataProvider.getMetadata(new DisabledSystemSecurityMetadata(), this.transactionManager, this.globalFunctionCatalog, typeManager);
        this.typeRegistry.addType((Type)new JsonPath2016Type(new TypeDeserializer(typeManager), blockEncodingSerde));
        this.joinCompiler = new JoinCompiler(this.typeOperators);
        GroupByHashPageIndexerFactory pageIndexerFactory = new GroupByHashPageIndexerFactory(this.joinCompiler, this.typeOperators);
        this.groupProvider = new TestingGroupProviderManager();
        this.accessControl = new TestingAccessControlManager(this.transactionManager, this.eventListenerManager);
        this.accessControl.loadSystemAccessControl("allow-all", (Map<String, String>)ImmutableMap.of());
        HandleResolver handleResolver = new HandleResolver();
        NodeInfo nodeInfo = new NodeInfo("test");
        catalogFactory.setCatalogFactory(new DefaultCatalogFactory(metadata, this.accessControl, handleResolver, this.nodeManager, pageSorter, pageIndexerFactory, nodeInfo, EmbedVersion.testingVersionEmbedder(), OpenTelemetry.noop(), this.transactionManager, typeManager, nodeSchedulerConfig, this.optimizerConfig));
        this.splitManager = new SplitManager(CatalogServiceProviderModule.createSplitManagerProvider(this.catalogManager), tracer, new QueryManagerConfig());
        this.pageSourceManager = new PageSourceManager(CatalogServiceProviderModule.createPageSourceProvider(this.catalogManager));
        this.pageSinkManager = new PageSinkManager(CatalogServiceProviderModule.createPageSinkProvider(this.catalogManager));
        this.indexManager = new IndexManager(CatalogServiceProviderModule.createIndexProvider(this.catalogManager));
        NodeScheduler nodeScheduler = new NodeScheduler(new UniformNodeSelectorFactory(this.nodeManager, nodeSchedulerConfig, new NodeTaskMap(this.finalizerService)));
        this.sessionPropertyManager = LocalQueryRunner.createSessionPropertyManager(this.catalogManager, extraSessionProperties, this.taskManagerConfig, featuresConfig, this.optimizerConfig);
        this.nodePartitioningManager = new NodePartitioningManager(nodeScheduler, this.typeOperators, CatalogServiceProviderModule.createNodePartitioningProvider(this.catalogManager));
        TableProceduresRegistry tableProceduresRegistry = new TableProceduresRegistry(CatalogServiceProviderModule.createTableProceduresProvider(this.catalogManager));
        this.functionManager = new FunctionManager(CatalogServiceProviderModule.createFunctionProvider(this.catalogManager), this.globalFunctionCatalog);
        TableFunctionRegistry tableFunctionRegistry = new TableFunctionRegistry(CatalogServiceProviderModule.createTableFunctionProvider(this.catalogManager));
        this.schemaPropertyManager = CatalogServiceProviderModule.createSchemaPropertyManager(this.catalogManager);
        this.columnPropertyManager = CatalogServiceProviderModule.createColumnPropertyManager(this.catalogManager);
        this.tablePropertyManager = CatalogServiceProviderModule.createTablePropertyManager(this.catalogManager);
        this.materializedViewPropertyManager = CatalogServiceProviderModule.createMaterializedViewPropertyManager(this.catalogManager);
        this.analyzePropertyManager = CatalogServiceProviderModule.createAnalyzePropertyManager(this.catalogManager);
        TableProceduresPropertyManager tableProceduresPropertyManager = CatalogServiceProviderModule.createTableProceduresPropertyManager(this.catalogManager);
        this.accessControl.setConnectorAccessControlProvider(CatalogServiceProviderModule.createAccessControlProvider(this.catalogManager));
        this.globalFunctionCatalog.addFunctions(new InternalFunctionBundle(new JsonExistsFunction(this.functionManager, metadata, typeManager), new JsonValueFunction(this.functionManager, metadata, typeManager), new JsonQueryFunction(this.functionManager, metadata, typeManager)));
        this.plannerContext = new PlannerContext(metadata, this.typeOperators, blockEncodingSerde, typeManager, this.functionManager, tracer);
        this.pageFunctionCompiler = new PageFunctionCompiler(this.functionManager, 0);
        this.expressionCompiler = new ExpressionCompiler(this.functionManager, this.pageFunctionCompiler);
        this.joinFilterFunctionCompiler = new JoinFilterFunctionCompiler(this.functionManager);
        this.statementAnalyzerFactory = new StatementAnalyzerFactory(this.plannerContext, this.sqlParser, SessionTimeProvider.DEFAULT, this.accessControl, this.transactionManager, this.groupProvider, tableProceduresRegistry, tableFunctionRegistry, this.sessionPropertyManager, this.tablePropertyManager, this.analyzePropertyManager, tableProceduresPropertyManager);
        TypeAnalyzer typeAnalyzer = new TypeAnalyzer(this.plannerContext, this.statementAnalyzerFactory);
        this.statsCalculator = LocalQueryRunner.createNewStatsCalculator(this.plannerContext, typeAnalyzer);
        this.scalarStatsCalculator = new ScalarStatsCalculator(this.plannerContext, typeAnalyzer);
        this.taskCountEstimator = new TaskCountEstimator(() -> nodeCountForStats);
        this.costCalculator = new CostCalculatorUsingExchanges(this.taskCountEstimator);
        this.estimatedExchangesCostCalculator = new CostCalculatorWithEstimatedExchanges(this.costCalculator, this.taskCountEstimator);
        this.planFragmenter = new PlanFragmenter(metadata, this.functionManager, this.transactionManager, this.catalogManager, new QueryManagerConfig());
        GlobalSystemConnector globalSystemConnector = new GlobalSystemConnector((Set<SystemTable>)ImmutableSet.of((Object)new NodeSystemTable(this.nodeManager), (Object)new CatalogSystemTable(metadata, this.accessControl), (Object)new TableCommentSystemTable(metadata, this.accessControl), (Object)new MaterializedViewSystemTable(metadata, this.accessControl), (Object)new SchemaPropertiesSystemTable(metadata, this.accessControl, this.schemaPropertyManager), (Object)new TablePropertiesSystemTable(metadata, this.accessControl, this.tablePropertyManager), (Object[])new SystemTable[]{new MaterializedViewPropertiesSystemTable(metadata, this.accessControl, this.materializedViewPropertyManager), new ColumnPropertiesSystemTable(metadata, this.accessControl, this.columnPropertyManager), new AnalyzePropertiesSystemTable(metadata, this.accessControl, this.analyzePropertyManager), new TransactionsSystemTable(typeManager, this.transactionManager)}), (Set<Procedure>)ImmutableSet.of(), (Set<ConnectorTableFunction>)ImmutableSet.of((Object)((Object)new ExcludeColumns.ExcludeColumnsFunction())));
        this.exchangeManagerRegistry = new ExchangeManagerRegistry();
        this.pluginManager = new PluginManager((loader, createClassLoader) -> {}, catalogFactory, this.globalFunctionCatalog, new NoOpResourceGroupManager(), this.accessControl, Optional.of(new PasswordAuthenticatorManager(new PasswordAuthenticatorConfig())), new CertificateAuthenticatorManager(), Optional.of(new HeaderAuthenticatorManager(new HeaderAuthenticatorConfig())), this.eventListenerManager, new GroupProviderManager(), new SessionPropertyDefaults(nodeInfo, this.accessControl), this.typeRegistry, blockEncodingManager, handleResolver, this.exchangeManagerRegistry);
        this.catalogManager.registerGlobalSystemConnector(globalSystemConnector);
        Optional<TransactionId> transactionId = withInitialTransaction ? Optional.of(this.transactionManager.beginTransaction(true)) : defaultSession.getTransactionId();
        this.defaultSession = new Session(defaultSession.getQueryId(), Span.getInvalid(), transactionId, defaultSession.isClientTransactionSupport(), defaultSession.getIdentity(), defaultSession.getSource(), defaultSession.getCatalog(), defaultSession.getSchema(), defaultSession.getPath(), defaultSession.getTraceToken(), defaultSession.getTimeZoneKey(), defaultSession.getLocale(), defaultSession.getRemoteUserAddress(), defaultSession.getUserAgent(), defaultSession.getClientInfo(), defaultSession.getClientTags(), defaultSession.getClientCapabilities(), defaultSession.getResourceEstimates(), defaultSession.getStart(), defaultSession.getSystemProperties(), defaultSession.getCatalogProperties(), this.sessionPropertyManager, defaultSession.getPreparedStatements(), defaultSession.getProtocolHeaders(), defaultSession.getExchangeEncryptionKey());
        SpillerStats spillerStats = new SpillerStats();
        this.singleStreamSpillerFactory = new FileSingleStreamSpillerFactory(this.plannerContext.getBlockEncodingSerde(), spillerStats, featuresConfig, nodeSpillConfig);
        this.partitioningSpillerFactory = new GenericPartitioningSpillerFactory(this.singleStreamSpillerFactory);
        this.spillerFactory = new GenericSpillerFactory(this.singleStreamSpillerFactory);
    }

    private static SessionPropertyManager createSessionPropertyManager(ConnectorServicesProvider connectorServicesProvider, Set<SystemSessionPropertiesProvider> extraSessionProperties, TaskManagerConfig taskManagerConfig, FeaturesConfig featuresConfig, OptimizerConfig optimizerConfig) {
        ImmutableSet systemSessionProperties = ImmutableSet.builder().addAll((Iterable)Objects.requireNonNull(extraSessionProperties, "extraSessionProperties is null")).add((Object)new SystemSessionProperties(new QueryManagerConfig(), taskManagerConfig, new MemoryManagerConfig(), featuresConfig, optimizerConfig, new NodeMemoryConfig(), new DynamicFilterConfig(), new NodeSchedulerConfig())).build();
        return CatalogServiceProviderModule.createSessionPropertyManager((Set<SystemSessionPropertiesProvider>)systemSessionProperties, connectorServicesProvider);
    }

    private static StatsCalculator createNewStatsCalculator(PlannerContext plannerContext, TypeAnalyzer typeAnalyzer) {
        StatsNormalizer normalizer = new StatsNormalizer();
        ScalarStatsCalculator scalarStatsCalculator = new ScalarStatsCalculator(plannerContext, typeAnalyzer);
        FilterStatsCalculator filterStatsCalculator = new FilterStatsCalculator(plannerContext, scalarStatsCalculator, normalizer);
        return new ComposableStatsCalculator((List<ComposableStatsCalculator.Rule<?>>)new StatsCalculatorModule.StatsRulesProvider(plannerContext, scalarStatsCalculator, filterStatsCalculator, normalizer).get());
    }

    @Override
    public void close() {
        this.notificationExecutor.shutdownNow();
        this.yieldExecutor.shutdownNow();
        this.catalogManager.stop();
        this.finalizerService.destroy();
        this.singleStreamSpillerFactory.destroy();
    }

    public void loadEventListeners() {
        this.eventListenerManager.loadEventListeners();
    }

    @Override
    public int getNodeCount() {
        return 1;
    }

    @Override
    public TransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public SqlParser getSqlParser() {
        return this.sqlParser;
    }

    public PlannerContext getPlannerContext() {
        return this.plannerContext;
    }

    @Override
    public Metadata getMetadata() {
        return this.plannerContext.getMetadata();
    }

    public TablePropertyManager getTablePropertyManager() {
        return this.tablePropertyManager;
    }

    public ColumnPropertyManager getColumnPropertyManager() {
        return this.columnPropertyManager;
    }

    public MaterializedViewPropertyManager getMaterializedViewPropertyManager() {
        return this.materializedViewPropertyManager;
    }

    public AnalyzePropertyManager getAnalyzePropertyManager() {
        return this.analyzePropertyManager;
    }

    public TypeRegistry getTypeRegistry() {
        return this.typeRegistry;
    }

    @Override
    public TypeManager getTypeManager() {
        return this.plannerContext.getTypeManager();
    }

    public GlobalFunctionCatalog getGlobalFunctionCatalog() {
        return this.globalFunctionCatalog;
    }

    @Override
    public QueryExplainer getQueryExplainer() {
        QueryExplainerFactory queryExplainerFactory = this.createQueryExplainerFactory(this.getPlanOptimizers(true));
        AnalyzerFactory analyzerFactory = this.createAnalyzerFactory(queryExplainerFactory);
        return queryExplainerFactory.createQueryExplainer(analyzerFactory);
    }

    @Override
    public SessionPropertyManager getSessionPropertyManager() {
        return this.sessionPropertyManager;
    }

    @Override
    public FunctionManager getFunctionManager() {
        return this.functionManager;
    }

    public TypeOperators getTypeOperators() {
        return this.plannerContext.getTypeOperators();
    }

    public BlockTypeOperators getBlockTypeOperators() {
        return this.blockTypeOperators;
    }

    @Override
    public NodePartitioningManager getNodePartitioningManager() {
        return this.nodePartitioningManager;
    }

    @Override
    public PageSourceManager getPageSourceManager() {
        return this.pageSourceManager;
    }

    @Override
    public SplitManager getSplitManager() {
        return this.splitManager;
    }

    @Override
    public ExchangeManager getExchangeManager() {
        return this.exchangeManagerRegistry.getExchangeManager();
    }

    @Override
    public StatsCalculator getStatsCalculator() {
        return this.statsCalculator;
    }

    public CostCalculator getCostCalculator() {
        return this.costCalculator;
    }

    public CostCalculator getEstimatedExchangesCostCalculator() {
        return this.estimatedExchangesCostCalculator;
    }

    public TaskCountEstimator getTaskCountEstimator() {
        return this.taskCountEstimator;
    }

    @Override
    public TestingGroupProviderManager getGroupProvider() {
        return this.groupProvider;
    }

    @Override
    public TestingAccessControlManager getAccessControl() {
        return this.accessControl;
    }

    public ExecutorService getExecutor() {
        return this.notificationExecutor;
    }

    public ScheduledExecutorService getScheduler() {
        return this.yieldExecutor;
    }

    @Override
    public Session getDefaultSession() {
        return this.defaultSession;
    }

    public ExpressionCompiler getExpressionCompiler() {
        return this.expressionCompiler;
    }

    public void createCatalog(String catalogName, ConnectorFactory connectorFactory, Map<String, String> properties) {
        this.catalogFactory.addConnectorFactory(connectorFactory, ignored -> connectorFactory.getClass().getClassLoader());
        this.catalogManager.createCatalog(catalogName, new ConnectorName(connectorFactory.getName()), properties, false);
    }

    public void registerCatalogFactory(ConnectorFactory connectorFactory) {
        this.catalogFactory.addConnectorFactory(connectorFactory, ignored -> connectorFactory.getClass().getClassLoader());
    }

    @Override
    public void installPlugin(Plugin plugin) {
        this.pluginManager.installPlugin(plugin, ignored -> plugin.getClass().getClassLoader());
    }

    @Override
    public void addFunctions(FunctionBundle functionBundle) {
        this.globalFunctionCatalog.addFunctions(functionBundle);
    }

    @Override
    public void createCatalog(String catalogName, String connectorName, Map<String, String> properties) {
        this.catalogManager.createCatalog(catalogName, new ConnectorName(connectorName), properties, false);
    }

    public CatalogManager getCatalogManager() {
        return this.catalogManager;
    }

    public LocalQueryRunner printPlan() {
        this.printPlan = true;
        return this;
    }

    public CatalogHandle getCatalogHandle(String catalogName) {
        return (CatalogHandle)this.inTransaction(transactionSession -> this.getMetadata().getCatalogHandle((Session)transactionSession, catalogName)).orElseThrow();
    }

    public TableHandle getTableHandle(String catalogName, String schemaName, String tableName) {
        return this.inTransaction(transactionSession -> this.getMetadata().getTableHandle((Session)transactionSession, new QualifiedObjectName(catalogName, schemaName, tableName)).orElseThrow());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<QualifiedObjectName> listTables(Session session, String catalog, String schema) {
        this.lock.readLock().lock();
        try {
            List list = TransactionBuilder.transaction(this.transactionManager, this.accessControl).readOnly().execute(session, (Session transactionSession) -> this.getMetadata().listTables((Session)transactionSession, new QualifiedTablePrefix(catalog, schema)));
            return list;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean tableExists(Session session, String table) {
        this.lock.readLock().lock();
        try {
            boolean bl = TransactionBuilder.transaction(this.transactionManager, this.accessControl).readOnly().execute(session, (Session transactionSession) -> MetadataUtil.tableExists(this.getMetadata(), transactionSession, table));
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public MaterializedResult execute(@Language(value="SQL") String sql) {
        return this.execute(this.defaultSession, sql);
    }

    @Override
    public MaterializedResult execute(Session session, @Language(value="SQL") String sql) {
        return this.executeWithPlan(session, sql, WarningCollector.NOOP).getMaterializedResult();
    }

    @Override
    public QueryRunner.MaterializedResultWithPlan executeWithPlan(Session session, String sql, WarningCollector warningCollector) {
        return this.inTransaction(session, transactionSession -> this.executeInternal((Session)transactionSession, sql));
    }

    public <T> T inTransaction(Function<Session, T> transactionSessionConsumer) {
        return this.inTransaction(this.defaultSession, transactionSessionConsumer);
    }

    public <T> T inTransaction(Session session, Function<Session, T> transactionSessionConsumer) {
        return TransactionBuilder.transaction(this.transactionManager, this.accessControl).singleStatement().execute(session, transactionSessionConsumer);
    }

    private QueryRunner.MaterializedResultWithPlan executeInternal(Session session, @Language(value="SQL") String sql) {
        this.lock.readLock().lock();
        try {
            QueryRunner.MaterializedResultWithPlan materializedResultWithPlan;
            block14: {
                Closer closer = Closer.create();
                try {
                    this.accessControl.checkCanExecuteQuery(session.getIdentity());
                    AtomicReference builder = new AtomicReference();
                    PageConsumerOperator.PageConsumerOutputFactory outputFactory = new PageConsumerOperator.PageConsumerOutputFactory(types -> {
                        builder.compareAndSet(null, MaterializedResult.resultBuilder(session, (Iterable<? extends Type>)types));
                        return ((MaterializedResult.Builder)builder.get())::page;
                    });
                    TaskContext taskContext = TestingTaskContext.builder(this.notificationExecutor, this.yieldExecutor, session).setMaxSpillSize(this.maxSpillPerNode).setQueryMaxSpillSize(this.queryMaxSpillPerNode).build();
                    Plan plan = this.createPlan(session, sql, WarningCollector.NOOP, PlanOptimizersStatsCollector.createPlanOptimizersStatsCollector());
                    List<Driver> drivers = this.createDrivers(session, plan, (OutputFactory)outputFactory, taskContext);
                    drivers.forEach(arg_0 -> ((Closer)closer).register(arg_0));
                    boolean done = false;
                    while (!done) {
                        boolean processed = false;
                        for (Driver driver : drivers) {
                            if (this.alwaysRevokeMemory) {
                                driver.getDriverContext().getOperatorContexts().stream().filter(operatorContext -> operatorContext.getNestedOperatorStats().stream().mapToLong(stats -> stats.getRevocableMemoryReservation().toBytes()).sum() > 0L).forEach(OperatorContext::requestMemoryRevoking);
                            }
                            if (driver.isFinished()) continue;
                            driver.processForNumberOfIterations(1);
                            processed = true;
                        }
                        done = !processed;
                    }
                    Verify.verify((builder.get() != null ? 1 : 0) != 0, (String)"Output operator was not created", (Object[])new Object[0]);
                    ((MaterializedResult.Builder)builder.get()).columnNames(((OutputNode)plan.getRoot()).getColumnNames());
                    materializedResultWithPlan = new QueryRunner.MaterializedResultWithPlan(((MaterializedResult.Builder)builder.get()).build(), plan);
                    if (closer == null) break block14;
                }
                catch (Throwable throwable) {
                    try {
                        if (closer != null) {
                            try {
                                closer.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
                closer.close();
            }
            return materializedResultWithPlan;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public Lock getExclusiveLock() {
        return this.lock.writeLock();
    }

    @Override
    public void injectTaskFailure(String traceToken, int stageId, int partitionId, int attemptId, FailureInjector.InjectedFailureType injectionType, Optional<ErrorType> errorType) {
        throw new UnsupportedOperationException("failure injection is not supported");
    }

    public List<Driver> createDrivers(@Language(value="SQL") String sql, OutputFactory outputFactory, TaskContext taskContext) {
        return this.createDrivers(this.defaultSession, sql, outputFactory, taskContext);
    }

    @Override
    public void loadExchangeManager(String name, Map<String, String> properties) {
        this.exchangeManagerRegistry.loadExchangeManager(name, properties);
    }

    public List<Driver> createDrivers(Session session, @Language(value="SQL") String sql, OutputFactory outputFactory, TaskContext taskContext) {
        Plan plan = this.createPlan(session, sql, WarningCollector.NOOP, PlanOptimizersStatsCollector.createPlanOptimizersStatsCollector());
        return this.createDrivers(session, plan, outputFactory, taskContext);
    }

    public SubPlan createSubPlans(Session session, Plan plan, boolean forceSingleNode) {
        return this.planFragmenter.createSubPlans(session, plan, forceSingleNode, WarningCollector.NOOP);
    }

    private List<Driver> createDrivers(Session session, Plan plan, OutputFactory outputFactory, TaskContext taskContext) {
        SubPlan subplan;
        if (this.printPlan) {
            System.out.println(PlanPrinter.textLogicalPlan(plan.getRoot(), plan.getTypes(), this.plannerContext.getMetadata(), this.plannerContext.getFunctionManager(), plan.getStatsAndCosts(), session, 0, false));
        }
        if (!(subplan = this.createSubPlans(session, plan, true)).getChildren().isEmpty()) {
            throw new AssertionError((Object)"Expected subplan to have no children");
        }
        TableExecuteContextManager tableExecuteContextManager = new TableExecuteContextManager();
        tableExecuteContextManager.registerTableExecuteContextForQuery(taskContext.getQueryContext().getQueryId());
        LocalExecutionPlanner executionPlanner = new LocalExecutionPlanner(this.plannerContext, new TypeAnalyzer(this.plannerContext, this.statementAnalyzerFactory), Optional.empty(), this.pageSourceManager, this.indexManager, this.nodePartitioningManager, this.pageSinkManager, null, this.expressionCompiler, this.pageFunctionCompiler, this.joinFilterFunctionCompiler, new IndexJoinLookupStats(), this.taskManagerConfig, this.spillerFactory, this.singleStreamSpillerFactory, this.partitioningSpillerFactory, new PagesIndex.TestingFactory(false), this.joinCompiler, new OrderingCompiler(this.plannerContext.getTypeOperators()), new DynamicFilterConfig(), this.blockTypeOperators, this.typeOperators, tableExecuteContextManager, this.exchangeManagerRegistry, this.nodeManager.getCurrentNode().getNodeVersion());
        LocalExecutionPlanner.LocalExecutionPlan localExecutionPlan = executionPlanner.plan(taskContext, subplan.getFragment().getRoot(), subplan.getFragment().getOutputPartitioningScheme().getOutputLayout(), plan.getTypes(), subplan.getFragment().getPartitionedSources(), outputFactory);
        ArrayList<SplitAssignment> splitAssignments = new ArrayList<SplitAssignment>();
        long sequenceId = 0L;
        for (TableScanNode tableScan : LocalQueryRunner.findTableScanNodes(subplan.getFragment().getRoot())) {
            TableHandle table = tableScan.getTable();
            SplitSource splitSource = this.splitManager.getSplits(session, Span.getInvalid(), table, DynamicFilter.EMPTY, Constraint.alwaysTrue());
            ImmutableSet.Builder scheduledSplits = ImmutableSet.builder();
            while (!splitSource.isFinished()) {
                for (Split split : LocalQueryRunner.getNextBatch(splitSource)) {
                    scheduledSplits.add((Object)new ScheduledSplit(sequenceId++, tableScan.getId(), split));
                }
            }
            splitAssignments.add(new SplitAssignment(tableScan.getId(), (Set<ScheduledSplit>)scheduledSplits.build(), true));
        }
        ArrayList<Driver> drivers = new ArrayList<Driver>();
        HashMap<PlanNodeId, DriverFactory> driverFactoriesBySource = new HashMap<PlanNodeId, DriverFactory>();
        for (DriverFactory driverFactory : localExecutionPlan.getDriverFactories()) {
            for (int i = 0; i < driverFactory.getDriverInstances().orElse(1); ++i) {
                if (driverFactory.getSourceId().isPresent()) {
                    Preconditions.checkState((driverFactoriesBySource.put(driverFactory.getSourceId().get(), driverFactory) == null ? 1 : 0) != 0);
                    continue;
                }
                DriverContext driverContext = taskContext.addPipelineContext(driverFactory.getPipelineId(), driverFactory.isInputDriver(), driverFactory.isOutputDriver(), false).addDriverContext();
                Driver driver = driverFactory.createDriver(driverContext);
                drivers.add(driver);
            }
        }
        ImmutableSet partitionedSources = ImmutableSet.copyOf(subplan.getFragment().getPartitionedSources());
        for (SplitAssignment splitAssignment : splitAssignments) {
            DriverFactory driverFactory = (DriverFactory)driverFactoriesBySource.get(splitAssignment.getPlanNodeId());
            Preconditions.checkState((driverFactory != null ? 1 : 0) != 0);
            boolean partitioned = partitionedSources.contains((Object)driverFactory.getSourceId().get());
            for (ScheduledSplit split : splitAssignment.getSplits()) {
                DriverContext driverContext = taskContext.addPipelineContext(driverFactory.getPipelineId(), driverFactory.isInputDriver(), driverFactory.isOutputDriver(), partitioned).addDriverContext();
                Driver driver = driverFactory.createDriver(driverContext);
                driver.updateSplitAssignment(new SplitAssignment(split.getPlanNodeId(), (Set<ScheduledSplit>)ImmutableSet.of((Object)split), true));
                drivers.add(driver);
            }
        }
        for (DriverFactory driverFactory : localExecutionPlan.getDriverFactories()) {
            driverFactory.noMoreDrivers();
        }
        return ImmutableList.copyOf(drivers);
    }

    @Override
    public Plan createPlan(Session session, @Language(value="SQL") String sql, WarningCollector warningCollector, PlanOptimizersStatsCollector planOptimizersStatsCollector) {
        return this.createPlan(session, sql, LogicalPlanner.Stage.OPTIMIZED_AND_VALIDATED, warningCollector, planOptimizersStatsCollector);
    }

    public Plan createPlan(Session session, @Language(value="SQL") String sql, LogicalPlanner.Stage stage, WarningCollector warningCollector, PlanOptimizersStatsCollector planOptimizersStatsCollector) {
        return this.createPlan(session, sql, stage, true, warningCollector, planOptimizersStatsCollector);
    }

    public Plan createPlan(Session session, @Language(value="SQL") String sql, LogicalPlanner.Stage stage, boolean forceSingleNode, WarningCollector warningCollector, PlanOptimizersStatsCollector planOptimizersStatsCollector) {
        return this.createPlan(session, sql, this.getPlanOptimizers(forceSingleNode), stage, warningCollector, planOptimizersStatsCollector);
    }

    public List<PlanOptimizer> getPlanOptimizers(boolean forceSingleNode) {
        return new PlanOptimizers(this.plannerContext, new TypeAnalyzer(this.plannerContext, this.statementAnalyzerFactory), this.taskManagerConfig, forceSingleNode, this.splitManager, this.pageSourceManager, this.statsCalculator, this.scalarStatsCalculator, this.costCalculator, this.estimatedExchangesCostCalculator, new CostComparator(this.optimizerConfig), this.taskCountEstimator, this.nodePartitioningManager, new RuleStatsRecorder()).get();
    }

    public Plan createPlan(Session session, @Language(value="SQL") String sql, List<PlanOptimizer> optimizers, WarningCollector warningCollector, PlanOptimizersStatsCollector planOptimizersStatsCollector) {
        return this.createPlan(session, sql, optimizers, LogicalPlanner.Stage.OPTIMIZED_AND_VALIDATED, warningCollector, planOptimizersStatsCollector);
    }

    public Plan createPlan(Session session, @Language(value="SQL") String sql, List<PlanOptimizer> optimizers, LogicalPlanner.Stage stage, WarningCollector warningCollector, PlanOptimizersStatsCollector planOptimizersStatsCollector) {
        QueryPreparer.PreparedQuery preparedQuery = new QueryPreparer(this.sqlParser).prepareQuery(session, sql);
        TreeAssertions.assertFormattedSql((SqlParser)this.sqlParser, (ParsingOptions)ParsingUtil.createParsingOptions(session), (Node)preparedQuery.getStatement());
        PlanNodeIdAllocator idAllocator = new PlanNodeIdAllocator();
        AnalyzerFactory analyzerFactory = this.createAnalyzerFactory(this.createQueryExplainerFactory(optimizers));
        Analyzer analyzer = analyzerFactory.createAnalyzer(session, preparedQuery.getParameters(), ParameterExtractor.bindParameters(preparedQuery.getStatement(), preparedQuery.getParameters()), warningCollector, planOptimizersStatsCollector);
        LogicalPlanner logicalPlanner = new LogicalPlanner(session, optimizers, new PlanSanityChecker(true), idAllocator, this.getPlannerContext(), new TypeAnalyzer(this.plannerContext, this.statementAnalyzerFactory), this.statsCalculator, this.costCalculator, warningCollector, planOptimizersStatsCollector);
        Analysis analysis = analyzer.analyze(preparedQuery.getStatement());
        return logicalPlanner.plan(analysis, stage);
    }

    private QueryExplainerFactory createQueryExplainerFactory(List<PlanOptimizer> optimizers) {
        return new QueryExplainerFactory(() -> optimizers, this.planFragmenter, this.plannerContext, this.statementAnalyzerFactory, this.statsCalculator, this.costCalculator, new NodeVersion("test"));
    }

    private AnalyzerFactory createAnalyzerFactory(QueryExplainerFactory queryExplainerFactory) {
        return new AnalyzerFactory(this.statementAnalyzerFactory, new StatementRewrite((Set<StatementRewrite.Rewrite>)ImmutableSet.of((Object)new DescribeInputRewrite(this.sqlParser), (Object)new DescribeOutputRewrite(this.sqlParser), (Object)new ShowQueriesRewrite(this.plannerContext.getMetadata(), this.sqlParser, this.accessControl, this.sessionPropertyManager, this.schemaPropertyManager, this.columnPropertyManager, this.tablePropertyManager, this.materializedViewPropertyManager), (Object)new ShowStatsRewrite(this.plannerContext.getMetadata(), queryExplainerFactory, this.statsCalculator), (Object)new ExplainRewrite(queryExplainerFactory, new QueryPreparer(this.sqlParser)))), this.plannerContext.getTracer());
    }

    private static List<Split> getNextBatch(SplitSource splitSource) {
        return ((SplitSource.SplitBatch)MoreFutures.getFutureValue(splitSource.getNextBatch(1000))).getSplits();
    }

    private static List<TableScanNode> findTableScanNodes(PlanNode node) {
        return PlanNodeSearcher.searchFrom(node).where(TableScanNode.class::isInstance).findAll();
    }

    public static class Builder {
        private final Session defaultSession;
        private FeaturesConfig featuresConfig = new FeaturesConfig();
        private NodeSpillConfig nodeSpillConfig = new NodeSpillConfig();
        private boolean initialTransaction;
        private boolean alwaysRevokeMemory;
        private Map<String, List<PropertyMetadata<?>>> defaultSessionProperties = ImmutableMap.of();
        private Set<SystemSessionPropertiesProvider> extraSessionProperties = ImmutableSet.of();
        private int nodeCountForStats;
        private MetadataProvider metadataProvider = MetadataManager::new;

        private Builder(Session defaultSession) {
            this.defaultSession = Objects.requireNonNull(defaultSession, "defaultSession is null");
        }

        public Builder withFeaturesConfig(FeaturesConfig featuresConfig) {
            this.featuresConfig = Objects.requireNonNull(featuresConfig, "featuresConfig is null");
            return this;
        }

        public Builder withNodeSpillConfig(NodeSpillConfig nodeSpillConfig) {
            this.nodeSpillConfig = Objects.requireNonNull(nodeSpillConfig, "nodeSpillConfig is null");
            return this;
        }

        public Builder withInitialTransaction() {
            this.initialTransaction = true;
            return this;
        }

        public Builder withAlwaysRevokeMemory() {
            this.alwaysRevokeMemory = true;
            return this;
        }

        public Builder withDefaultSessionProperties(Map<String, List<PropertyMetadata<?>>> defaultSessionProperties) {
            this.defaultSessionProperties = Objects.requireNonNull(defaultSessionProperties, "defaultSessionProperties is null");
            return this;
        }

        public Builder withNodeCountForStats(int nodeCountForStats) {
            this.nodeCountForStats = nodeCountForStats;
            return this;
        }

        public Builder withMetadataProvider(MetadataProvider metadataProvider) {
            this.metadataProvider = metadataProvider;
            return this;
        }

        public Builder withExtraSystemSessionProperties(Set<SystemSessionPropertiesProvider> extraSessionProperties) {
            this.extraSessionProperties = ImmutableSet.copyOf((Collection)Objects.requireNonNull(extraSessionProperties, "extraSessionProperties is null"));
            return this;
        }

        public LocalQueryRunner build() {
            return new LocalQueryRunner(this.defaultSession, this.featuresConfig, this.nodeSpillConfig, this.initialTransaction, this.alwaysRevokeMemory, this.nodeCountForStats, this.defaultSessionProperties, this.metadataProvider, this.extraSessionProperties);
        }
    }

    public static interface MetadataProvider {
        public Metadata getMetadata(SystemSecurityMetadata var1, TransactionManager var2, GlobalFunctionCatalog var3, TypeManager var4);
    }
}

