/*
 * Decompiled with CFR 0.152.
 */
package io.trino.testing;

import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import com.google.common.io.BaseEncoding;
import com.google.common.primitives.UnsignedBytes;
import io.trino.spi.type.SqlVarbinary;
import java.nio.charset.StandardCharsets;

public final class SqlVarbinaryTestingUtil {
    private SqlVarbinaryTestingUtil() {
    }

    public static SqlVarbinary sqlVarbinaryFromHex(String value) {
        return new SqlVarbinary(BaseEncoding.base16().decode((CharSequence)value));
    }

    public static SqlVarbinary sqlVarbinary(String value) {
        Preconditions.checkArgument((boolean)CharMatcher.ascii().matchesAllOf((CharSequence)value), (String)"string must be ASCII: '%s'", (Object)value);
        return new SqlVarbinary(value.getBytes(StandardCharsets.US_ASCII));
    }

    public static SqlVarbinary sqlVarbinaryFromIso(String value) {
        return new SqlVarbinary(value.getBytes(StandardCharsets.ISO_8859_1));
    }

    public static SqlVarbinary sqlVarbinary(int ... bytesAsInts) {
        byte[] bytes = new byte[bytesAsInts.length];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = UnsignedBytes.checkedCast((long)bytesAsInts[i]);
        }
        return new SqlVarbinary(bytes);
    }
}

