/*
 * Decompiled with CFR 0.152.
 */
package io.trino.type;

import com.google.common.net.InetAddresses;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.airlift.slice.XxHash64;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.BlockBuilderStatus;
import io.trino.spi.block.Int128ArrayBlockBuilder;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.function.BlockIndex;
import io.trino.spi.function.BlockPosition;
import io.trino.spi.function.FlatFixed;
import io.trino.spi.function.FlatFixedOffset;
import io.trino.spi.function.FlatVariableWidth;
import io.trino.spi.function.OperatorType;
import io.trino.spi.function.ScalarOperator;
import io.trino.spi.type.AbstractType;
import io.trino.spi.type.FixedWidthType;
import io.trino.spi.type.TypeOperatorDeclaration;
import io.trino.spi.type.TypeOperators;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteOrder;

public class IpAddressType
extends AbstractType
implements FixedWidthType {
    private static final TypeOperatorDeclaration TYPE_OPERATOR_DECLARATION = TypeOperatorDeclaration.extractOperatorDeclaration(IpAddressType.class, (MethodHandles.Lookup)MethodHandles.lookup(), Slice.class);
    private static final VarHandle LONG_HANDLE = MethodHandles.byteArrayViewVarHandle(long[].class, ByteOrder.LITTLE_ENDIAN);
    public static final IpAddressType IPADDRESS = new IpAddressType();

    private IpAddressType() {
        super(new TypeSignature("ipaddress", new TypeSignatureParameter[0]), Slice.class);
    }

    public int getFixedSize() {
        return 16;
    }

    public BlockBuilder createBlockBuilder(BlockBuilderStatus blockBuilderStatus, int expectedEntries, int expectedBytesPerEntry) {
        int maxBlockSizeInBytes = blockBuilderStatus == null ? 0x100000 : blockBuilderStatus.getMaxPageSizeInBytes();
        return new Int128ArrayBlockBuilder(blockBuilderStatus, Math.min(expectedEntries, maxBlockSizeInBytes / this.getFixedSize()));
    }

    public BlockBuilder createBlockBuilder(BlockBuilderStatus blockBuilderStatus, int expectedEntries) {
        return this.createBlockBuilder(blockBuilderStatus, expectedEntries, this.getFixedSize());
    }

    public BlockBuilder createFixedSizeBlockBuilder(int positionCount) {
        return new Int128ArrayBlockBuilder(null, positionCount);
    }

    public boolean isComparable() {
        return true;
    }

    public boolean isOrderable() {
        return true;
    }

    public TypeOperatorDeclaration getTypeOperatorDeclaration(TypeOperators typeOperators) {
        return TYPE_OPERATOR_DECLARATION;
    }

    public Object getObjectValue(ConnectorSession session, Block block, int position) {
        if (block.isNull(position)) {
            return null;
        }
        try {
            return InetAddresses.toAddrString((InetAddress)InetAddress.getByAddress(this.getSlice(block, position).getBytes()));
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException();
        }
    }

    public void appendTo(Block block, int position, BlockBuilder blockBuilder) {
        if (block.isNull(position)) {
            blockBuilder.appendNull();
        } else {
            ((Int128ArrayBlockBuilder)blockBuilder).writeInt128(block.getLong(position, 0), block.getLong(position, 8));
        }
    }

    public void writeSlice(BlockBuilder blockBuilder, Slice value) {
        this.writeSlice(blockBuilder, value, 0, value.length());
    }

    public void writeSlice(BlockBuilder blockBuilder, Slice value, int offset, int length) {
        if (length != 16) {
            throw new IllegalStateException("Expected entry size to be exactly 16 but was " + length);
        }
        ((Int128ArrayBlockBuilder)blockBuilder).writeInt128(value.getLong(offset), value.getLong(offset + 8));
    }

    public final Slice getSlice(Block block, int position) {
        Slice value = Slices.allocate((int)16);
        value.setLong(0, block.getLong(position, 0));
        value.setLong(8, block.getLong(position, 8));
        return value;
    }

    public int getFlatFixedSize() {
        return 16;
    }

    @ScalarOperator(value=OperatorType.READ_VALUE)
    private static Slice readFlat(@FlatFixed byte[] fixedSizeSlice, @FlatFixedOffset int fixedSizeOffset, @FlatVariableWidth byte[] unusedVariableSizeSlice) {
        return Slices.wrappedBuffer((byte[])fixedSizeSlice, (int)fixedSizeOffset, (int)16);
    }

    @ScalarOperator(value=OperatorType.READ_VALUE)
    private static void readFlatToBlock(@FlatFixed byte[] fixedSizeSlice, @FlatFixedOffset int fixedSizeOffset, @FlatVariableWidth byte[] unusedVariableSizeSlice, BlockBuilder blockBuilder) {
        ((Int128ArrayBlockBuilder)blockBuilder).writeInt128(LONG_HANDLE.get(fixedSizeSlice, fixedSizeOffset), LONG_HANDLE.get(fixedSizeSlice, fixedSizeOffset + 8));
    }

    @ScalarOperator(value=OperatorType.READ_VALUE)
    private static void writeFlat(Slice value, byte[] fixedSizeSlice, int fixedSizeOffset, byte[] unusedVariableSizeSlice, int unusedVariableSizeOffset) {
        value.getBytes(0, fixedSizeSlice, fixedSizeOffset, 16);
    }

    @ScalarOperator(value=OperatorType.EQUAL)
    private static boolean equalOperator(Slice left, Slice right) {
        return IpAddressType.equal(left.getLong(0), left.getLong(8), right.getLong(0), right.getLong(8));
    }

    @ScalarOperator(value=OperatorType.EQUAL)
    private static boolean equalOperator(@BlockPosition Block leftBlock, @BlockIndex int leftPosition, @BlockPosition Block rightBlock, @BlockIndex int rightPosition) {
        return IpAddressType.equal(leftBlock.getLong(leftPosition, 0), leftBlock.getLong(leftPosition, 8), rightBlock.getLong(rightPosition, 0), rightBlock.getLong(rightPosition, 8));
    }

    private static boolean equal(long leftLow, long leftHigh, long rightLow, long rightHigh) {
        return leftLow == rightLow && leftHigh == rightHigh;
    }

    @ScalarOperator(value=OperatorType.XX_HASH_64)
    private static long xxHash64Operator(Slice value) {
        return IpAddressType.xxHash64(value.getLong(0), value.getLong(8));
    }

    @ScalarOperator(value=OperatorType.XX_HASH_64)
    private static long xxHash64Operator(@BlockPosition Block block, @BlockIndex int position) {
        return IpAddressType.xxHash64(block.getLong(position, 0), block.getLong(position, 8));
    }

    private static long xxHash64(long low, long high) {
        return XxHash64.hash((long)low) ^ XxHash64.hash((long)high);
    }

    @ScalarOperator(value=OperatorType.COMPARISON_UNORDERED_LAST)
    private static long comparisonOperator(Slice left, Slice right) {
        return IpAddressType.compareBigEndian(left.getLong(0), left.getLong(8), right.getLong(0), right.getLong(8));
    }

    @ScalarOperator(value=OperatorType.COMPARISON_UNORDERED_LAST)
    private static long comparisonOperator(@BlockPosition Block leftBlock, @BlockIndex int leftPosition, @BlockPosition Block rightBlock, @BlockIndex int rightPosition) {
        return IpAddressType.compareBigEndian(leftBlock.getLong(leftPosition, 0), leftBlock.getLong(leftPosition, 8), rightBlock.getLong(rightPosition, 0), rightBlock.getLong(rightPosition, 8));
    }

    private static int compareBigEndian(long leftLow64le, long leftHigh64le, long rightLow64le, long rightHigh64le) {
        int value = Long.compareUnsigned(Long.reverseBytes(leftLow64le), Long.reverseBytes(rightLow64le));
        if (value != 0) {
            return value;
        }
        return Long.compareUnsigned(Long.reverseBytes(leftHigh64le), Long.reverseBytes(rightHigh64le));
    }
}

