/*
 * Decompiled with CFR 0.152.
 */
package io.trino.type;

import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.VariableWidthBlockBuilder;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.type.AbstractVariableWidthType;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;
import io.trino.type.Re2JRegexp;

public class Re2JRegexpType
extends AbstractVariableWidthType {
    public static final String NAME = "Re2JRegExp";
    public static final TypeSignature RE2J_REGEXP_SIGNATURE = new TypeSignature("Re2JRegExp", new TypeSignatureParameter[0]);
    private final int dfaStatesLimit;
    private final int dfaRetries;

    public Re2JRegexpType(int dfaStatesLimit, int dfaRetries) {
        super(RE2J_REGEXP_SIGNATURE, Re2JRegexp.class);
        this.dfaStatesLimit = dfaStatesLimit;
        this.dfaRetries = dfaRetries;
    }

    public Object getObjectValue(ConnectorSession session, Block block, int position) {
        throw new UnsupportedOperationException();
    }

    public void appendTo(Block block, int position, BlockBuilder blockBuilder) {
        throw new UnsupportedOperationException();
    }

    public Object getObject(Block block, int position) {
        if (block.isNull(position)) {
            return null;
        }
        Slice pattern = block.getSlice(position, 0, block.getSliceLength(position));
        try {
            return new Re2JRegexp(this.dfaStatesLimit, this.dfaRetries, pattern);
        }
        catch (Exception e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, (Throwable)e);
        }
    }

    public void writeObject(BlockBuilder blockBuilder, Object value) {
        Slice pattern = Slices.utf8Slice((String)((Re2JRegexp)value).pattern());
        ((VariableWidthBlockBuilder)blockBuilder).writeEntry(pattern);
    }
}

