/*
 * Decompiled with CFR 0.152.
 */
package io.trino.type;

import com.google.common.base.Preconditions;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.BlockBuilderStatus;
import io.trino.spi.block.ByteArrayBlockBuilder;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.function.FlatFixed;
import io.trino.spi.function.FlatFixedOffset;
import io.trino.spi.function.FlatVariableWidth;
import io.trino.spi.function.OperatorType;
import io.trino.spi.function.ScalarOperator;
import io.trino.spi.type.AbstractType;
import io.trino.spi.type.FixedWidthType;
import io.trino.spi.type.TypeOperatorDeclaration;
import io.trino.spi.type.TypeOperators;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;
import java.lang.invoke.MethodHandles;

public final class UnknownType
extends AbstractType
implements FixedWidthType {
    private static final TypeOperatorDeclaration TYPE_OPERATOR_DECLARATION = TypeOperatorDeclaration.extractOperatorDeclaration(UnknownType.class, (MethodHandles.Lookup)MethodHandles.lookup(), Boolean.TYPE);
    public static final UnknownType UNKNOWN = new UnknownType();
    public static final String NAME = "unknown";

    private UnknownType() {
        super(new TypeSignature(NAME, new TypeSignatureParameter[0]), Boolean.TYPE);
    }

    public int getFixedSize() {
        return 1;
    }

    public BlockBuilder createBlockBuilder(BlockBuilderStatus blockBuilderStatus, int expectedEntries, int expectedBytesPerEntry) {
        int maxBlockSizeInBytes = blockBuilderStatus == null ? 0x100000 : blockBuilderStatus.getMaxPageSizeInBytes();
        return new ByteArrayBlockBuilder(blockBuilderStatus, Math.min(expectedEntries, maxBlockSizeInBytes / this.getFixedSize()));
    }

    public BlockBuilder createBlockBuilder(BlockBuilderStatus blockBuilderStatus, int expectedEntries) {
        return this.createBlockBuilder(blockBuilderStatus, expectedEntries, this.getFixedSize());
    }

    public BlockBuilder createFixedSizeBlockBuilder(int positionCount) {
        return new ByteArrayBlockBuilder(null, positionCount);
    }

    public boolean isComparable() {
        return true;
    }

    public boolean isOrderable() {
        return true;
    }

    public TypeOperatorDeclaration getTypeOperatorDeclaration(TypeOperators typeOperators) {
        return TYPE_OPERATOR_DECLARATION;
    }

    public Object getObjectValue(ConnectorSession session, Block block, int position) {
        Preconditions.checkArgument((boolean)block.isNull(position), (Object)"Expected NULL value for UnknownType");
        return null;
    }

    public void appendTo(Block block, int position, BlockBuilder blockBuilder) {
        blockBuilder.appendNull();
    }

    public boolean getBoolean(Block block, int position) {
        Preconditions.checkArgument((boolean)block.isNull(position));
        return false;
    }

    @Deprecated
    public void writeBoolean(BlockBuilder blockBuilder, boolean value) {
        Preconditions.checkArgument((!value ? 1 : 0) != 0);
        blockBuilder.appendNull();
    }

    public int getFlatFixedSize() {
        return 0;
    }

    @ScalarOperator(value=OperatorType.READ_VALUE)
    private static boolean readFlat(@FlatFixed byte[] unusedFixedSizeSlice, @FlatFixedOffset int unusedFixedSizeOffset, @FlatVariableWidth byte[] unusedVariableSizeSlice) {
        throw new AssertionError((Object)"value of unknown type should all be NULL");
    }

    @ScalarOperator(value=OperatorType.READ_VALUE)
    private static void writeFlat(boolean unusedValue, byte[] unusedFixedSizeSlice, int unusedFixedSizeOffset, byte[] unusedVariableSizeSlice, int unusedVariableSizeOffset) {
        throw new AssertionError((Object)"value of unknown type should all be NULL");
    }

    @ScalarOperator(value=OperatorType.EQUAL)
    private static boolean equalOperator(boolean unusedLeft, boolean unusedRight) {
        throw new AssertionError((Object)"value of unknown type should all be NULL");
    }

    @ScalarOperator(value=OperatorType.XX_HASH_64)
    private static long xxHash64Operator(boolean unusedValue) {
        throw new AssertionError((Object)"value of unknown type should all be NULL");
    }

    @ScalarOperator(value=OperatorType.COMPARISON_UNORDERED_LAST)
    private static long comparisonOperator(boolean unusedLeft, boolean unusedRight) {
        throw new AssertionError((Object)"value of unknown type should all be NULL");
    }
}

