/*
 * Decompiled with CFR 0.152.
 */
package io.trino.connector.system;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import io.airlift.log.Logger;
import io.trino.FullConnectorSession;
import io.trino.Session;
import io.trino.connector.system.jdbc.FilterUtil;
import io.trino.metadata.MaterializedViewDefinition;
import io.trino.metadata.Metadata;
import io.trino.metadata.MetadataListing;
import io.trino.metadata.MetadataUtil;
import io.trino.metadata.QualifiedObjectName;
import io.trino.metadata.QualifiedTablePrefix;
import io.trino.metadata.RedirectionAwareTableHandle;
import io.trino.metadata.TableHandle;
import io.trino.metadata.ViewDefinition;
import io.trino.security.AccessControl;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.InMemoryRecordSet;
import io.trino.spi.connector.RecordCursor;
import io.trino.spi.connector.RelationCommentMetadata;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.SystemTable;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class TableCommentSystemTable
implements SystemTable {
    private static final Logger LOG = Logger.get(TableCommentSystemTable.class);
    private static final SchemaTableName COMMENT_TABLE_NAME = new SchemaTableName("metadata", "table_comments");
    private static final ConnectorTableMetadata COMMENT_TABLE = MetadataUtil.TableMetadataBuilder.tableMetadataBuilder(COMMENT_TABLE_NAME).column("catalog_name", (Type)VarcharType.createUnboundedVarcharType()).column("schema_name", (Type)VarcharType.createUnboundedVarcharType()).column("table_name", (Type)VarcharType.createUnboundedVarcharType()).column("comment", (Type)VarcharType.createUnboundedVarcharType()).build();
    private final Metadata metadata;
    private final AccessControl accessControl;

    @Inject
    public TableCommentSystemTable(Metadata metadata, AccessControl accessControl) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
    }

    public SystemTable.Distribution getDistribution() {
        return SystemTable.Distribution.SINGLE_COORDINATOR;
    }

    public ConnectorTableMetadata getTableMetadata() {
        return COMMENT_TABLE;
    }

    public RecordCursor cursor(ConnectorTransactionHandle transactionHandle, ConnectorSession connectorSession, TupleDomain<Integer> constraint) {
        Optional<String> catalogFilter = FilterUtil.tryGetSingleVarcharValue(constraint, 0);
        Optional<String> schemaFilter = FilterUtil.tryGetSingleVarcharValue(constraint, 1);
        Optional<String> tableFilter = FilterUtil.tryGetSingleVarcharValue(constraint, 2);
        Session session = ((FullConnectorSession)connectorSession).getSession();
        InMemoryRecordSet.Builder table = InMemoryRecordSet.builder((ConnectorTableMetadata)COMMENT_TABLE);
        for (String catalog : MetadataListing.listCatalogNames(session, this.metadata, this.accessControl, catalogFilter)) {
            QualifiedTablePrefix prefix = FilterUtil.tablePrefix(catalog, schemaFilter, tableFilter);
            this.addTableCommentForCatalog(session, table, catalog, prefix);
        }
        return table.build().cursor();
    }

    private void addTableCommentForCatalog(Session session, InMemoryRecordSet.Builder table, String catalog, QualifiedTablePrefix prefix) {
        block7: {
            block6: {
                RelationComment relationComment;
                if (!prefix.getTableName().isPresent()) break block6;
                QualifiedObjectName relationName = new QualifiedObjectName(catalog, prefix.getSchemaName().orElseThrow(), prefix.getTableName().get());
                try {
                    relationComment = this.getRelationComment(session, relationName);
                }
                catch (RuntimeException e) {
                    LOG.warn((Throwable)e, "Failed to get comment for relation: %s", new Object[]{relationName});
                    relationComment = new RelationComment(false, Optional.empty());
                }
                if (!relationComment.found()) break block7;
                SchemaTableName schemaTableName = relationName.asSchemaTableName();
                if (!this.accessControl.filterTables(session.toSecurityContext(), catalog, (Set<SchemaTableName>)ImmutableSet.of((Object)schemaTableName)).contains(schemaTableName)) break block7;
                table.addRow(new Object[]{catalog, schemaTableName.getSchemaName(), schemaTableName.getTableName(), relationComment.comment().orElse(null)});
                break block7;
            }
            List<RelationCommentMetadata> relationComments = this.metadata.listRelationComments(session, prefix.getCatalogName(), prefix.getSchemaName(), relationNames -> this.accessControl.filterTables(session.toSecurityContext(), catalog, (Set<SchemaTableName>)relationNames));
            for (RelationCommentMetadata commentMetadata : relationComments) {
                SchemaTableName name = commentMetadata.name();
                if (!commentMetadata.tableRedirected()) {
                    table.addRow(new Object[]{catalog, name.getSchemaName(), name.getTableName(), commentMetadata.comment().orElse(null)});
                    continue;
                }
                try {
                    this.metadata.getRedirectionAwareTableHandle(session, new QualifiedObjectName(catalog, name.getSchemaName(), name.getTableName())).tableHandle().ifPresent(tableHandle -> {
                        Optional comment = this.metadata.getTableMetadata(session, (TableHandle)tableHandle).getMetadata().getComment();
                        table.addRow(new Object[]{catalog, name.getSchemaName(), name.getTableName(), comment.orElse(null)});
                    });
                }
                catch (RuntimeException e) {
                    LOG.warn((Throwable)e, "Failed to get metadata for table: %s", new Object[]{name});
                }
            }
        }
    }

    private RelationComment getRelationComment(Session session, QualifiedObjectName relationName) {
        Optional<MaterializedViewDefinition> materializedView = this.metadata.getMaterializedView(session, relationName);
        if (materializedView.isPresent()) {
            return new RelationComment(true, materializedView.get().getComment());
        }
        Optional<ViewDefinition> view = this.metadata.getView(session, relationName);
        if (view.isPresent()) {
            return new RelationComment(true, view.get().getComment());
        }
        RedirectionAwareTableHandle redirectionAware = this.metadata.getRedirectionAwareTableHandle(session, relationName);
        if (redirectionAware.tableHandle().isPresent()) {
            return new RelationComment(true, this.metadata.getTableMetadata(session, redirectionAware.tableHandle().get()).getMetadata().getComment());
        }
        return new RelationComment(false, Optional.empty());
    }

    private record RelationComment(boolean found, Optional<String> comment) {
        RelationComment {
            Objects.requireNonNull(comment, "comment is null");
            Preconditions.checkArgument((found || comment.isEmpty() ? 1 : 0) != 0, (Object)"Unexpected comment for a relation that is not found");
        }
    }
}

