/*
 * Decompiled with CFR 0.152.
 */
package io.trino.event;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.inject.Inject;
import io.airlift.json.JsonCodec;
import io.airlift.log.Logger;
import io.airlift.node.NodeInfo;
import io.airlift.stats.Distribution;
import io.airlift.units.DataSize;
import io.trino.SessionRepresentation;
import io.trino.client.NodeVersion;
import io.trino.cost.StatsAndCosts;
import io.trino.event.QueryMonitorConfig;
import io.trino.eventlistener.EventListenerManager;
import io.trino.execution.Column;
import io.trino.execution.ExecutionFailureInfo;
import io.trino.execution.Input;
import io.trino.execution.QueryInfo;
import io.trino.execution.QueryState;
import io.trino.execution.QueryStats;
import io.trino.execution.StageInfo;
import io.trino.execution.TaskInfo;
import io.trino.execution.TaskState;
import io.trino.metadata.FunctionManager;
import io.trino.metadata.Metadata;
import io.trino.metadata.SessionPropertyManager;
import io.trino.operator.OperatorStats;
import io.trino.operator.RetryPolicy;
import io.trino.operator.TableFinishInfo;
import io.trino.operator.TaskStats;
import io.trino.server.BasicQueryInfo;
import io.trino.spi.ErrorCode;
import io.trino.spi.QueryId;
import io.trino.spi.eventlistener.OutputColumnMetadata;
import io.trino.spi.eventlistener.QueryCompletedEvent;
import io.trino.spi.eventlistener.QueryContext;
import io.trino.spi.eventlistener.QueryCreatedEvent;
import io.trino.spi.eventlistener.QueryFailureInfo;
import io.trino.spi.eventlistener.QueryIOMetadata;
import io.trino.spi.eventlistener.QueryInputMetadata;
import io.trino.spi.eventlistener.QueryMetadata;
import io.trino.spi.eventlistener.QueryOutputMetadata;
import io.trino.spi.eventlistener.QueryStatistics;
import io.trino.spi.eventlistener.StageCpuDistribution;
import io.trino.spi.eventlistener.StageOutputBufferUtilization;
import io.trino.spi.metrics.Metrics;
import io.trino.spi.resourcegroups.QueryType;
import io.trino.spi.resourcegroups.ResourceGroupId;
import io.trino.sql.analyzer.Analysis;
import io.trino.sql.planner.PlanFragment;
import io.trino.sql.planner.plan.PlanFragmentId;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.sql.planner.plan.PlanVisitor;
import io.trino.sql.planner.planprinter.Anonymizer;
import io.trino.sql.planner.planprinter.CounterBasedAnonymizer;
import io.trino.sql.planner.planprinter.NoOpAnonymizer;
import io.trino.sql.planner.planprinter.PlanPrinter;
import io.trino.sql.planner.planprinter.ValuePrinter;
import io.trino.transaction.TransactionId;
import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.stream.Collectors;
import org.joda.time.DateTime;

public class QueryMonitor {
    private static final Logger log = Logger.get(QueryMonitor.class);
    private final JsonCodec<StageInfo> stageInfoCodec;
    private final JsonCodec<OperatorStats> operatorStatsCodec;
    private final JsonCodec<ExecutionFailureInfo> executionFailureInfoCodec;
    private final JsonCodec<StatsAndCosts> statsAndCostsCodec;
    private final EventListenerManager eventListenerManager;
    private final NodeVersion serverVersion;
    private final String serverAddress;
    private final String environment;
    private final SessionPropertyManager sessionPropertyManager;
    private final Metadata metadata;
    private final FunctionManager functionManager;
    private final int maxJsonLimit;

    @Inject
    public QueryMonitor(JsonCodec<StageInfo> stageInfoCodec, JsonCodec<OperatorStats> operatorStatsCodec, JsonCodec<ExecutionFailureInfo> executionFailureInfoCodec, JsonCodec<StatsAndCosts> statsAndCostsCodec, EventListenerManager eventListenerManager, NodeInfo nodeInfo, NodeVersion nodeVersion, SessionPropertyManager sessionPropertyManager, Metadata metadata, FunctionManager functionManager, QueryMonitorConfig config) {
        this.eventListenerManager = Objects.requireNonNull(eventListenerManager, "eventListenerManager is null");
        this.stageInfoCodec = Objects.requireNonNull(stageInfoCodec, "stageInfoCodec is null");
        this.operatorStatsCodec = Objects.requireNonNull(operatorStatsCodec, "operatorStatsCodec is null");
        this.statsAndCostsCodec = Objects.requireNonNull(statsAndCostsCodec, "statsAndCostsCodec is null");
        this.executionFailureInfoCodec = Objects.requireNonNull(executionFailureInfoCodec, "executionFailureInfoCodec is null");
        this.serverVersion = nodeVersion;
        this.serverAddress = nodeInfo.getExternalAddress();
        this.environment = nodeInfo.getEnvironment();
        this.sessionPropertyManager = Objects.requireNonNull(sessionPropertyManager, "sessionPropertyManager is null");
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.functionManager = Objects.requireNonNull(functionManager, "functionManager is null");
        this.maxJsonLimit = Math.toIntExact(config.getMaxOutputStageJsonSize().toBytes());
    }

    public void queryCreatedEvent(BasicQueryInfo queryInfo) {
        this.eventListenerManager.queryCreated(new QueryCreatedEvent(queryInfo.getQueryStats().getCreateTime().toDate().toInstant(), this.createQueryContext(queryInfo.getSession(), queryInfo.getResourceGroupId(), queryInfo.getQueryType(), queryInfo.getRetryPolicy()), new QueryMetadata(queryInfo.getQueryId().toString(), queryInfo.getSession().getTransactionId().map(TransactionId::toString), queryInfo.getQuery(), queryInfo.getUpdateType(), queryInfo.getPreparedQuery(), QueryState.QUEUED.toString(), (List)ImmutableList.of(), (List)ImmutableList.of(), queryInfo.getSelf(), Optional.empty(), Optional.empty(), Optional.empty())));
    }

    public void queryImmediateFailureEvent(BasicQueryInfo queryInfo, ExecutionFailureInfo failure) {
        this.eventListenerManager.queryCompleted((Function<Boolean, QueryCompletedEvent>)((Function)requiresAnonymizedPlan -> new QueryCompletedEvent(new QueryMetadata(queryInfo.getQueryId().toString(), queryInfo.getSession().getTransactionId().map(TransactionId::toString), queryInfo.getQuery(), queryInfo.getUpdateType(), queryInfo.getPreparedQuery(), queryInfo.getState().toString(), (List)ImmutableList.of(), (List)ImmutableList.of(), queryInfo.getSelf(), Optional.empty(), Optional.empty(), Optional.empty()), new QueryStatistics(Duration.ofMillis(0L), Duration.ofMillis(0L), Duration.ofMillis(0L), Duration.ofMillis(queryInfo.getQueryStats().getQueuedTime().toMillis()), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0.0, 0.0, (List)ImmutableList.of(), 0, true, (List)ImmutableList.of(), (List)ImmutableList.of(), (List)ImmutableList.of(), (List)ImmutableList.of(), Optional.empty()), this.createQueryContext(queryInfo.getSession(), queryInfo.getResourceGroupId(), queryInfo.getQueryType(), queryInfo.getRetryPolicy()), new QueryIOMetadata((List)ImmutableList.of(), Optional.empty()), this.createQueryFailureInfo(failure, Optional.empty()), (List)ImmutableList.of(), Instant.ofEpochMilli(queryInfo.getQueryStats().getCreateTime().getMillis()), Instant.ofEpochMilli(queryInfo.getQueryStats().getEndTime().getMillis()), Instant.ofEpochMilli(queryInfo.getQueryStats().getEndTime().getMillis()))));
        QueryMonitor.logQueryTimeline(queryInfo);
    }

    public void queryCompletedEvent(QueryInfo queryInfo) {
        QueryStats queryStats = queryInfo.getQueryStats();
        this.eventListenerManager.queryCompleted((Function<Boolean, QueryCompletedEvent>)((Function)requiresAnonymizedPlan -> new QueryCompletedEvent(this.createQueryMetadata(queryInfo, (boolean)requiresAnonymizedPlan), this.createQueryStatistics(queryInfo), this.createQueryContext(queryInfo.getSession(), queryInfo.getResourceGroupId(), queryInfo.getQueryType(), queryInfo.getRetryPolicy()), QueryMonitor.getQueryIOMetadata(queryInfo), this.createQueryFailureInfo(queryInfo.getFailureInfo(), queryInfo.getOutputStage()), queryInfo.getWarnings(), Instant.ofEpochMilli(queryStats.getCreateTime().getMillis()), Instant.ofEpochMilli(queryStats.getExecutionStartTime().getMillis()), Instant.ofEpochMilli(queryStats.getEndTime() != null ? queryStats.getEndTime().getMillis() : 0L))));
        QueryMonitor.logQueryTimeline(queryInfo);
    }

    private QueryMetadata createQueryMetadata(QueryInfo queryInfo, boolean requiresAnonymizedPlan) {
        Anonymizer anonymizer = requiresAnonymizedPlan ? new CounterBasedAnonymizer() : new NoOpAnonymizer();
        return new QueryMetadata(queryInfo.getQueryId().toString(), queryInfo.getSession().getTransactionId().map(TransactionId::toString), queryInfo.getQuery(), Optional.ofNullable(queryInfo.getUpdateType()), queryInfo.getPreparedQuery(), queryInfo.getState().toString(), queryInfo.getReferencedTables(), queryInfo.getRoutines(), queryInfo.getSelf(), this.createTextQueryPlan(queryInfo, anonymizer), this.createJsonQueryPlan(queryInfo, anonymizer), queryInfo.getOutputStage().flatMap(stage -> this.stageInfoCodec.toJsonWithLengthLimit(stage, this.maxJsonLimit)));
    }

    private QueryStatistics createQueryStatistics(QueryInfo queryInfo) {
        List<OperatorStats> operatorStats = queryInfo.getQueryStats().getOperatorSummaries();
        ImmutableList.Builder operatorSummaries = ImmutableList.builderWithExpectedSize((int)operatorStats.size());
        for (OperatorStats summary : operatorStats) {
            operatorSummaries.add((Object)this.operatorStatsCodec.toJson((Object)summary));
        }
        Optional<StatsAndCosts> planNodeStatsAndCosts = queryInfo.getOutputStage().map(StatsAndCosts::create);
        Optional<String> serializedPlanNodeStatsAndCosts = planNodeStatsAndCosts.map(arg_0 -> this.statsAndCostsCodec.toJson(arg_0));
        QueryStats queryStats = queryInfo.getQueryStats();
        return new QueryStatistics(Duration.ofMillis(queryStats.getTotalCpuTime().toMillis()), Duration.ofMillis(queryStats.getFailedCpuTime().toMillis()), Duration.ofMillis(queryStats.getElapsedTime().toMillis()), Duration.ofMillis(queryStats.getQueuedTime().toMillis()), Optional.of(Duration.ofMillis(queryStats.getTotalScheduledTime().toMillis())), Optional.of(Duration.ofMillis(queryStats.getFailedScheduledTime().toMillis())), Optional.of(Duration.ofMillis(queryStats.getResourceWaitingTime().toMillis())), Optional.of(Duration.ofMillis(queryStats.getAnalysisTime().toMillis())), Optional.of(Duration.ofMillis(queryStats.getPlanningTime().toMillis())), Optional.of(Duration.ofMillis(queryStats.getPlanningCpuTime().toMillis())), Optional.of(Duration.ofMillis(queryStats.getExecutionTime().toMillis())), Optional.of(Duration.ofMillis(queryStats.getInputBlockedTime().toMillis())), Optional.of(Duration.ofMillis(queryStats.getFailedInputBlockedTime().toMillis())), Optional.of(Duration.ofMillis(queryStats.getOutputBlockedTime().toMillis())), Optional.of(Duration.ofMillis(queryStats.getFailedOutputBlockedTime().toMillis())), Optional.of(Duration.ofMillis(queryStats.getPhysicalInputReadTime().toMillis())), queryStats.getPeakUserMemoryReservation().toBytes(), queryStats.getPeakTaskUserMemory().toBytes(), queryStats.getPeakTaskTotalMemory().toBytes(), queryStats.getPhysicalInputDataSize().toBytes(), queryStats.getPhysicalInputPositions(), queryStats.getProcessedInputDataSize().toBytes(), queryStats.getProcessedInputPositions(), queryStats.getInternalNetworkInputDataSize().toBytes(), queryStats.getInternalNetworkInputPositions(), queryStats.getRawInputDataSize().toBytes(), queryStats.getRawInputPositions(), queryStats.getOutputDataSize().toBytes(), queryStats.getOutputPositions(), queryStats.getLogicalWrittenDataSize().toBytes(), queryStats.getWrittenPositions(), queryStats.getSpilledDataSize().toBytes(), queryStats.getCumulativeUserMemory(), queryStats.getFailedCumulativeUserMemory(), queryStats.getStageGcStatistics(), queryStats.getCompletedDrivers(), queryInfo.isFinalQueryInfo(), QueryMonitor.getCpuDistributions(queryInfo), QueryMonitor.getStageOutputBufferUtilizations(queryInfo), (List)operatorSummaries.build(), (List)ImmutableList.copyOf(queryInfo.getQueryStats().getOptimizerRulesSummaries()), serializedPlanNodeStatsAndCosts);
    }

    private QueryContext createQueryContext(SessionRepresentation session, Optional<ResourceGroupId> resourceGroup, Optional<QueryType> queryType, RetryPolicy retryPolicy) {
        return new QueryContext(session.getUser(), session.getOriginalUser(), session.getPrincipal(), session.getGroups(), session.getTraceToken(), session.getRemoteUserAddress(), session.getUserAgent(), session.getClientInfo(), session.getClientTags(), session.getClientCapabilities(), session.getSource(), session.getCatalog(), session.getSchema(), resourceGroup, QueryMonitor.mergeSessionAndCatalogProperties(session), session.getResourceEstimates(), this.serverAddress, this.serverVersion.toString(), this.environment, queryType, retryPolicy.toString());
    }

    private Optional<String> createTextQueryPlan(QueryInfo queryInfo, Anonymizer anonymizer) {
        try {
            if (queryInfo.getOutputStage().isPresent()) {
                return Optional.of(PlanPrinter.textDistributedPlan(queryInfo.getOutputStage().get(), queryInfo.getQueryStats(), new ValuePrinter(this.metadata, this.functionManager, queryInfo.getSession().toSession(this.sessionPropertyManager)), false, anonymizer, this.serverVersion));
            }
        }
        catch (Exception e) {
            log.warn((Throwable)e, "Error creating explain plan for query %s", new Object[]{queryInfo.getQueryId()});
        }
        return Optional.empty();
    }

    private Optional<String> createJsonQueryPlan(QueryInfo queryInfo, Anonymizer anonymizer) {
        try {
            if (queryInfo.getOutputStage().isPresent()) {
                return Optional.of(PlanPrinter.jsonDistributedPlan(queryInfo.getOutputStage().get(), queryInfo.getSession().toSession(this.sessionPropertyManager), this.metadata, this.functionManager, anonymizer));
            }
        }
        catch (Exception e) {
            log.warn((Throwable)e, "Error creating anonymized json plan for query %s", new Object[]{queryInfo.getQueryId()});
        }
        return Optional.empty();
    }

    private static QueryIOMetadata getQueryIOMetadata(QueryInfo queryInfo) {
        Multimap<FragmentNode, OperatorStats> planNodeStats = QueryMonitor.extractPlanNodeStats(queryInfo);
        ImmutableList.Builder inputs = ImmutableList.builderWithExpectedSize((int)queryInfo.getInputs().size());
        for (Input input : queryInfo.getInputs()) {
            Collection inputTableOperatorStats = planNodeStats.get((Object)new FragmentNode(input.getFragmentId(), input.getPlanNodeId()));
            OptionalLong physicalInputBytes = OptionalLong.empty();
            OptionalLong physicalInputPositions = OptionalLong.empty();
            if (!inputTableOperatorStats.isEmpty()) {
                physicalInputBytes = OptionalLong.of(inputTableOperatorStats.stream().map(OperatorStats::getPhysicalInputDataSize).mapToLong(DataSize::toBytes).sum());
                physicalInputPositions = OptionalLong.of(inputTableOperatorStats.stream().mapToLong(OperatorStats::getPhysicalInputPositions).sum());
            }
            Metrics connectorMetrics = inputTableOperatorStats.stream().map(OperatorStats::getConnectorMetrics).reduce(Metrics.EMPTY, Metrics::mergeWith);
            inputs.add((Object)new QueryInputMetadata(input.getCatalogName(), input.getCatalogVersion(), input.getSchema(), input.getTable(), input.getColumns().stream().map(Column::getName).collect(Collectors.toList()), input.getConnectorInfo(), connectorMetrics, physicalInputBytes, physicalInputPositions));
        }
        Optional<Object> output = Optional.empty();
        if (queryInfo.getOutput().isPresent()) {
            Optional<TableFinishInfo> tableFinishInfo = queryInfo.getQueryStats().getOperatorSummaries().stream().map(OperatorStats::getInfo).filter(TableFinishInfo.class::isInstance).map(TableFinishInfo.class::cast).findFirst();
            Optional<List> outputColumnsMetadata = queryInfo.getOutput().get().getColumns().map(columns -> (List)columns.stream().map(column -> new OutputColumnMetadata(column.getColumn().getName(), column.getColumn().getType(), (Set)column.getSourceColumns().stream().map(Analysis.SourceColumn::getColumnDetail).collect(ImmutableSet.toImmutableSet()))).collect(ImmutableList.toImmutableList()));
            output = Optional.of(new QueryOutputMetadata(queryInfo.getOutput().get().getCatalogName(), queryInfo.getOutput().get().getCatalogVersion(), queryInfo.getOutput().get().getSchema(), queryInfo.getOutput().get().getTable(), outputColumnsMetadata, tableFinishInfo.map(TableFinishInfo::getConnectorOutputMetadata), tableFinishInfo.map(TableFinishInfo::isJsonLengthLimitExceeded)));
        }
        return new QueryIOMetadata((List)inputs.build(), output);
    }

    private static Multimap<FragmentNode, OperatorStats> extractPlanNodeStats(QueryInfo queryInfo) {
        ImmutableMultimap.Builder planNodeStats = ImmutableMultimap.builder();
        StageInfo.getAllStages(queryInfo.getOutputStage()).forEach(stageInfo -> QueryMonitor.extractPlanNodeStats(stageInfo, (ImmutableMultimap.Builder<FragmentNode, OperatorStats>)planNodeStats));
        return planNodeStats.build();
    }

    private static void extractPlanNodeStats(StageInfo stageInfo, ImmutableMultimap.Builder<FragmentNode, OperatorStats> planNodeStats) {
        PlanFragment fragment = stageInfo.getPlan();
        if (fragment == null) {
            return;
        }
        ImmutableMap allOperatorStats = Multimaps.index(stageInfo.getStageStats().getOperatorSummaries(), OperatorStats::getPlanNodeId).asMap();
        fragment.getRoot().accept(new PlanVisitor<Void, Collection<OperatorStats>>((Map)allOperatorStats, planNodeStats, fragment){
            final /* synthetic */ Map val$allOperatorStats;
            final /* synthetic */ ImmutableMultimap.Builder val$planNodeStats;
            final /* synthetic */ PlanFragment val$fragment;
            {
                this.val$allOperatorStats = map;
                this.val$planNodeStats = builder;
                this.val$fragment = planFragment;
            }

            @Override
            protected Void visitPlan(PlanNode node, Collection<OperatorStats> parentStats) {
                Collection<OperatorStats> operatorStats = this.val$allOperatorStats.getOrDefault(node.getId(), parentStats);
                this.val$planNodeStats.putAll((Object)new FragmentNode(this.val$fragment.getId(), node.getId()), operatorStats);
                for (PlanNode child : node.getSources()) {
                    child.accept(this, operatorStats);
                }
                return null;
            }
        }, ImmutableList.of());
    }

    private Optional<QueryFailureInfo> createQueryFailureInfo(ExecutionFailureInfo failureInfo, Optional<StageInfo> outputStage) {
        if (failureInfo == null) {
            return Optional.empty();
        }
        Optional<String> failedTask = outputStage.flatMap(QueryMonitor::findFailedTask);
        return Optional.of(new QueryFailureInfo(failureInfo.getErrorCode(), Optional.ofNullable(failureInfo.getType()), Optional.ofNullable(failureInfo.getMessage()), failedTask.map(task -> task.getTaskStatus().getTaskId().toString()), failedTask.map(task -> task.getTaskStatus().getSelf().getHost()), this.executionFailureInfoCodec.toJson((Object)failureInfo)));
    }

    private static Optional<TaskInfo> findFailedTask(StageInfo stageInfo) {
        for (StageInfo subStage : stageInfo.getSubStages()) {
            Optional<TaskInfo> task = QueryMonitor.findFailedTask(subStage);
            if (!task.isPresent()) continue;
            return task;
        }
        return stageInfo.getTasks().stream().filter(taskInfo -> taskInfo.getTaskStatus().getState() == TaskState.FAILED).findFirst();
    }

    private static Map<String, String> mergeSessionAndCatalogProperties(SessionRepresentation session) {
        LinkedHashMap<String, String> mergedProperties = new LinkedHashMap<String, String>(session.getSystemProperties());
        for (Map.Entry<String, Map<String, String>> catalogEntry : session.getCatalogProperties().entrySet()) {
            for (Map.Entry<String, String> entry : catalogEntry.getValue().entrySet()) {
                mergedProperties.put(catalogEntry.getKey() + "." + entry.getKey(), entry.getValue());
            }
        }
        return ImmutableMap.copyOf(mergedProperties);
    }

    private static void logQueryTimeline(QueryInfo queryInfo) {
        try {
            QueryStats queryStats = queryInfo.getQueryStats();
            DateTime queryStartTime = queryStats.getCreateTime();
            DateTime queryEndTime = queryStats.getEndTime();
            if (queryStartTime == null || queryEndTime == null) {
                return;
            }
            long planning = queryStats.getPlanningTime().toMillis();
            long waiting = queryStats.getResourceWaitingTime().toMillis();
            List<StageInfo> stages = StageInfo.getAllStages(queryInfo.getOutputStage());
            long firstTaskStartTime = queryEndTime.getMillis();
            long lastTaskEndTime = queryStartTime.getMillis() + planning;
            for (StageInfo stage : stages) {
                if (!stage.getSubStages().isEmpty()) continue;
                for (TaskInfo taskInfo : stage.getTasks()) {
                    DateTime endTime;
                    TaskStats taskStats = taskInfo.getStats();
                    DateTime firstStartTime = taskStats.getFirstStartTime();
                    if (firstStartTime != null) {
                        firstTaskStartTime = Math.min(firstStartTime.getMillis(), firstTaskStartTime);
                    }
                    if ((endTime = taskStats.getEndTime()) == null) continue;
                    lastTaskEndTime = Math.max(endTime.getMillis(), lastTaskEndTime);
                }
            }
            long elapsed = Math.max(queryEndTime.getMillis() - queryStartTime.getMillis(), 0L);
            long scheduling = Math.max(firstTaskStartTime - queryStartTime.getMillis() - planning, 0L);
            long running = Math.max(lastTaskEndTime - firstTaskStartTime, 0L);
            long finishing = Math.max(queryEndTime.getMillis() - lastTaskEndTime, 0L);
            QueryMonitor.logQueryTimeline(queryInfo.getQueryId(), queryInfo.getState(), Optional.ofNullable(queryInfo.getErrorCode()), elapsed, planning, waiting, scheduling, running, finishing, queryStartTime, queryEndTime);
        }
        catch (Exception e) {
            log.error((Throwable)e, "Error logging query timeline");
        }
    }

    private static void logQueryTimeline(BasicQueryInfo queryInfo) {
        DateTime queryStartTime = queryInfo.getQueryStats().getCreateTime();
        DateTime queryEndTime = queryInfo.getQueryStats().getEndTime();
        if (queryStartTime == null || queryEndTime == null) {
            return;
        }
        long elapsed = Math.max(queryEndTime.getMillis() - queryStartTime.getMillis(), 0L);
        QueryMonitor.logQueryTimeline(queryInfo.getQueryId(), queryInfo.getState(), Optional.ofNullable(queryInfo.getErrorCode()), elapsed, elapsed, 0L, 0L, 0L, 0L, queryStartTime, queryEndTime);
    }

    private static void logQueryTimeline(QueryId queryId, QueryState queryState, Optional<ErrorCode> errorCode, long elapsedMillis, long planningMillis, long waitingMillis, long schedulingMillis, long runningMillis, long finishingMillis, DateTime queryStartTime, DateTime queryEndTime) {
        log.info("TIMELINE: Query %s :: %s%s :: elapsed %sms :: planning %sms :: waiting %sms :: scheduling %sms :: running %sms :: finishing %sms :: begin %s :: end %s", new Object[]{queryId, queryState, errorCode.map(code -> " (%s)".formatted(code.getName())).orElse(""), elapsedMillis, planningMillis, waitingMillis, schedulingMillis, runningMillis, finishingMillis, queryStartTime, queryEndTime});
    }

    private static List<StageCpuDistribution> getCpuDistributions(QueryInfo queryInfo) {
        if (queryInfo.getOutputStage().isEmpty()) {
            return ImmutableList.of();
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        QueryMonitor.populateDistribution(queryInfo.getOutputStage().get(), (ImmutableList.Builder<StageCpuDistribution>)builder);
        return builder.build();
    }

    private static void populateDistribution(StageInfo stageInfo, ImmutableList.Builder<StageCpuDistribution> distributions) {
        distributions.add((Object)QueryMonitor.computeCpuDistribution(stageInfo));
        for (StageInfo subStage : stageInfo.getSubStages()) {
            QueryMonitor.populateDistribution(subStage, distributions);
        }
    }

    private static StageCpuDistribution computeCpuDistribution(StageInfo stageInfo) {
        Distribution cpuDistribution = new Distribution();
        for (TaskInfo taskInfo : stageInfo.getTasks()) {
            cpuDistribution.add(taskInfo.getStats().getTotalCpuTime().toMillis());
        }
        Distribution.DistributionSnapshot snapshot = cpuDistribution.snapshot();
        return new StageCpuDistribution(stageInfo.getStageId().getId(), stageInfo.getTasks().size(), (long)snapshot.getP25(), (long)snapshot.getP50(), (long)snapshot.getP75(), (long)snapshot.getP90(), (long)snapshot.getP95(), (long)snapshot.getP99(), (long)snapshot.getMin(), (long)snapshot.getMax(), (long)snapshot.getTotal(), snapshot.getTotal() / snapshot.getCount());
    }

    private static List<StageOutputBufferUtilization> getStageOutputBufferUtilizations(QueryInfo queryInfo) {
        if (queryInfo.getOutputStage().isEmpty()) {
            return ImmutableList.of();
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        QueryMonitor.populateStageOutputBufferUtilization(queryInfo.getOutputStage().get(), (ImmutableList.Builder<StageOutputBufferUtilization>)builder);
        return builder.build();
    }

    private static void populateStageOutputBufferUtilization(StageInfo stageInfo, ImmutableList.Builder<StageOutputBufferUtilization> utilizations) {
        stageInfo.getStageStats().getOutputBufferUtilization().ifPresent(utilization -> utilizations.add((Object)new StageOutputBufferUtilization(stageInfo.getStageId().getId(), stageInfo.getTasks().size(), utilization.getP01() * 100.0, utilization.getP05() * 100.0, utilization.getP10() * 100.0, utilization.getP25() * 100.0, utilization.getP50() * 100.0, utilization.getP75() * 100.0, utilization.getP90() * 100.0, utilization.getP95() * 100.0, utilization.getP99() * 100.0, utilization.getMin() * 100.0, utilization.getMax() * 100.0, Duration.ofNanos(utilization.getTotal()))));
        for (StageInfo subStage : stageInfo.getSubStages()) {
            QueryMonitor.populateStageOutputBufferUtilization(subStage, utilizations);
        }
    }

    private static class FragmentNode {
        private final PlanFragmentId fragmentId;
        private final PlanNodeId nodeId;

        public FragmentNode(PlanFragmentId fragmentId, PlanNodeId nodeId) {
            this.fragmentId = Objects.requireNonNull(fragmentId, "fragmentId is null");
            this.nodeId = Objects.requireNonNull(nodeId, "nodeId is null");
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FragmentNode that = (FragmentNode)o;
            return this.fragmentId.equals(that.fragmentId) && this.nodeId.equals(that.nodeId);
        }

        public int hashCode() {
            return Objects.hash(this.fragmentId, this.nodeId);
        }

        public String toString() {
            return this.fragmentId + ":" + this.nodeId;
        }
    }
}

