/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.trino.exchange.ExchangeInput;
import io.trino.execution.QueryInfo;
import io.trino.execution.QueryPreparer;
import io.trino.execution.QueryState;
import io.trino.execution.QueryStateMachine;
import io.trino.execution.QueryTracker;
import io.trino.execution.StageId;
import io.trino.execution.StateMachine;
import io.trino.execution.TaskId;
import io.trino.execution.querystats.PlanOptimizersStatsCollector;
import io.trino.execution.warnings.WarningCollector;
import io.trino.server.BasicQueryInfo;
import io.trino.server.protocol.Slug;
import io.trino.spi.type.Type;
import io.trino.sql.planner.Plan;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import java.util.function.Consumer;

public interface QueryExecution
extends QueryTracker.TrackedQuery {
    public QueryState getState();

    public ListenableFuture<QueryState> getStateChange(QueryState var1);

    public void addStateChangeListener(StateMachine.StateChangeListener<QueryState> var1);

    public void setOutputInfoListener(Consumer<QueryOutputInfo> var1);

    public void outputTaskFailed(TaskId var1, Throwable var2);

    public void resultsConsumed();

    public Plan getQueryPlan();

    public BasicQueryInfo getBasicQueryInfo();

    public QueryInfo getQueryInfo();

    public Slug getSlug();

    public Duration getTotalCpuTime();

    public DataSize getUserMemoryReservation();

    public DataSize getTotalMemoryReservation();

    public void start();

    public void cancelQuery();

    public void cancelStage(StageId var1);

    public void failTask(TaskId var1, Exception var2);

    public void recordHeartbeat();

    public boolean shouldWaitForMinWorkers();

    public void addFinalQueryInfoListener(StateMachine.StateChangeListener<QueryInfo> var1);

    public static class QueryOutputInfo {
        private final List<String> columnNames;
        private final List<Type> columnTypes;
        private final Queue<ExchangeInput> inputsQueue;
        private final boolean noMoreInputs;

        public QueryOutputInfo(List<String> columnNames, List<Type> columnTypes, Queue<ExchangeInput> inputsQueue, boolean noMoreInputs) {
            this.columnNames = ImmutableList.copyOf((Collection)Objects.requireNonNull(columnNames, "columnNames is null"));
            this.columnTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(columnTypes, "columnTypes is null"));
            this.inputsQueue = Objects.requireNonNull(inputsQueue, "inputsQueue is null");
            this.noMoreInputs = noMoreInputs;
        }

        public List<String> getColumnNames() {
            return this.columnNames;
        }

        public List<Type> getColumnTypes() {
            return this.columnTypes;
        }

        public void drainInputs(Consumer<ExchangeInput> consumer) {
            ExchangeInput input;
            while ((input = this.inputsQueue.poll()) != null) {
                consumer.accept(input);
            }
        }

        public boolean isNoMoreInputs() {
            return this.noMoreInputs;
        }
    }

    public static interface QueryExecutionFactory<T extends QueryExecution> {
        public T createQueryExecution(QueryPreparer.PreparedQuery var1, QueryStateMachine var2, Slug var3, WarningCollector var4, PlanOptimizersStatsCollector var5);
    }
}

