/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.SizeOf;
import io.airlift.units.DataSize;
import io.trino.operator.VariableWidthData;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.Range;
import io.trino.spi.predicate.ValueSet;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeOperators;
import io.trino.spi.type.TypeUtils;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.nio.ByteOrder;
import java.util.Collection;
import java.util.Objects;

public class JoinDomainBuilder {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(JoinDomainBuilder.class);
    private static final int DEFAULT_DISTINCT_HASH_CAPACITY = 64;
    private static final int VECTOR_LENGTH = 8;
    private static final VarHandle LONG_HANDLE = MethodHandles.byteArrayViewVarHandle(long[].class, ByteOrder.LITTLE_ENDIAN);
    private final Type type;
    private final int maxDistinctValues;
    private final long maxFilterSizeInBytes;
    private final Runnable notifyStateChange;
    private final MethodHandle readFlat;
    private final MethodHandle writeFlat;
    private final MethodHandle hashFlat;
    private final MethodHandle hashBlock;
    private final MethodHandle distinctFlatFlat;
    private final MethodHandle distinctFlatBlock;
    private final MethodHandle compareFlatFlat;
    private final MethodHandle compareBlockBlock;
    private final int distinctRecordSize;
    private final int distinctRecordValueOffset;
    private int distinctCapacity;
    private int distinctMask;
    private byte[] distinctControl;
    private byte[] distinctRecords;
    private VariableWidthData distinctVariableWidthData;
    private int distinctSize;
    private int distinctMaxFill;
    private Block minValue;
    private Block maxValue;
    private boolean collectDistinctValues = true;
    private boolean collectMinMax;
    private long retainedSizeInBytes = INSTANCE_SIZE;

    public JoinDomainBuilder(Type type, int maxDistinctValues, DataSize maxFilterSize, boolean minMaxEnabled, Runnable notifyStateChange, TypeOperators typeOperators) {
        this.type = Objects.requireNonNull(type, "type is null");
        this.maxDistinctValues = maxDistinctValues;
        this.maxFilterSizeInBytes = maxFilterSize.toBytes();
        this.notifyStateChange = Objects.requireNonNull(notifyStateChange, "notifyStateChange is null");
        this.collectMinMax = minMaxEnabled && type.isOrderable() && type != DoubleType.DOUBLE && type != RealType.REAL;
        MethodHandle readOperator = typeOperators.getReadValueOperator(type, InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.NULLABLE_RETURN, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.FLAT}));
        this.readFlat = readOperator = readOperator.asType(readOperator.type().changeReturnType(Object.class));
        this.writeFlat = typeOperators.getReadValueOperator(type, InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.FLAT_RETURN, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION_NOT_NULL}));
        this.hashFlat = typeOperators.getHashCodeOperator(type, InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.FLAT}));
        this.hashBlock = typeOperators.getHashCodeOperator(type, InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION_NOT_NULL}));
        this.distinctFlatFlat = typeOperators.getDistinctFromOperator(type, InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.FLAT, InvocationConvention.InvocationArgumentConvention.FLAT}));
        this.distinctFlatBlock = typeOperators.getDistinctFromOperator(type, InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.FLAT, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION_NOT_NULL}));
        if (this.collectMinMax) {
            this.compareFlatFlat = typeOperators.getComparisonUnorderedLastOperator(type, InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.FLAT, InvocationConvention.InvocationArgumentConvention.FLAT}));
            this.compareBlockBlock = typeOperators.getComparisonUnorderedLastOperator(type, InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION_NOT_NULL, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION_NOT_NULL}));
        } else {
            this.compareFlatFlat = null;
            this.compareBlockBlock = null;
        }
        this.distinctCapacity = 64;
        this.distinctMaxFill = this.distinctCapacity / 16 * 15;
        this.distinctMask = this.distinctCapacity - 1;
        this.distinctControl = new byte[this.distinctCapacity + 8];
        boolean variableWidth = type.isFlatVariableWidth();
        this.distinctVariableWidthData = variableWidth ? new VariableWidthData() : null;
        this.distinctRecordValueOffset = variableWidth ? 12 : 0;
        this.distinctRecordSize = this.distinctRecordValueOffset + type.getFlatFixedSize();
        this.distinctRecords = new byte[Math.multiplyExact(this.distinctCapacity, this.distinctRecordSize)];
        this.retainedSizeInBytes += SizeOf.sizeOf((byte[])this.distinctControl) + SizeOf.sizeOf((byte[])this.distinctRecords);
    }

    public long getRetainedSizeInBytes() {
        return this.retainedSizeInBytes + (this.distinctVariableWidthData == null ? 0L : this.distinctVariableWidthData.getRetainedSizeBytes());
    }

    public boolean isCollecting() {
        return this.collectMinMax || this.collectDistinctValues;
    }

    public void add(Block block) {
        if (this.collectDistinctValues) {
            for (int position = 0; position < block.getPositionCount(); ++position) {
                this.add(block, position);
            }
            if (this.distinctSize > this.maxDistinctValues || this.getRetainedSizeInBytes() > this.maxFilterSizeInBytes) {
                this.retainedSizeInBytes = INSTANCE_SIZE;
                if (this.collectMinMax) {
                    int minIndex = -1;
                    int maxIndex = -1;
                    for (int index = 0; index < this.distinctCapacity; ++index) {
                        if (this.distinctControl[index] == 0) continue;
                        if (minIndex == -1) {
                            minIndex = index;
                            maxIndex = index;
                            continue;
                        }
                        if (this.valueCompare(index, minIndex) < 0) {
                            minIndex = index;
                            continue;
                        }
                        if (this.valueCompare(index, maxIndex) <= 0) continue;
                        maxIndex = index;
                    }
                    if (minIndex != -1) {
                        this.minValue = this.readValueToBlock(minIndex);
                        this.maxValue = this.readValueToBlock(maxIndex);
                        this.retainedSizeInBytes += this.minValue.getRetainedSizeInBytes() + this.maxValue.getRetainedSizeInBytes();
                    }
                } else {
                    this.notifyStateChange.run();
                }
                this.collectDistinctValues = false;
                this.distinctCapacity = 0;
                this.distinctControl = null;
                this.distinctRecords = null;
                this.distinctVariableWidthData = null;
                this.distinctSize = 0;
                this.distinctMaxFill = 0;
            }
        } else if (this.collectMinMax) {
            int minValuePosition = -1;
            int maxValuePosition = -1;
            for (int position = 0; position < block.getPositionCount(); ++position) {
                if (block.isNull(position)) continue;
                if (minValuePosition == -1) {
                    minValuePosition = position;
                    maxValuePosition = position;
                    continue;
                }
                if (this.valueCompare(block, position, block, minValuePosition) < 0) {
                    minValuePosition = position;
                    continue;
                }
                if (this.valueCompare(block, position, block, maxValuePosition) <= 0) continue;
                maxValuePosition = position;
            }
            if (minValuePosition == -1) {
                return;
            }
            if (this.minValue == null) {
                this.minValue = block.getSingleValueBlock(minValuePosition);
                this.maxValue = block.getSingleValueBlock(maxValuePosition);
                return;
            }
            if (this.valueCompare(block, minValuePosition, this.minValue, 0) < 0) {
                this.retainedSizeInBytes -= this.minValue.getRetainedSizeInBytes();
                this.minValue = block.getSingleValueBlock(minValuePosition);
                this.retainedSizeInBytes += this.minValue.getRetainedSizeInBytes();
            }
            if (this.valueCompare(block, maxValuePosition, this.maxValue, 0) > 0) {
                this.retainedSizeInBytes -= this.maxValue.getRetainedSizeInBytes();
                this.maxValue = block.getSingleValueBlock(maxValuePosition);
                this.retainedSizeInBytes += this.maxValue.getRetainedSizeInBytes();
            }
        }
    }

    public void disableMinMax() {
        this.collectMinMax = false;
        if (this.minValue != null) {
            this.retainedSizeInBytes -= this.minValue.getRetainedSizeInBytes();
            this.minValue = null;
        }
        if (this.maxValue != null) {
            this.retainedSizeInBytes -= this.maxValue.getRetainedSizeInBytes();
            this.maxValue = null;
        }
    }

    public Domain build() {
        if (this.collectDistinctValues) {
            ImmutableList.Builder values = ImmutableList.builder();
            for (int i = 0; i < this.distinctCapacity; ++i) {
                Object value;
                if (this.distinctControl[i] == 0 || TypeUtils.isFloatingPointNaN((Type)this.type, (Object)(value = this.readValueToObject(i)))) continue;
                values.add(value);
            }
            return Domain.create((ValueSet)ValueSet.copyOf((Type)this.type, (Collection)values.build()), (boolean)false);
        }
        if (this.collectMinMax) {
            if (this.minValue == null) {
                return Domain.none((Type)this.type);
            }
            Object min = TypeUtils.readNativeValue((Type)this.type, (Block)this.minValue, (int)0);
            Object max = TypeUtils.readNativeValue((Type)this.type, (Block)this.maxValue, (int)0);
            return Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)this.type, (Object)min, (boolean)true, (Object)max, (boolean)true), (Range[])new Range[0]), (boolean)false);
        }
        return Domain.all((Type)this.type);
    }

    private void add(Block block, int position) {
        if (block.isNull(position)) {
            return;
        }
        long hash = this.valueHashCode(block, position);
        byte hashPrefix = JoinDomainBuilder.getHashPrefix(hash);
        int hashBucket = this.getHashBucket(hash);
        int step = 1;
        long repeated = JoinDomainBuilder.repeat(hashPrefix);
        long controlVector;
        int matchBucket;
        while ((matchBucket = this.matchInVector(block, position, hashBucket, repeated, controlVector = this.getControlVector(hashBucket))) < 0) {
            int emptyIndex = this.findEmptyInVector(controlVector, hashBucket);
            if (emptyIndex >= 0) {
                this.insert(emptyIndex, block, position, hashPrefix);
                ++this.distinctSize;
                if (this.distinctSize >= this.distinctMaxFill) {
                    this.rehash();
                }
                return;
            }
            hashBucket = this.bucket(hashBucket + step);
            step += 8;
        }
        return;
    }

    private int matchInVector(byte[] otherValues, VariableWidthData otherVariableWidthData, int position, int vectorStartBucket, long repeated, long controlVector) {
        for (long controlMatches = JoinDomainBuilder.match(controlVector, repeated); controlMatches != 0L; controlMatches &= controlMatches - 1L) {
            int slot = Long.numberOfTrailingZeros(controlMatches) >>> 3;
            int bucket = this.bucket(vectorStartBucket + slot);
            if (!this.valueNotDistinctFrom(bucket, otherValues, otherVariableWidthData, position)) continue;
            return bucket;
        }
        return -1;
    }

    private int matchInVector(Block block, int position, int vectorStartBucket, long repeated, long controlVector) {
        for (long controlMatches = JoinDomainBuilder.match(controlVector, repeated); controlMatches != 0L; controlMatches &= controlMatches - 1L) {
            int bucket = this.bucket(vectorStartBucket + (Long.numberOfTrailingZeros(controlMatches) >>> 3));
            if (!this.valueNotDistinctFrom(bucket, block, position)) continue;
            return bucket;
        }
        return -1;
    }

    private int findEmptyInVector(long vector, int vectorStartBucket) {
        long controlMatches = JoinDomainBuilder.match(vector, 0L);
        if (controlMatches == 0L) {
            return -1;
        }
        int slot = Long.numberOfTrailingZeros(controlMatches) >>> 3;
        return this.bucket(vectorStartBucket + slot);
    }

    private void insert(int index, Block block, int position, byte hashPrefix) {
        this.setControl(index, hashPrefix);
        int recordOffset = this.getRecordOffset(index);
        byte[] variableWidthChunk = VariableWidthData.EMPTY_CHUNK;
        int variableWidthChunkOffset = 0;
        if (this.distinctVariableWidthData != null) {
            int variableWidthLength = this.type.getFlatVariableWidthSize(block, position);
            variableWidthChunk = this.distinctVariableWidthData.allocate(this.distinctRecords, recordOffset, variableWidthLength);
            variableWidthChunkOffset = VariableWidthData.getChunkOffset(this.distinctRecords, recordOffset);
        }
        try {
            this.writeFlat.invokeExact(block, position, this.distinctRecords, recordOffset + this.distinctRecordValueOffset, variableWidthChunk, variableWidthChunkOffset);
        }
        catch (Throwable throwable) {
            Throwables.throwIfUnchecked((Throwable)throwable);
            throw new RuntimeException(throwable);
        }
    }

    private void setControl(int index, byte hashPrefix) {
        this.distinctControl[index] = hashPrefix;
        if (index < 8) {
            this.distinctControl[index + this.distinctCapacity] = hashPrefix;
        }
    }

    private void rehash() {
        int oldCapacity = this.distinctCapacity;
        byte[] oldControl = this.distinctControl;
        byte[] oldRecords = this.distinctRecords;
        long newCapacityLong = (long)this.distinctCapacity * 2L;
        if (newCapacityLong > Integer.MAX_VALUE) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INSUFFICIENT_RESOURCES, "Size of hash table cannot exceed 1 billion entries");
        }
        this.distinctSize = 0;
        this.distinctCapacity = (int)newCapacityLong;
        this.distinctMaxFill = this.distinctCapacity / 16 * 15;
        this.distinctMask = this.distinctCapacity - 1;
        this.distinctControl = new byte[this.distinctCapacity + 8];
        this.distinctRecords = new byte[Math.multiplyExact(this.distinctCapacity, this.distinctRecordSize)];
        this.retainedSizeInBytes = this.retainedSizeInBytes - SizeOf.sizeOf((byte[])oldControl) - SizeOf.sizeOf((byte[])oldRecords) + SizeOf.sizeOf((byte[])this.distinctControl) + SizeOf.sizeOf((byte[])this.distinctRecords);
        block0: for (int oldIndex = 0; oldIndex < oldCapacity; ++oldIndex) {
            long controlVector;
            int matchIndex;
            if (oldControl[oldIndex] == 0) continue;
            long hash = this.valueHashCode(oldRecords, oldIndex);
            byte hashPrefix = JoinDomainBuilder.getHashPrefix(hash);
            int bucket = this.getHashBucket(hash);
            int step = 1;
            long repeated = JoinDomainBuilder.repeat(hashPrefix);
            while ((matchIndex = this.matchInVector(oldRecords, this.distinctVariableWidthData, oldIndex, bucket, repeated, controlVector = this.getControlVector(bucket))) < 0) {
                int emptyIndex = this.findEmptyInVector(controlVector, bucket);
                if (emptyIndex >= 0) {
                    this.setControl(emptyIndex, hashPrefix);
                    System.arraycopy(oldRecords, this.getRecordOffset(oldIndex), this.distinctRecords, this.getRecordOffset(emptyIndex), this.distinctRecordSize);
                    ++this.distinctSize;
                    continue block0;
                }
                bucket = this.bucket(bucket + step);
                step += 8;
            }
        }
    }

    private long getControlVector(int bucket) {
        return LONG_HANDLE.get(this.distinctControl, bucket);
    }

    private int getHashBucket(long hash) {
        return this.bucket((int)(hash >> 7));
    }

    private static byte getHashPrefix(long hash) {
        return (byte)(hash & 0x7FL | 0x80L);
    }

    private int bucket(int hash) {
        return hash & this.distinctMask;
    }

    private int getRecordOffset(int bucket) {
        return bucket * this.distinctRecordSize;
    }

    private Object readValueToObject(int position) {
        int recordOffset = this.getRecordOffset(position);
        try {
            byte[] variableWidthChunk = VariableWidthData.EMPTY_CHUNK;
            if (this.distinctVariableWidthData != null) {
                variableWidthChunk = this.distinctVariableWidthData.getChunk(this.distinctRecords, recordOffset);
            }
            return this.readFlat.invokeExact(this.distinctRecords, recordOffset + this.distinctRecordValueOffset, variableWidthChunk);
        }
        catch (Throwable throwable) {
            Throwables.throwIfUnchecked((Throwable)throwable);
            throw new RuntimeException(throwable);
        }
    }

    private Block readValueToBlock(int position) {
        BlockBuilder blockBuilder = this.type.createBlockBuilder(null, 1);
        TypeUtils.writeNativeValue((Type)this.type, (BlockBuilder)blockBuilder, (Object)this.readValueToObject(position));
        return blockBuilder.build();
    }

    private long valueHashCode(byte[] values, int position) {
        int recordOffset = this.getRecordOffset(position);
        try {
            byte[] variableWidthChunk = VariableWidthData.EMPTY_CHUNK;
            if (this.distinctVariableWidthData != null) {
                variableWidthChunk = this.distinctVariableWidthData.getChunk(values, recordOffset);
            }
            return this.hashFlat.invokeExact(values, recordOffset + this.distinctRecordValueOffset, variableWidthChunk);
        }
        catch (Throwable throwable) {
            Throwables.throwIfUnchecked((Throwable)throwable);
            throw new RuntimeException(throwable);
        }
    }

    private long valueHashCode(Block right, int rightPosition) {
        try {
            return this.hashBlock.invokeExact(right, rightPosition);
        }
        catch (Throwable throwable) {
            Throwables.throwIfUnchecked((Throwable)throwable);
            throw new RuntimeException(throwable);
        }
    }

    private boolean valueNotDistinctFrom(int leftPosition, Block right, int rightPosition) {
        byte[] leftFixedRecordChunk = this.distinctRecords;
        int leftRecordOffset = this.getRecordOffset(leftPosition);
        byte[] leftVariableWidthChunk = VariableWidthData.EMPTY_CHUNK;
        if (this.distinctVariableWidthData != null) {
            leftVariableWidthChunk = this.distinctVariableWidthData.getChunk(leftFixedRecordChunk, leftRecordOffset);
        }
        try {
            return !this.distinctFlatBlock.invokeExact(leftFixedRecordChunk, leftRecordOffset + this.distinctRecordValueOffset, leftVariableWidthChunk, right, rightPosition);
        }
        catch (Throwable throwable) {
            Throwables.throwIfUnchecked((Throwable)throwable);
            throw new RuntimeException(throwable);
        }
    }

    private boolean valueNotDistinctFrom(int leftPosition, byte[] rightValues, VariableWidthData rightVariableWidthData, int rightPosition) {
        byte[] leftFixedRecordChunk = this.distinctRecords;
        int leftRecordOffset = this.getRecordOffset(leftPosition);
        byte[] leftVariableWidthChunk = VariableWidthData.EMPTY_CHUNK;
        if (this.distinctVariableWidthData != null) {
            leftVariableWidthChunk = this.distinctVariableWidthData.getChunk(leftFixedRecordChunk, leftRecordOffset);
        }
        byte[] rightFixedRecordChunk = rightValues;
        int rightRecordOffset = this.getRecordOffset(rightPosition);
        byte[] rightVariableWidthChunk = VariableWidthData.EMPTY_CHUNK;
        if (rightVariableWidthData != null) {
            rightVariableWidthChunk = rightVariableWidthData.getChunk(rightFixedRecordChunk, rightRecordOffset);
        }
        try {
            return !this.distinctFlatFlat.invokeExact(leftFixedRecordChunk, leftRecordOffset + this.distinctRecordValueOffset, leftVariableWidthChunk, rightFixedRecordChunk, rightRecordOffset + this.distinctRecordValueOffset, rightVariableWidthChunk);
        }
        catch (Throwable throwable) {
            Throwables.throwIfUnchecked((Throwable)throwable);
            throw new RuntimeException(throwable);
        }
    }

    private int valueCompare(Block left, int leftPosition, Block right, int rightPosition) {
        try {
            return (int)this.compareBlockBlock.invokeExact(left, leftPosition, right, rightPosition);
        }
        catch (Throwable throwable) {
            Throwables.throwIfUnchecked((Throwable)throwable);
            throw new RuntimeException(throwable);
        }
    }

    private int valueCompare(int leftPosition, int rightPosition) {
        int leftRecordOffset = this.getRecordOffset(leftPosition);
        int rightRecordOffset = this.getRecordOffset(rightPosition);
        byte[] leftVariableWidthChunk = VariableWidthData.EMPTY_CHUNK;
        byte[] rightVariableWidthChunk = VariableWidthData.EMPTY_CHUNK;
        if (this.distinctVariableWidthData != null) {
            leftVariableWidthChunk = this.distinctVariableWidthData.getChunk(this.distinctRecords, leftRecordOffset);
            rightVariableWidthChunk = this.distinctVariableWidthData.getChunk(this.distinctRecords, rightRecordOffset);
        }
        try {
            return (int)this.compareFlatFlat.invokeExact(this.distinctRecords, leftRecordOffset + this.distinctRecordValueOffset, leftVariableWidthChunk, this.distinctRecords, rightRecordOffset + this.distinctRecordValueOffset, rightVariableWidthChunk);
        }
        catch (Throwable throwable) {
            Throwables.throwIfUnchecked((Throwable)throwable);
            throw new RuntimeException(throwable);
        }
    }

    private static long repeat(byte value) {
        return (long)(value & 0xFF) * 0x101010101010101L;
    }

    private static long match(long vector, long repeatedValue) {
        long comparison = vector ^ repeatedValue;
        return comparison - 0x101010101010101L & (comparison ^ 0xFFFFFFFFFFFFFFFFL) & 0x8080808080808080L;
    }
}

