/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.collect.ImmutableList;
import io.trino.memory.context.AggregatedMemoryContext;
import io.trino.operator.DriverYieldSignal;
import io.trino.operator.HashGenerator;
import io.trino.operator.InterpretedHashGenerator;
import io.trino.operator.PageWithPositionComparator;
import io.trino.operator.WorkProcessor;
import io.trino.spi.Page;
import io.trino.spi.PageBuilder;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeOperators;
import io.trino.util.MergeSortedPages;
import java.io.Closeable;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.stream.IntStream;

public class MergeHashSort
implements Closeable {
    private final AggregatedMemoryContext memoryContext;
    private final TypeOperators typeOperators;

    public MergeHashSort(AggregatedMemoryContext memoryContext, TypeOperators typeOperators) {
        this.memoryContext = memoryContext;
        this.typeOperators = typeOperators;
    }

    public WorkProcessor<Page> merge(List<Type> keyTypes, List<Type> allTypes, List<WorkProcessor<Page>> channels, DriverYieldSignal driverYieldSignal) {
        InterpretedHashGenerator hashGenerator = InterpretedHashGenerator.createPagePrefixHashGenerator(keyTypes, this.typeOperators);
        return MergeSortedPages.mergeSortedPages(channels, MergeHashSort.createHashPageWithPositionComparator(hashGenerator), (List)IntStream.range(0, allTypes.size()).boxed().collect(ImmutableList.toImmutableList()), allTypes, MergeHashSort.keepSameHashValuesWithinSinglePage(hashGenerator), true, this.memoryContext, driverYieldSignal);
    }

    @Override
    public void close() {
        this.memoryContext.close();
    }

    private static BiPredicate<PageBuilder, MergeSortedPages.PageWithPosition> keepSameHashValuesWithinSinglePage(InterpretedHashGenerator hashGenerator) {
        return (pageBuilder, pageWithPosition) -> {
            long hash = hashGenerator.hashPosition(pageWithPosition.getPosition(), pageWithPosition.getPage());
            if (pageBuilder.isEmpty()) return false;
            if (hashGenerator.hashPosition(pageBuilder.getPositionCount() - 1, arg_0 -> ((PageBuilder)pageBuilder).getBlockBuilder(arg_0)) == hash) return false;
            if (!pageBuilder.isFull()) return false;
            return true;
        };
    }

    private static PageWithPositionComparator createHashPageWithPositionComparator(HashGenerator hashGenerator) {
        return (leftPage, leftPosition, rightPage, rightPosition) -> {
            long leftHash = hashGenerator.hashPosition(leftPosition, leftPage);
            long rightHash = hashGenerator.hashPosition(rightPosition, rightPage);
            return Long.compare(leftHash, rightHash);
        };
    }
}

