/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.trino.Session;
import io.trino.operator.MarkDistinctHash;
import io.trino.operator.UpdateMemory;
import io.trino.operator.Work;
import io.trino.operator.aggregation.Accumulator;
import io.trino.operator.aggregation.AccumulatorFactory;
import io.trino.operator.aggregation.AggregationMask;
import io.trino.operator.aggregation.AggregationMaskBuilder;
import io.trino.operator.aggregation.GroupedAccumulator;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.IntArrayBlock;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeOperators;
import io.trino.sql.gen.JoinCompiler;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;

public class DistinctAccumulatorFactory
implements AccumulatorFactory {
    private final AccumulatorFactory delegate;
    private final List<Type> argumentTypes;
    private final JoinCompiler joinCompiler;
    private final TypeOperators typeOperators;
    private final Session session;

    public DistinctAccumulatorFactory(AccumulatorFactory delegate, List<Type> argumentTypes, JoinCompiler joinCompiler, TypeOperators typeOperators, Session session) {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        this.argumentTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(argumentTypes, "argumentTypes is null"));
        this.joinCompiler = Objects.requireNonNull(joinCompiler, "joinCompiler is null");
        this.typeOperators = Objects.requireNonNull(typeOperators, "typeOperators is null");
        this.session = Objects.requireNonNull(session, "session is null");
    }

    @Override
    public List<Class<?>> getLambdaInterfaces() {
        return this.delegate.getLambdaInterfaces();
    }

    @Override
    public Accumulator createAccumulator(List<Supplier<Object>> lambdaProviders) {
        return new DistinctAccumulator(this.delegate.createAccumulator(lambdaProviders), this.argumentTypes, this.session, this.joinCompiler, this.typeOperators);
    }

    @Override
    public Accumulator createIntermediateAccumulator(List<Supplier<Object>> lambdaProviders) {
        return this.delegate.createIntermediateAccumulator(lambdaProviders);
    }

    @Override
    public GroupedAccumulator createGroupedAccumulator(List<Supplier<Object>> lambdaProviders) {
        return new DistinctGroupedAccumulator(this.delegate.createGroupedAccumulator(lambdaProviders), this.argumentTypes, this.session, this.joinCompiler, this.typeOperators);
    }

    @Override
    public GroupedAccumulator createGroupedIntermediateAccumulator(List<Supplier<Object>> lambdaProviders) {
        return this.delegate.createGroupedIntermediateAccumulator(lambdaProviders);
    }

    @Override
    public AggregationMaskBuilder createAggregationMaskBuilder() {
        return this.delegate.createAggregationMaskBuilder();
    }

    private static class DistinctAccumulator
    implements Accumulator {
        private final Accumulator accumulator;
        private final MarkDistinctHash hash;

        private DistinctAccumulator(Accumulator accumulator, List<Type> inputTypes, Session session, JoinCompiler joinCompiler, TypeOperators typeOperators) {
            this.accumulator = Objects.requireNonNull(accumulator, "accumulator is null");
            this.hash = new MarkDistinctHash(session, inputTypes, false, joinCompiler, typeOperators, UpdateMemory.NOOP);
        }

        @Override
        public long getEstimatedSize() {
            return this.hash.getEstimatedSize() + this.accumulator.getEstimatedSize();
        }

        @Override
        public Accumulator copy() {
            throw new UnsupportedOperationException("Distinct aggregation function state can not be copied");
        }

        @Override
        public void addInput(Page arguments, AggregationMask mask) {
            Page filtered = mask.filterPage(arguments);
            Work<Block> work = this.hash.markDistinctRows(filtered);
            Preconditions.checkState((boolean)work.process());
            Block distinctMask = work.getResult();
            mask.reset(filtered.getPositionCount());
            mask.applyMaskBlock(distinctMask);
            if (mask.isSelectNone()) {
                return;
            }
            this.accumulator.addInput(filtered, mask);
        }

        @Override
        public void addIntermediate(Block block) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void evaluateIntermediate(BlockBuilder blockBuilder) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void evaluateFinal(BlockBuilder blockBuilder) {
            this.accumulator.evaluateFinal(blockBuilder);
        }
    }

    private static class DistinctGroupedAccumulator
    implements GroupedAccumulator {
        private final GroupedAccumulator accumulator;
        private final MarkDistinctHash hash;

        private DistinctGroupedAccumulator(GroupedAccumulator accumulator, List<Type> inputTypes, Session session, JoinCompiler joinCompiler, TypeOperators typeOperators) {
            this.accumulator = Objects.requireNonNull(accumulator, "accumulator is null");
            this.hash = new MarkDistinctHash(session, (List<Type>)ImmutableList.builder().add((Object)IntegerType.INTEGER).addAll(inputTypes).build(), false, joinCompiler, typeOperators, UpdateMemory.NOOP);
        }

        @Override
        public long getEstimatedSize() {
            return this.hash.getEstimatedSize() + this.accumulator.getEstimatedSize();
        }

        @Override
        public void setGroupCount(long groupCount) {
            this.accumulator.setGroupCount(groupCount);
        }

        @Override
        public void addInput(int[] groupIds, Page page, AggregationMask mask) {
            groupIds = DistinctGroupedAccumulator.maskGroupIds(groupIds, mask);
            page = mask.filterPage(page);
            Work<Block> work = this.hash.markDistinctRows(page.prependColumn((Block)new IntArrayBlock(page.getPositionCount(), Optional.empty(), groupIds)));
            Preconditions.checkState((boolean)work.process());
            Block distinctMask = work.getResult();
            mask.reset(page.getPositionCount());
            mask.applyMaskBlock(distinctMask);
            if (mask.isSelectNone()) {
                return;
            }
            this.accumulator.addInput(groupIds, page, mask);
        }

        private static int[] maskGroupIds(int[] groupIds, AggregationMask mask) {
            if (mask.isSelectAll() || mask.isSelectNone()) {
                return groupIds;
            }
            int[] newGroupIds = new int[mask.getSelectedPositionCount()];
            int[] selectedPositions = mask.getSelectedPositions();
            for (int i = 0; i < newGroupIds.length; ++i) {
                newGroupIds[i] = groupIds[selectedPositions[i]];
            }
            return newGroupIds;
        }

        @Override
        public void addIntermediate(int[] groupIds, Block block) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void evaluateIntermediate(int groupId, BlockBuilder output) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void evaluateFinal(int groupId, BlockBuilder output) {
            this.accumulator.evaluateFinal(groupId, output);
        }

        @Override
        public void prepareFinal() {
        }
    }
}

