/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation.listagg;

import com.google.common.annotations.VisibleForTesting;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.operator.aggregation.listagg.ListaggAggregationState;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.VariableWidthBlockBuilder;
import io.trino.spi.function.AggregationFunction;
import io.trino.spi.function.AggregationState;
import io.trino.spi.function.BlockIndex;
import io.trino.spi.function.BlockPosition;
import io.trino.spi.function.CombineFunction;
import io.trino.spi.function.Description;
import io.trino.spi.function.InputFunction;
import io.trino.spi.function.OutputFunction;
import io.trino.spi.function.SqlType;

@AggregationFunction(value="listagg", isOrderSensitive=true)
@Description(value="concatenates the input values with the specified separator")
public final class ListaggAggregationFunction {
    private static final int MAX_OUTPUT_LENGTH = 0x100000;
    private static final int MAX_OVERFLOW_FILLER_LENGTH = 65536;

    private ListaggAggregationFunction() {
    }

    @InputFunction
    public static void input(@AggregationState ListaggAggregationState state, @BlockPosition @SqlType(value="VARCHAR") Block value, @SqlType(value="VARCHAR") Slice separator, @SqlType(value="BOOLEAN") boolean overflowError, @SqlType(value="VARCHAR") Slice overflowFiller, @SqlType(value="BOOLEAN") boolean showOverflowEntryCount, @BlockIndex int position) {
        if (state.isEmpty()) {
            if (overflowFiller.length() > 65536) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, String.format("Overflow filler length %d exceeds maximum length %d", overflowFiller.length(), 65536));
            }
            state.setSeparator(separator);
            state.setOverflowError(overflowError);
            state.setOverflowFiller(overflowFiller);
            state.setShowOverflowEntryCount(showOverflowEntryCount);
        }
        state.add(value, position);
    }

    @CombineFunction
    public static void combine(@AggregationState ListaggAggregationState state, @AggregationState ListaggAggregationState otherState) {
        Slice previousSeparator = state.getSeparator();
        if (previousSeparator == null) {
            state.setSeparator(otherState.getSeparator());
            state.setOverflowError(otherState.isOverflowError());
            state.setOverflowFiller(otherState.getOverflowFiller());
            state.setShowOverflowEntryCount(otherState.showOverflowEntryCount());
        }
        state.merge(otherState);
    }

    @OutputFunction(value="VARCHAR")
    public static void output(ListaggAggregationState state, BlockBuilder out) {
        if (state.isEmpty()) {
            out.appendNull();
        } else {
            ListaggAggregationFunction.outputState(state, (VariableWidthBlockBuilder)out, 0x100000);
        }
    }

    @VisibleForTesting
    public static void outputState(ListaggAggregationState state, VariableWidthBlockBuilder blockBuilder, int maxOutputLength) {
        Slice separator = state.getSeparator();
        int separatorLength = separator.length();
        OutputContext context = new OutputContext();
        blockBuilder.buildEntry(out -> {
            state.forEach((block, position) -> {
                int entryLength = block.getSliceLength(position);
                int spaceRequired = entryLength + (context.emittedEntryCount > 0 ? separatorLength : 0);
                if (context.outputLength + (long)spaceRequired > (long)maxOutputLength) {
                    context.overflow = true;
                    return false;
                }
                if (context.emittedEntryCount > 0) {
                    out.writeBytes(separator, 0, separatorLength);
                    context.outputLength += (long)separatorLength;
                }
                block.writeSliceTo(position, 0, entryLength, out);
                context.outputLength += (long)entryLength;
                ++context.emittedEntryCount;
                return true;
            });
            if (context.overflow) {
                if (state.isOverflowError()) {
                    throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.EXCEEDED_FUNCTION_MEMORY_LIMIT, String.format("Concatenated string has the length in bytes larger than the maximum output length %d", maxOutputLength));
                }
                if (context.emittedEntryCount > 0) {
                    out.writeBytes(separator, 0, separatorLength);
                }
                out.writeBytes(state.getOverflowFiller(), 0, state.getOverflowFiller().length());
                if (state.showOverflowEntryCount()) {
                    out.writeBytes(Slices.utf8Slice((String)"("), 0, 1);
                    Slice count = Slices.utf8Slice((String)Integer.toString(state.getEntryCount() - context.emittedEntryCount));
                    out.writeBytes(count, 0, count.length());
                    out.writeBytes(Slices.utf8Slice((String)")"), 0, 1);
                }
            }
        });
    }

    private static class OutputContext {
        long outputLength;
        int emittedEntryCount;
        boolean overflow;

        private OutputContext() {
        }
    }
}

