/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import io.trino.annotation.UsedByGeneratedCode;
import io.trino.metadata.SqlScalarFunction;
import io.trino.operator.scalar.ChoicesSpecializedSqlScalarFunction;
import io.trino.operator.scalar.SpecializedSqlScalarFunction;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.RowBlockBuilder;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.function.BoundSignature;
import io.trino.spi.function.FunctionMetadata;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.function.OperatorType;
import io.trino.spi.function.Signature;
import io.trino.spi.function.TypeVariableConstraint;
import io.trino.spi.type.RowType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;
import io.trino.type.JsonType;
import io.trino.util.Failures;
import io.trino.util.JsonCastException;
import io.trino.util.JsonUtil;
import io.trino.util.Reflection;
import java.lang.invoke.MethodHandle;
import java.util.List;

public class JsonToRowCast
extends SqlScalarFunction {
    public static final JsonToRowCast JSON_TO_ROW = new JsonToRowCast();
    private static final MethodHandle METHOD_HANDLE = Reflection.methodHandle(JsonToRowCast.class, "toRow", RowType.class, JsonUtil.BlockBuilderAppender.class, ConnectorSession.class, Slice.class);
    private static final JsonFactory JSON_FACTORY = JsonUtil.createJsonFactory();

    private JsonToRowCast() {
        super(FunctionMetadata.scalarBuilder().signature(Signature.builder().operatorType(OperatorType.CAST).typeVariableConstraint(TypeVariableConstraint.builder((String)"T").variadicBound("row").castableFrom((Type)JsonType.JSON).build()).returnType(new TypeSignature("T", new TypeSignatureParameter[0])).argumentType((Type)JsonType.JSON).build()).nullable().build());
    }

    @Override
    protected SpecializedSqlScalarFunction specialize(BoundSignature boundSignature) {
        RowType rowType = (RowType)boundSignature.getReturnType();
        Failures.checkCondition(JsonUtil.canCastFromJson((Type)rowType), (ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, "Cannot cast JSON to %s", rowType);
        JsonUtil.BlockBuilderAppender fieldAppender = JsonUtil.BlockBuilderAppender.createBlockBuilderAppender((Type)rowType);
        MethodHandle methodHandle = METHOD_HANDLE.bindTo(rowType).bindTo(fieldAppender);
        return new ChoicesSpecializedSqlScalarFunction(boundSignature, InvocationConvention.InvocationReturnConvention.NULLABLE_RETURN, (List<InvocationConvention.InvocationArgumentConvention>)ImmutableList.of((Object)InvocationConvention.InvocationArgumentConvention.NEVER_NULL), methodHandle);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @UsedByGeneratedCode
    public static Block toRow(RowType rowType, JsonUtil.BlockBuilderAppender rowAppender, ConnectorSession connectorSession, Slice json) {
        try (JsonParser jsonParser = JsonUtil.createJsonParser(JSON_FACTORY, json);){
            jsonParser.nextToken();
            if (jsonParser.getCurrentToken() == JsonToken.VALUE_NULL) {
                Block block2 = null;
                return block2;
            }
            RowBlockBuilder rowBlockBuilder = rowType.createBlockBuilder(null, 1);
            rowAppender.append(jsonParser, (BlockBuilder)rowBlockBuilder);
            if (jsonParser.nextToken() != null) {
                throw new JsonCastException(String.format("Unexpected trailing token: %s", jsonParser.getText()));
            }
            Block block = rowType.getObject((Block)rowBlockBuilder, 0);
            return block;
        }
        catch (TrinoException | JsonCastException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast to %s. %s\n%s", rowType, e.getMessage(), JsonUtil.truncateIfNecessaryForErrorMessage(json)), e);
        }
        catch (Exception e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast to %s.\n%s", rowType, JsonUtil.truncateIfNecessaryForErrorMessage(json)), (Throwable)e);
        }
    }

    static {
        new ObjectMapper(JSON_FACTORY);
    }
}

