/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.unnest;

import com.google.common.base.Verify;
import io.trino.spi.block.Block;
import io.trino.spi.block.DictionaryBlock;
import jakarta.annotation.Nullable;
import java.util.Objects;

public class UnnestBlockBuilder {
    private final NullElementFinder nullFinder = new NullElementFinder();
    private Block source;
    private int sourcePosition;
    private Block nullCheckBlock;
    private int nullCheckBlockPosition;

    public void resetInputBlock(Block block) {
        this.resetInputBlock(block, null);
    }

    public void resetInputBlock(Block block, @Nullable Block nullCheckBlock) {
        this.source = Objects.requireNonNull(block, "block is null");
        this.nullFinder.resetCheck(block);
        this.sourcePosition = 0;
        this.nullCheckBlock = nullCheckBlock;
        this.nullCheckBlockPosition = 0;
    }

    public Block buildWithoutNulls(int outputPositionCount) {
        Block output = this.source.getRegion(this.sourcePosition, outputPositionCount);
        this.sourcePosition += outputPositionCount;
        if (this.nullCheckBlock != null) {
            this.nullCheckBlockPosition += outputPositionCount;
        }
        return output;
    }

    public Block buildWithNulls(int[] outputEntriesPerPosition, int startPosition, int inputBatchSize, int outputPositionCount, int[] lengths) {
        if (this.nullFinder.getNullElementIndex() == -1) {
            this.source = this.source.copyWithAppendedNull();
            this.nullFinder.setNullElementIndex(this.source.getPositionCount() - 1);
        }
        return this.buildWithNullsByDictionary(outputEntriesPerPosition, startPosition, inputBatchSize, outputPositionCount, this.nullFinder.getNullElementIndex(), lengths);
    }

    private Block buildWithNullsByDictionary(int[] requiredOutputEntries, int offset, int inputBatchSize, int outputPositionCount, int nullIndex, int[] lengths) {
        Verify.verify((nullIndex != -1 ? 1 : 0) != 0, (String)"nullIndex is -1", (Object[])new Object[0]);
        int position = 0;
        int[] ids = new int[outputPositionCount];
        for (int i = 0; i < inputBatchSize; ++i) {
            int entryCount = lengths[offset + i];
            if (this.nullCheckBlock == null) {
                for (j = 0; j < entryCount; ++j) {
                    ids[position++] = this.sourcePosition++;
                }
            } else {
                for (j = 0; j < entryCount; ++j) {
                    ids[position++] = this.nullCheckBlock.isNull(this.nullCheckBlockPosition++) ? nullIndex : this.sourcePosition++;
                }
            }
            int maxEntryCount = requiredOutputEntries[offset + i];
            for (int j = entryCount; j < maxEntryCount; ++j) {
                ids[position++] = nullIndex;
            }
        }
        return DictionaryBlock.create((int)outputPositionCount, (Block)this.source, (int[])ids);
    }

    static class NullElementFinder {
        static final int NULL_NOT_FOUND = -1;
        private boolean checkedForNull;
        private int nullElementPosition = -1;
        private Block source;

        NullElementFinder() {
        }

        public void resetCheck(Block source) {
            this.checkedForNull = false;
            this.nullElementPosition = -1;
            this.source = Objects.requireNonNull(source, "source is null");
        }

        public int getNullElementIndex() {
            if (this.checkedForNull) {
                return this.nullElementPosition;
            }
            this.checkForNull();
            return this.nullElementPosition;
        }

        public void setNullElementIndex(int nullElementPosition) {
            this.nullElementPosition = nullElementPosition;
            this.checkedForNull = true;
        }

        private void checkForNull() {
            this.nullElementPosition = -1;
            this.checkedForNull = true;
            if (!this.source.mayHaveNull()) {
                return;
            }
            for (int i = 0; i < this.source.getPositionCount(); ++i) {
                if (!this.source.isNull(i)) continue;
                this.nullElementPosition = i;
                break;
            }
        }
    }
}

