/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import io.trino.execution.resourcegroups.ResourceGroupManager;
import io.trino.server.ResourceGroupInfo;
import io.trino.server.security.ResourceSecurity;
import io.trino.spi.resourcegroups.ResourceGroupId;
import jakarta.ws.rs.Encoded;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Response;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

@Path(value="/v1/resourceGroupState")
public class ResourceGroupStateInfoResource {
    private final ResourceGroupManager<?> resourceGroupManager;

    @Inject
    public ResourceGroupStateInfoResource(ResourceGroupManager<?> resourceGroupManager) {
        this.resourceGroupManager = Objects.requireNonNull(resourceGroupManager, "resourceGroupManager is null");
    }

    @ResourceSecurity(value=ResourceSecurity.AccessType.MANAGEMENT_READ)
    @GET
    @Produces(value={"application/json"})
    @Encoded
    @Path(value="{resourceGroupId: .+}")
    public ResourceGroupInfo getQueryStateInfos(@PathParam(value="resourceGroupId") String resourceGroupIdString) {
        if (!Strings.isNullOrEmpty((String)resourceGroupIdString)) {
            return this.resourceGroupManager.tryGetResourceGroupInfo(new ResourceGroupId((List)Arrays.stream(resourceGroupIdString.split("/")).map(ResourceGroupStateInfoResource::urlDecode).collect(ImmutableList.toImmutableList()))).orElseThrow(() -> new WebApplicationException(Response.Status.NOT_FOUND));
        }
        throw new WebApplicationException(Response.Status.NOT_FOUND);
    }

    private static String urlDecode(String value) {
        return URLDecoder.decode(value, StandardCharsets.UTF_8);
    }
}

