/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.sanity;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import io.trino.Session;
import io.trino.execution.warnings.WarningCollector;
import io.trino.spi.connector.GroupingProperty;
import io.trino.sql.PlannerContext;
import io.trino.sql.planner.TypeAnalyzer;
import io.trino.sql.planner.TypeProvider;
import io.trino.sql.planner.optimizations.LocalProperties;
import io.trino.sql.planner.optimizations.StreamPropertyDerivations;
import io.trino.sql.planner.plan.AggregationNode;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.PlanVisitor;
import io.trino.sql.planner.sanity.PlanSanityChecker;
import java.util.Iterator;
import java.util.Optional;

public class ValidateStreamingAggregations
implements PlanSanityChecker.Checker {
    @Override
    public void validate(PlanNode planNode, Session session, PlannerContext plannerContext, TypeAnalyzer typeAnalyzer, TypeProvider types, WarningCollector warningCollector) {
        planNode.accept(new Visitor(session, plannerContext, typeAnalyzer, types), null);
    }

    private static final class Visitor
    extends PlanVisitor<Void, Void> {
        private final Session session;
        private final PlannerContext plannerContext;
        private final TypeAnalyzer typeAnalyzer;
        private final TypeProvider types;

        private Visitor(Session session, PlannerContext plannerContext, TypeAnalyzer typeAnalyzer, TypeProvider types) {
            this.session = session;
            this.plannerContext = plannerContext;
            this.typeAnalyzer = typeAnalyzer;
            this.types = types;
        }

        @Override
        protected Void visitPlan(PlanNode node, Void context) {
            node.getSources().forEach(source -> source.accept(this, context));
            return null;
        }

        @Override
        public Void visitAggregation(AggregationNode node, Void context) {
            if (node.getPreGroupedSymbols().isEmpty()) {
                return null;
            }
            StreamPropertyDerivations.StreamProperties properties = StreamPropertyDerivations.derivePropertiesRecursively(node.getSource(), this.plannerContext, this.session, this.types, this.typeAnalyzer);
            ImmutableList desiredProperties = ImmutableList.of((Object)new GroupingProperty(node.getPreGroupedSymbols()));
            Iterator matchIterator = LocalProperties.match(properties.getLocalProperties(), desiredProperties).iterator();
            Optional unsatisfiedRequirement = (Optional)Iterators.getOnlyElement(matchIterator);
            Preconditions.checkArgument((boolean)unsatisfiedRequirement.isEmpty(), (Object)"Streaming aggregation with input not grouped on the grouping keys");
            return null;
        }
    }
}

