/*
 * Decompiled with CFR 0.152.
 */
package io.trino.type;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.trino.metadata.PolymorphicScalarFunctionBuilder;
import io.trino.metadata.SqlScalarFunction;
import io.trino.spi.function.OperatorType;
import io.trino.spi.function.Signature;
import io.trino.spi.type.DecimalConversions;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.Decimals;
import io.trino.sql.analyzer.TypeSignatureTranslator;
import java.util.Set;

public final class DecimalToDecimalCasts {
    public static final Signature SIGNATURE = Signature.builder().operatorType(OperatorType.CAST).argumentType(TypeSignatureTranslator.parseTypeSignature("decimal(from_precision,from_scale)", (Set<String>)ImmutableSet.of((Object)"from_precision", (Object)"from_scale"))).returnType(TypeSignatureTranslator.parseTypeSignature("decimal(to_precision,to_scale)", (Set<String>)ImmutableSet.of((Object)"to_precision", (Object)"to_scale"))).build();
    public static final SqlScalarFunction DECIMAL_TO_DECIMAL_CAST = new PolymorphicScalarFunctionBuilder(DecimalConversions.class).signature(SIGNATURE).deterministic(true).choice(choice -> choice.implementation(methodsGroup -> methodsGroup.methods("shortToShortCast").withExtraParameters(context -> {
        DecimalType argumentType = (DecimalType)context.getParameterTypes().get(0);
        DecimalType resultType = (DecimalType)context.getReturnType();
        long rescale = Decimals.longTenToNth((int)Math.abs(resultType.getScale() - argumentType.getScale()));
        return ImmutableList.of((Object)argumentType.getPrecision(), (Object)argumentType.getScale(), (Object)resultType.getPrecision(), (Object)resultType.getScale(), (Object)rescale, (Object)(rescale / 2L));
    })).implementation(methodsGroup -> methodsGroup.methods("shortToLongCast", "longToShortCast", "longToLongCast").withExtraParameters(context -> {
        DecimalType argumentType = (DecimalType)context.getParameterTypes().get(0);
        DecimalType resultType = (DecimalType)context.getReturnType();
        return ImmutableList.of((Object)argumentType.getPrecision(), (Object)argumentType.getScale(), (Object)resultType.getPrecision(), (Object)resultType.getScale());
    }))).build();

    private DecimalToDecimalCasts() {
    }
}

