/*
 * Decompiled with CFR 0.152.
 */
package io.trino;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.configuration.DefunctConfig;
import io.airlift.configuration.LegacyConfig;
import io.airlift.units.DataSize;
import io.airlift.units.MaxDataSize;
import io.trino.sql.analyzer.RegexLibrary;
import jakarta.validation.constraints.DecimalMax;
import jakarta.validation.constraints.DecimalMin;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;

@DefunctConfig(value={"analyzer.experimental-syntax-enabled", "arrayagg.implementation", "deprecated.disable-set-properties-security-check-for-create-ddl", "deprecated.group-by-uses-equal", "deprecated.legacy-char-to-varchar-coercion", "deprecated.legacy-join-using", "deprecated.legacy-map-subscript", "deprecated.legacy-order-by", "deprecated.legacy-row-field-ordinal-access", "deprecated.legacy-row-to-json-cast", "deprecated.legacy-timestamp", "deprecated.legacy-unnest-array-rows", "deprecated.legacy-update-delete-implementation", "experimental-syntax-enabled", "experimental.resource-groups-enabled", "fast-inequality-joins", "histogram.implementation", "multimapagg.implementation", "optimizer.iterative-rule-based-column-pruning", "optimizer.processing-optimization", "resource-group-manager", "spill-order-by", "experimental.spill-order-by", "spill-window-operator", "experimental.spill-window-operator", "legacy.allow-set-view-authorization"})
public class FeaturesConfig {
    @VisibleForTesting
    public static final String SPILLER_SPILL_PATH = "spiller-spill-path";
    private boolean redistributeWrites = true;
    private boolean scaleWriters = true;
    private DataSize writerScalingMinDataProcessed = DataSize.of((long)120L, (DataSize.Unit)DataSize.Unit.MEGABYTE);
    private DataSize maxMemoryPerPartitionWriter = DataSize.of((long)256L, (DataSize.Unit)DataSize.Unit.MEGABYTE);
    private DataIntegrityVerification exchangeDataIntegrityVerification = DataIntegrityVerification.ABORT;
    private boolean exchangeCompressionEnabled;
    private boolean pagesIndexEagerCompactionEnabled;
    private boolean omitDateTimeTypePrecision;
    private int maxRecursionDepth = 10;
    private int re2JDfaStatesLimit = Integer.MAX_VALUE;
    private int re2JDfaRetries = 5;
    private RegexLibrary regexLibrary = RegexLibrary.JONI;
    private boolean spillEnabled;
    private DataSize aggregationOperatorUnspillMemoryLimit = DataSize.of((long)4L, (DataSize.Unit)DataSize.Unit.MEGABYTE);
    private List<Path> spillerSpillPaths = ImmutableList.of();
    private int spillerThreads = 4;
    private double spillMaxUsedSpaceThreshold = 0.9;
    private double memoryRevokingTarget = 0.5;
    private double memoryRevokingThreshold = 0.9;
    private boolean parseDecimalLiteralsAsDouble;
    private boolean lateMaterializationEnabled;
    private DataSize filterAndProjectMinOutputPageSize = DataSize.of((long)500L, (DataSize.Unit)DataSize.Unit.KILOBYTE);
    private int filterAndProjectMinOutputPageRowCount = 256;
    private int maxGroupingSets = 2048;
    private boolean legacyCatalogRoles;
    private boolean incrementalHashArrayLoadFactorEnabled = true;
    private boolean legacyMaterializedViewGracePeriod;
    private boolean hideInaccessibleColumns;
    private boolean forceSpillingJoin;
    private boolean faultTolerantExecutionExchangeEncryptionEnabled = true;

    public boolean isOmitDateTimeTypePrecision() {
        return this.omitDateTimeTypePrecision;
    }

    @Config(value="deprecated.omit-datetime-type-precision")
    @ConfigDescription(value="Enable compatibility mode for legacy clients when rendering datetime type names with default precision")
    public FeaturesConfig setOmitDateTimeTypePrecision(boolean value) {
        this.omitDateTimeTypePrecision = value;
        return this;
    }

    public boolean isRedistributeWrites() {
        return this.redistributeWrites;
    }

    @Config(value="redistribute-writes")
    public FeaturesConfig setRedistributeWrites(boolean redistributeWrites) {
        this.redistributeWrites = redistributeWrites;
        return this;
    }

    public boolean isScaleWriters() {
        return this.scaleWriters;
    }

    @Config(value="scale-writers")
    public FeaturesConfig setScaleWriters(boolean scaleWriters) {
        this.scaleWriters = scaleWriters;
        return this;
    }

    @NotNull
    public DataSize getWriterScalingMinDataProcessed() {
        return this.writerScalingMinDataProcessed;
    }

    @Config(value="writer-scaling-min-data-processed")
    @ConfigDescription(value="Minimum amount of uncompressed output data processed by writers before writer scaling can happen")
    public FeaturesConfig setWriterScalingMinDataProcessed(DataSize writerScalingMinDataProcessed) {
        this.writerScalingMinDataProcessed = writerScalingMinDataProcessed;
        return this;
    }

    @Deprecated
    @LegacyConfig(value={"writer-min-size"}, replacedBy="writer-scaling-min-data-processed")
    @ConfigDescription(value="Target minimum size of writer output when scaling writers")
    public FeaturesConfig setWriterMinSize(DataSize writerMinSize) {
        this.writerScalingMinDataProcessed = DataSize.succinctBytes((long)(writerMinSize.toBytes() * 2L));
        return this;
    }

    @NotNull
    public DataSize getMaxMemoryPerPartitionWriter() {
        return this.maxMemoryPerPartitionWriter;
    }

    @Config(value="max-memory-per-partition-writer")
    @ConfigDescription(value="Estimated maximum memory required per partition writer in a single thread")
    public FeaturesConfig setMaxMemoryPerPartitionWriter(DataSize maxMemoryPerPartitionWriter) {
        this.maxMemoryPerPartitionWriter = maxMemoryPerPartitionWriter;
        return this;
    }

    @Min(value=2L)
    public @Min(value=2L) int getRe2JDfaStatesLimit() {
        return this.re2JDfaStatesLimit;
    }

    @Config(value="re2j.dfa-states-limit")
    public FeaturesConfig setRe2JDfaStatesLimit(int re2JDfaStatesLimit) {
        this.re2JDfaStatesLimit = re2JDfaStatesLimit;
        return this;
    }

    @Min(value=0L)
    public @Min(value=0L) int getRe2JDfaRetries() {
        return this.re2JDfaRetries;
    }

    @Config(value="re2j.dfa-retries")
    public FeaturesConfig setRe2JDfaRetries(int re2JDfaRetries) {
        this.re2JDfaRetries = re2JDfaRetries;
        return this;
    }

    public RegexLibrary getRegexLibrary() {
        return this.regexLibrary;
    }

    @Config(value="regex-library")
    public FeaturesConfig setRegexLibrary(RegexLibrary regexLibrary) {
        this.regexLibrary = regexLibrary;
        return this;
    }

    public boolean isSpillEnabled() {
        return this.spillEnabled;
    }

    @Config(value="spill-enabled")
    @LegacyConfig(value={"experimental.spill-enabled"})
    public FeaturesConfig setSpillEnabled(boolean spillEnabled) {
        this.spillEnabled = spillEnabled;
        return this;
    }

    public DataSize getAggregationOperatorUnspillMemoryLimit() {
        return this.aggregationOperatorUnspillMemoryLimit;
    }

    @Config(value="aggregation-operator-unspill-memory-limit")
    @LegacyConfig(value={"experimental.aggregation-operator-unspill-memory-limit"})
    public FeaturesConfig setAggregationOperatorUnspillMemoryLimit(DataSize aggregationOperatorUnspillMemoryLimit) {
        this.aggregationOperatorUnspillMemoryLimit = aggregationOperatorUnspillMemoryLimit;
        return this;
    }

    public List<Path> getSpillerSpillPaths() {
        return this.spillerSpillPaths;
    }

    @Config(value="spiller-spill-path")
    @LegacyConfig(value={"experimental.spiller-spill-path"})
    public FeaturesConfig setSpillerSpillPaths(String spillPaths) {
        ImmutableList spillPathsSplit = ImmutableList.copyOf((Iterable)Splitter.on((String)",").trimResults().omitEmptyStrings().split((CharSequence)spillPaths));
        this.spillerSpillPaths = (List)spillPathsSplit.stream().map(x$0 -> Paths.get(x$0, new String[0])).collect(ImmutableList.toImmutableList());
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getSpillerThreads() {
        return this.spillerThreads;
    }

    @Config(value="spiller-threads")
    @LegacyConfig(value={"experimental.spiller-threads"})
    public FeaturesConfig setSpillerThreads(int spillerThreads) {
        this.spillerThreads = spillerThreads;
        return this;
    }

    @DecimalMin(value="0.0")
    @DecimalMax(value="1.0")
    public @DecimalMin(value="0.0") @DecimalMax(value="1.0") double getMemoryRevokingThreshold() {
        return this.memoryRevokingThreshold;
    }

    @Config(value="memory-revoking-threshold")
    @LegacyConfig(value={"experimental.memory-revoking-threshold"})
    @ConfigDescription(value="Revoke memory when memory pool is filled over threshold")
    public FeaturesConfig setMemoryRevokingThreshold(double memoryRevokingThreshold) {
        this.memoryRevokingThreshold = memoryRevokingThreshold;
        return this;
    }

    @DecimalMin(value="0.0")
    @DecimalMax(value="1.0")
    public @DecimalMin(value="0.0") @DecimalMax(value="1.0") double getMemoryRevokingTarget() {
        return this.memoryRevokingTarget;
    }

    @Config(value="memory-revoking-target")
    @LegacyConfig(value={"experimental.memory-revoking-target"})
    @ConfigDescription(value="When revoking memory, try to revoke so much that pool is filled below target at the end")
    public FeaturesConfig setMemoryRevokingTarget(double memoryRevokingTarget) {
        this.memoryRevokingTarget = memoryRevokingTarget;
        return this;
    }

    public double getSpillMaxUsedSpaceThreshold() {
        return this.spillMaxUsedSpaceThreshold;
    }

    @Config(value="spiller-max-used-space-threshold")
    @LegacyConfig(value={"experimental.spiller-max-used-space-threshold"})
    public FeaturesConfig setSpillMaxUsedSpaceThreshold(double spillMaxUsedSpaceThreshold) {
        this.spillMaxUsedSpaceThreshold = spillMaxUsedSpaceThreshold;
        return this;
    }

    public boolean isExchangeCompressionEnabled() {
        return this.exchangeCompressionEnabled;
    }

    @Config(value="exchange.compression-enabled")
    public FeaturesConfig setExchangeCompressionEnabled(boolean exchangeCompressionEnabled) {
        this.exchangeCompressionEnabled = exchangeCompressionEnabled;
        return this;
    }

    public DataIntegrityVerification getExchangeDataIntegrityVerification() {
        return this.exchangeDataIntegrityVerification;
    }

    @Config(value="exchange.data-integrity-verification")
    public FeaturesConfig setExchangeDataIntegrityVerification(DataIntegrityVerification exchangeDataIntegrityVerification) {
        this.exchangeDataIntegrityVerification = exchangeDataIntegrityVerification;
        return this;
    }

    public boolean isParseDecimalLiteralsAsDouble() {
        return this.parseDecimalLiteralsAsDouble;
    }

    @Config(value="parse-decimal-literals-as-double")
    public FeaturesConfig setParseDecimalLiteralsAsDouble(boolean parseDecimalLiteralsAsDouble) {
        this.parseDecimalLiteralsAsDouble = parseDecimalLiteralsAsDouble;
        return this;
    }

    public boolean isPagesIndexEagerCompactionEnabled() {
        return this.pagesIndexEagerCompactionEnabled;
    }

    @Config(value="pages-index.eager-compaction-enabled")
    public FeaturesConfig setPagesIndexEagerCompactionEnabled(boolean pagesIndexEagerCompactionEnabled) {
        this.pagesIndexEagerCompactionEnabled = pagesIndexEagerCompactionEnabled;
        return this;
    }

    @MaxDataSize(value="1MB")
    public @MaxDataSize(value="1MB") DataSize getFilterAndProjectMinOutputPageSize() {
        return this.filterAndProjectMinOutputPageSize;
    }

    @Config(value="filter-and-project-min-output-page-size")
    @LegacyConfig(value={"experimental.filter-and-project-min-output-page-size"})
    public FeaturesConfig setFilterAndProjectMinOutputPageSize(DataSize filterAndProjectMinOutputPageSize) {
        this.filterAndProjectMinOutputPageSize = filterAndProjectMinOutputPageSize;
        return this;
    }

    @Min(value=0L)
    public @Min(value=0L) int getFilterAndProjectMinOutputPageRowCount() {
        return this.filterAndProjectMinOutputPageRowCount;
    }

    @Config(value="filter-and-project-min-output-page-row-count")
    @LegacyConfig(value={"experimental.filter-and-project-min-output-page-row-count"})
    public FeaturesConfig setFilterAndProjectMinOutputPageRowCount(int filterAndProjectMinOutputPageRowCount) {
        this.filterAndProjectMinOutputPageRowCount = filterAndProjectMinOutputPageRowCount;
        return this;
    }

    public int getMaxRecursionDepth() {
        return this.maxRecursionDepth;
    }

    @Config(value="max-recursion-depth")
    @ConfigDescription(value="Maximum recursion depth for recursive common table expression")
    public FeaturesConfig setMaxRecursionDepth(int maxRecursionDepth) {
        this.maxRecursionDepth = maxRecursionDepth;
        return this;
    }

    public int getMaxGroupingSets() {
        return this.maxGroupingSets;
    }

    @Config(value="analyzer.max-grouping-sets")
    public FeaturesConfig setMaxGroupingSets(int maxGroupingSets) {
        this.maxGroupingSets = maxGroupingSets;
        return this;
    }

    public boolean isLateMaterializationEnabled() {
        return this.lateMaterializationEnabled;
    }

    @Config(value="experimental.late-materialization.enabled")
    @LegacyConfig(value={"experimental.work-processor-pipelines"})
    public FeaturesConfig setLateMaterializationEnabled(boolean lateMaterializationEnabled) {
        this.lateMaterializationEnabled = lateMaterializationEnabled;
        return this;
    }

    public boolean isLegacyCatalogRoles() {
        return this.legacyCatalogRoles;
    }

    @Config(value="deprecated.legacy-catalog-roles")
    @ConfigDescription(value="Enable legacy role management syntax that assumed all roles are catalog scoped")
    public FeaturesConfig setLegacyCatalogRoles(boolean legacyCatalogRoles) {
        this.legacyCatalogRoles = legacyCatalogRoles;
        return this;
    }

    @Deprecated
    public boolean isIncrementalHashArrayLoadFactorEnabled() {
        return this.incrementalHashArrayLoadFactorEnabled;
    }

    @Deprecated
    @Config(value="incremental-hash-array-load-factor.enabled")
    @ConfigDescription(value="Use smaller load factor for small hash arrays in order to improve performance")
    public FeaturesConfig setIncrementalHashArrayLoadFactorEnabled(boolean incrementalHashArrayLoadFactorEnabled) {
        this.incrementalHashArrayLoadFactorEnabled = incrementalHashArrayLoadFactorEnabled;
        return this;
    }

    @Deprecated
    public boolean isLegacyMaterializedViewGracePeriod() {
        return this.legacyMaterializedViewGracePeriod;
    }

    @Deprecated
    @Config(value="legacy.materialized-view-grace-period")
    @ConfigDescription(value="Enable legacy handling of stale materialized views")
    public FeaturesConfig setLegacyMaterializedViewGracePeriod(boolean legacyMaterializedViewGracePeriod) {
        this.legacyMaterializedViewGracePeriod = legacyMaterializedViewGracePeriod;
        return this;
    }

    public boolean isHideInaccessibleColumns() {
        return this.hideInaccessibleColumns;
    }

    @Config(value="hide-inaccessible-columns")
    @ConfigDescription(value="When enabled non-accessible columns are silently filtered from results from SELECT * statements")
    public FeaturesConfig setHideInaccessibleColumns(boolean hideInaccessibleColumns) {
        this.hideInaccessibleColumns = hideInaccessibleColumns;
        return this;
    }

    public boolean isForceSpillingJoin() {
        return this.forceSpillingJoin;
    }

    @Config(value="force-spilling-join-operator")
    @ConfigDescription(value="Force spilling join operator in favour of the non-spilling one even when there is no spill")
    public FeaturesConfig setForceSpillingJoin(boolean forceSpillingJoin) {
        this.forceSpillingJoin = forceSpillingJoin;
        return this;
    }

    public boolean isFaultTolerantExecutionExchangeEncryptionEnabled() {
        return this.faultTolerantExecutionExchangeEncryptionEnabled;
    }

    @Config(value="fault-tolerant-execution.exchange-encryption-enabled")
    public FeaturesConfig setFaultTolerantExecutionExchangeEncryptionEnabled(boolean faultTolerantExecutionExchangeEncryptionEnabled) {
        this.faultTolerantExecutionExchangeEncryptionEnabled = faultTolerantExecutionExchangeEncryptionEnabled;
        return this;
    }

    public void applyFaultTolerantExecutionDefaults() {
        this.exchangeCompressionEnabled = true;
    }

    public static enum DataIntegrityVerification {
        NONE,
        ABORT,
        RETRY;

    }
}

