/*
 * Decompiled with CFR 0.152.
 */
package io.trino.connector.system;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import io.airlift.slice.Slices;
import io.airlift.units.Duration;
import io.trino.FullConnectorSession;
import io.trino.dispatcher.DispatchManager;
import io.trino.execution.QueryInfo;
import io.trino.execution.QueryStats;
import io.trino.metadata.MetadataUtil;
import io.trino.security.AccessControl;
import io.trino.security.AccessControlUtil;
import io.trino.server.BasicQueryInfo;
import io.trino.spi.ErrorCode;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.VariableWidthBlockBuilder;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.InMemoryRecordSet;
import io.trino.spi.connector.RecordCursor;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.SystemTable;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.resourcegroups.ResourceGroupId;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.DateTimeEncoding;
import io.trino.spi.type.TimeZoneKey;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.joda.time.DateTime;

public class QuerySystemTable
implements SystemTable {
    public static final SchemaTableName QUERY_TABLE_NAME = new SchemaTableName("runtime", "queries");
    public static final ConnectorTableMetadata QUERY_TABLE = MetadataUtil.TableMetadataBuilder.tableMetadataBuilder(QUERY_TABLE_NAME).column("query_id", (Type)VarcharType.createUnboundedVarcharType()).column("state", (Type)VarcharType.createUnboundedVarcharType()).column("user", (Type)VarcharType.createUnboundedVarcharType()).column("source", (Type)VarcharType.createUnboundedVarcharType()).column("query", (Type)VarcharType.createUnboundedVarcharType()).column("resource_group_id", (Type)new ArrayType((Type)VarcharType.createUnboundedVarcharType())).column("queued_time_ms", (Type)BigintType.BIGINT).column("analysis_time_ms", (Type)BigintType.BIGINT).column("planning_time_ms", (Type)BigintType.BIGINT).column("created", (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS).column("started", (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS).column("last_heartbeat", (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS).column("end", (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS).column("error_type", (Type)VarcharType.createUnboundedVarcharType()).column("error_code", (Type)VarcharType.createUnboundedVarcharType()).build();
    private final Optional<DispatchManager> dispatchManager;
    private final AccessControl accessControl;

    @Inject
    public QuerySystemTable(Optional<DispatchManager> dispatchManager, AccessControl accessControl) {
        this.dispatchManager = Objects.requireNonNull(dispatchManager, "dispatchManager is null");
        this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
    }

    public SystemTable.Distribution getDistribution() {
        return SystemTable.Distribution.ALL_COORDINATORS;
    }

    public ConnectorTableMetadata getTableMetadata() {
        return QUERY_TABLE;
    }

    public RecordCursor cursor(ConnectorTransactionHandle transactionHandle, ConnectorSession session, TupleDomain<Integer> constraint) {
        Preconditions.checkState((boolean)this.dispatchManager.isPresent(), (Object)"Query system table can return results only on coordinator");
        List<BasicQueryInfo> queries = this.dispatchManager.get().getQueries();
        queries = AccessControlUtil.filterQueries(((FullConnectorSession)session).getSession().getIdentity(), queries, this.accessControl);
        InMemoryRecordSet.Builder table = InMemoryRecordSet.builder((ConnectorTableMetadata)QUERY_TABLE);
        for (BasicQueryInfo queryInfo : queries) {
            Optional<QueryInfo> fullQueryInfo = this.dispatchManager.get().getFullQueryInfo(queryInfo.getQueryId());
            if (fullQueryInfo.isEmpty()) continue;
            QueryStats queryStats = fullQueryInfo.get().getQueryStats();
            table.addRow(new Object[]{queryInfo.getQueryId().toString(), queryInfo.getState().toString(), queryInfo.getSession().getUser(), queryInfo.getSession().getSource().orElse(null), queryInfo.getQuery(), queryInfo.getResourceGroupId().map(QuerySystemTable::resourceGroupIdToBlock).orElse(null), QuerySystemTable.toMillis(queryStats.getQueuedTime()), QuerySystemTable.toMillis(queryStats.getAnalysisTime()), QuerySystemTable.toMillis(queryStats.getPlanningTime()), QuerySystemTable.toTimestampWithTimeZoneMillis(queryStats.getCreateTime()), QuerySystemTable.toTimestampWithTimeZoneMillis(queryStats.getExecutionStartTime()), QuerySystemTable.toTimestampWithTimeZoneMillis(queryStats.getLastHeartbeat()), QuerySystemTable.toTimestampWithTimeZoneMillis(queryStats.getEndTime()), Optional.ofNullable(queryInfo.getErrorType()).map(Enum::name).orElse(null), Optional.ofNullable(queryInfo.getErrorCode()).map(ErrorCode::getName).orElse(null)});
        }
        return table.build().cursor();
    }

    private static Block resourceGroupIdToBlock(ResourceGroupId resourceGroupId) {
        Objects.requireNonNull(resourceGroupId, "resourceGroupId is null");
        List segments = resourceGroupId.getSegments();
        VariableWidthBlockBuilder blockBuilder = VarcharType.createUnboundedVarcharType().createBlockBuilder(null, segments.size());
        for (String segment : segments) {
            VarcharType.createUnboundedVarcharType().writeSlice((BlockBuilder)blockBuilder, Slices.utf8Slice((String)segment));
        }
        return blockBuilder.build();
    }

    private static Long toMillis(Duration duration) {
        if (duration == null) {
            return null;
        }
        return duration.toMillis();
    }

    private static Long toTimestampWithTimeZoneMillis(DateTime dateTime) {
        if (dateTime == null) {
            return null;
        }
        return DateTimeEncoding.packDateTimeWithZone((long)dateTime.getMillis(), (TimeZoneKey)TimeZoneKey.UTC_KEY);
    }
}

