/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.inject.Inject;
import io.trino.Session;
import io.trino.execution.DataDefinitionTask;
import io.trino.execution.QueryStateMachine;
import io.trino.execution.warnings.WarningCollector;
import io.trino.metadata.Metadata;
import io.trino.metadata.MetadataUtil;
import io.trino.metadata.QualifiedObjectName;
import io.trino.metadata.RedirectionAwareTableHandle;
import io.trino.metadata.TableHandle;
import io.trino.security.AccessControl;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.type.RowType;
import io.trino.spi.type.Type;
import io.trino.sql.analyzer.SemanticExceptions;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.RenameColumn;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;

public class RenameColumnTask
implements DataDefinitionTask<RenameColumn> {
    private final Metadata metadata;
    private final AccessControl accessControl;

    @Inject
    public RenameColumnTask(Metadata metadata, AccessControl accessControl) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
    }

    @Override
    public String getName() {
        return "RENAME COLUMN";
    }

    @Override
    public ListenableFuture<Void> execute(RenameColumn statement, QueryStateMachine stateMachine, List<Expression> parameters, WarningCollector warningCollector) {
        QualifiedObjectName originalTableName;
        Session session = stateMachine.getSession();
        RedirectionAwareTableHandle redirectionAwareTableHandle = this.metadata.getRedirectionAwareTableHandle(session, originalTableName = MetadataUtil.createQualifiedObjectName(session, (Node)statement, statement.getTable()));
        if (redirectionAwareTableHandle.tableHandle().isEmpty()) {
            if (!statement.isTableExists()) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TABLE_NOT_FOUND, (Node)statement, "Table '%s' does not exist", originalTableName);
            }
            return Futures.immediateVoidFuture();
        }
        TableHandle tableHandle = redirectionAwareTableHandle.tableHandle().get();
        String source = ((String)statement.getSource().getParts().get(0)).toLowerCase(Locale.ENGLISH);
        String target = statement.getTarget().getValue().toLowerCase(Locale.ENGLISH);
        QualifiedObjectName qualifiedTableName = redirectionAwareTableHandle.redirectedTableName().orElse(originalTableName);
        Map<String, ColumnHandle> columnHandles = this.metadata.getColumnHandles(session, tableHandle);
        ColumnHandle columnHandle = columnHandles.get(source);
        if (columnHandle == null) {
            if (!statement.isColumnExists()) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.COLUMN_NOT_FOUND, (Node)statement, "Column '%s' does not exist", source);
            }
            return Futures.immediateVoidFuture();
        }
        if (this.metadata.getColumnMetadata(session, tableHandle, columnHandle).isHidden()) {
            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)statement, "Cannot rename hidden column", new Object[0]);
        }
        if (statement.getSource().getParts().size() == 1) {
            this.accessControl.checkCanRenameColumn(session.toSecurityContext(), qualifiedTableName);
            if (columnHandles.containsKey(target)) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.COLUMN_ALREADY_EXISTS, (Node)statement, "Column '%s' already exists", target);
            }
            this.metadata.renameColumn(session, tableHandle, qualifiedTableName.asCatalogSchemaTableName(), columnHandle, target);
        } else {
            this.accessControl.checkCanAlterColumn(session.toSecurityContext(), qualifiedTableName);
            List fieldPath = statement.getSource().getParts();
            ColumnMetadata columnMetadata = this.metadata.getColumnMetadata(session, tableHandle, columnHandle);
            Type currentType = columnMetadata.getType();
            for (int i = 1; i < fieldPath.size() - 1; ++i) {
                String fieldName = (String)fieldPath.get(i);
                List<RowType.Field> candidates = RenameColumnTask.getCandidates(currentType, fieldName);
                if (candidates.isEmpty()) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.COLUMN_NOT_FOUND, (Node)statement, "Field '%s' does not exist within %s", fieldName, currentType);
                }
                if (candidates.size() > 1) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.AMBIGUOUS_NAME, (Node)statement, "Field path %s within %s is ambiguous", fieldPath, columnMetadata.getType());
                }
                currentType = ((RowType.Field)Iterables.getOnlyElement(candidates)).getType();
            }
            String sourceFieldName = (String)Iterables.getLast((Iterable)statement.getSource().getParts());
            List<RowType.Field> sourceCandidates = RenameColumnTask.getCandidates(currentType, sourceFieldName);
            if (sourceCandidates.isEmpty()) {
                if (!statement.isColumnExists()) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.COLUMN_NOT_FOUND, (Node)statement, "Field '%s' does not exist", source);
                }
                return Futures.immediateVoidFuture();
            }
            if (sourceCandidates.size() > 1) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.AMBIGUOUS_NAME, (Node)statement, "Field path %s within %s is ambiguous", fieldPath, columnMetadata.getType());
            }
            List<RowType.Field> targetCandidates = RenameColumnTask.getCandidates(currentType, target);
            if (!targetCandidates.isEmpty()) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.COLUMN_ALREADY_EXISTS, (Node)statement, "Field '%s' already exists", target);
            }
            this.metadata.renameField(session, tableHandle, fieldPath, target);
        }
        return Futures.immediateVoidFuture();
    }

    private static List<RowType.Field> getCandidates(Type type, String fieldName) {
        if (!(type instanceof RowType)) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Unsupported type: " + type);
        }
        RowType rowType = (RowType)type;
        List candidates = (List)rowType.getFields().stream().filter(rowField -> rowField.getName().isPresent() && ((String)rowField.getName().get()).equalsIgnoreCase(fieldName)).collect(ImmutableList.toImmutableList());
        return candidates;
    }
}

