/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.inject.Inject;
import io.trino.Session;
import io.trino.execution.DataDefinitionTask;
import io.trino.execution.QueryStateMachine;
import io.trino.execution.warnings.WarningCollector;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.ResetSessionAuthorization;
import io.trino.transaction.TransactionId;
import io.trino.transaction.TransactionManager;
import java.util.List;
import java.util.Objects;

public class ResetSessionAuthorizationTask
implements DataDefinitionTask<ResetSessionAuthorization> {
    private final TransactionManager transactionManager;

    @Inject
    public ResetSessionAuthorizationTask(TransactionManager transactionManager) {
        this.transactionManager = Objects.requireNonNull(transactionManager, "transactionManager is null");
    }

    @Override
    public String getName() {
        return "RESET SESSION AUTHORIZATION";
    }

    @Override
    public ListenableFuture<Void> execute(ResetSessionAuthorization statement, QueryStateMachine stateMachine, List<Expression> parameters, WarningCollector warningCollector) {
        Session session = stateMachine.getSession();
        session.getTransactionId().ifPresent(transactionId -> {
            if (!this.transactionManager.getTransactionInfo((TransactionId)transactionId).isAutoCommitContext()) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_USER_ERROR, "Can't reset authorization user in the middle of a transaction");
            }
        });
        stateMachine.resetAuthorizationUser();
        return Futures.immediateFuture(null);
    }
}

