/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.inject.Inject;
import io.airlift.slice.Slice;
import io.trino.execution.DataDefinitionTask;
import io.trino.execution.ParameterExtractor;
import io.trino.execution.QueryStateMachine;
import io.trino.execution.warnings.WarningCollector;
import io.trino.security.AccessControl;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.type.TimeZoneKey;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.PlannerContext;
import io.trino.sql.analyzer.ExpressionAnalyzer;
import io.trino.sql.analyzer.Scope;
import io.trino.sql.planner.ExpressionInterpreter;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.NodeRef;
import io.trino.sql.tree.Parameter;
import io.trino.sql.tree.SetTimeZone;
import io.trino.sql.tree.Statement;
import io.trino.type.IntervalDayTimeType;
import io.trino.util.Failures;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class SetTimeZoneTask
implements DataDefinitionTask<SetTimeZone> {
    private final PlannerContext plannerContext;
    private final AccessControl accessControl;

    @Inject
    public SetTimeZoneTask(PlannerContext plannerContext, AccessControl accessControl) {
        this.plannerContext = Objects.requireNonNull(plannerContext, "plannerContext is null");
        this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
    }

    @Override
    public String getName() {
        return "SET TIME ZONE";
    }

    @Override
    public ListenableFuture<Void> execute(SetTimeZone statement, QueryStateMachine stateMachine, List<Expression> parameters, WarningCollector warningCollector) {
        Optional<String> timeZoneId = statement.getTimeZone().map(timeZone -> this.getTimeZoneId((Expression)timeZone, statement, stateMachine, parameters, warningCollector));
        if (timeZoneId.isPresent()) {
            stateMachine.addSetSessionProperties("time_zone_id", timeZoneId.get());
        } else {
            stateMachine.addResetSessionProperties("time_zone_id");
        }
        return Futures.immediateVoidFuture();
    }

    private String getTimeZoneId(Expression expression, SetTimeZone statement, QueryStateMachine stateMachine, List<Expression> parameters, WarningCollector warningCollector) {
        TimeZoneKey timeZoneKey;
        Map<NodeRef<Parameter>, Expression> parameterLookup = ParameterExtractor.bindParameters((Statement)statement, parameters);
        ExpressionAnalyzer analyzer = ExpressionAnalyzer.createConstantAnalyzer(this.plannerContext, this.accessControl, stateMachine.getSession(), parameterLookup, warningCollector);
        Type type = analyzer.analyze(expression, Scope.create());
        if (!(type instanceof VarcharType) && !(type instanceof IntervalDayTimeType)) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, String.format("Expected expression of varchar or interval day-time type, but '%s' has %s type", expression, type.getDisplayName()));
        }
        Object timeZoneValue = ExpressionInterpreter.evaluateConstantExpression(expression, analyzer.getExpressionCoercions(), analyzer.getTypeOnlyCoercions(), this.plannerContext, stateMachine.getSession(), this.accessControl, (Set<NodeRef<Expression>>)ImmutableSet.of(), parameterLookup);
        if (timeZoneValue instanceof Slice) {
            timeZoneKey = TimeZoneKey.getTimeZoneKey((String)((Slice)timeZoneValue).toStringUtf8());
        } else if (timeZoneValue instanceof Long) {
            timeZoneKey = TimeZoneKey.getTimeZoneKeyForOffset((long)SetTimeZoneTask.getZoneOffsetMinutes((Long)timeZoneValue));
        } else {
            throw new IllegalStateException(String.format("TIME ZONE expression '%s' not supported", expression));
        }
        return timeZoneKey.getId();
    }

    private static long getZoneOffsetMinutes(long interval) {
        Failures.checkCondition(interval % 60000L == 0L, (ErrorCodeSupplier)StandardErrorCode.INVALID_LITERAL, "Invalid TIME ZONE offset interval: interval contains seconds", new Object[0]);
        return interval / 60000L;
    }
}

