/*
 * Decompiled with CFR 0.152.
 */
package io.trino.likematcher;

import io.trino.likematcher.DFA;
import it.unimi.dsi.fastutil.ints.IntArraySet;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;

final class NFA {
    private final int start;
    private final int accept;
    private final List<List<Transition>> transitions;

    private NFA(int start, int accept, List<List<Transition>> transitions) {
        this.start = start;
        this.accept = accept;
        this.transitions = Objects.requireNonNull(transitions, "transitions is null");
    }

    public DFA toDfa() {
        HashMap<Object, Integer> activeStates = new HashMap<Object, Integer>();
        DFA.Builder builder = new DFA.Builder();
        IntArraySet initial = new IntArraySet();
        initial.add(this.start);
        ArrayDeque<IntArraySet> queue = new ArrayDeque<IntArraySet>();
        queue.add(initial);
        int dfaStartState = builder.addStartState(initial.contains(this.accept));
        activeStates.put(initial, dfaStartState);
        HashSet<IntSet> visited = new HashSet<IntSet>();
        while (!queue.isEmpty()) {
            IntSet current = (IntSet)queue.poll();
            if (!visited.add(current)) continue;
            for (int byteValue = 0; byteValue < 256; ++byteValue) {
                IntArraySet next = new IntArraySet();
                IntIterator intIterator = current.iterator();
                while (intIterator.hasNext()) {
                    int nfaState = (Integer)intIterator.next();
                    for (Transition transition : this.transitions(nfaState)) {
                        Prefix prefixTransition;
                        Value valueTransition;
                        Condition condition = transition.condition();
                        int target = transition.target();
                        if (condition instanceof Value && (valueTransition = (Value)condition).value() == (byte)byteValue) {
                            next.add(target);
                            continue;
                        }
                        if (!(condition instanceof Prefix) || byteValue >>> 8 - (prefixTransition = (Prefix)condition).bits() != prefixTransition.prefix()) continue;
                        next.add(target);
                    }
                }
                if (next.isEmpty()) continue;
                int from = (Integer)activeStates.get(current);
                int to = activeStates.computeIfAbsent(next, nfaStates -> builder.addState(nfaStates.contains(this.accept)));
                builder.addTransition(from, byteValue, to);
                queue.add(next);
            }
        }
        return builder.build();
    }

    private List<Transition> transitions(int state) {
        return this.transitions.get(state);
    }

    record Transition(int target, Condition condition) {
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    static interface Condition {
    }

    record Value(byte value) implements Condition
    {
    }

    record Prefix(int prefix, int bits) implements Condition
    {
    }

    public static class Builder {
        private int nextId;
        private int start;
        private int accept;
        private final List<List<Transition>> transitions = new ArrayList<List<Transition>>();

        public int addState() {
            this.transitions.add(new ArrayList());
            return this.nextId++;
        }

        public int addStartState() {
            this.start = this.addState();
            return this.start;
        }

        public void setAccept(int state) {
            this.accept = state;
        }

        public void addTransition(int from, Condition condition, int to) {
            this.transitions.get(from).add(new Transition(to, condition));
        }

        public NFA build() {
            return new NFA(this.start, this.accept, this.transitions);
        }
    }
}

