/*
 * Decompiled with CFR 0.152.
 */
package io.trino.metadata;

import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Ordering;
import io.trino.Session;
import io.trino.metadata.FunctionBinding;
import io.trino.metadata.GlobalFunctionCatalog;
import io.trino.metadata.Metadata;
import io.trino.metadata.SignatureBinder;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.CatalogHandle;
import io.trino.spi.function.BoundSignature;
import io.trino.spi.function.CatalogSchemaFunctionName;
import io.trino.spi.function.FunctionKind;
import io.trino.spi.function.FunctionMetadata;
import io.trino.spi.function.FunctionNullability;
import io.trino.spi.function.Signature;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.TypeSignature;
import io.trino.sql.SqlPathElement;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.sql.tree.Identifier;
import io.trino.sql.tree.QualifiedName;
import io.trino.type.UnknownType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class FunctionResolver {
    private final Metadata metadata;
    private final TypeManager typeManager;

    public FunctionResolver(Metadata metadata, TypeManager typeManager) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
    }

    boolean isAggregationFunction(Session session, QualifiedName name, Function<CatalogSchemaFunctionName, Collection<CatalogFunctionMetadata>> candidateLoader) {
        for (CatalogSchemaFunctionName catalogSchemaFunctionName : FunctionResolver.toPath(session, name)) {
            Collection<CatalogFunctionMetadata> candidates = candidateLoader.apply(catalogSchemaFunctionName);
            if (candidates.isEmpty()) continue;
            return candidates.stream().map(CatalogFunctionMetadata::functionMetadata).map(FunctionMetadata::getKind).anyMatch(arg_0 -> FunctionKind.AGGREGATE.equals(arg_0));
        }
        return false;
    }

    boolean isWindowFunction(Session session, QualifiedName name, Function<CatalogSchemaFunctionName, Collection<CatalogFunctionMetadata>> candidateLoader) {
        for (CatalogSchemaFunctionName catalogSchemaFunctionName : FunctionResolver.toPath(session, name)) {
            Collection<CatalogFunctionMetadata> candidates = candidateLoader.apply(catalogSchemaFunctionName);
            if (candidates.isEmpty()) continue;
            return candidates.stream().map(CatalogFunctionMetadata::functionMetadata).map(FunctionMetadata::getKind).anyMatch(arg_0 -> FunctionKind.WINDOW.equals(arg_0));
        }
        return false;
    }

    CatalogFunctionBinding resolveCoercion(Signature signature, Collection<CatalogFunctionMetadata> candidates) {
        List exactCandidates = (List)candidates.stream().filter(function -> FunctionResolver.possibleExactCastMatch(signature, function.functionMetadata().getSignature())).collect(ImmutableList.toImmutableList());
        for (CatalogFunctionMetadata candidate : exactCandidates) {
            if (!this.canBindSignature(candidate.functionMetadata().getSignature(), signature)) continue;
            return this.toFunctionBinding(candidate, signature);
        }
        List genericCandidates = (List)candidates.stream().filter(function -> !function.functionMetadata().getSignature().getTypeVariableConstraints().isEmpty()).collect(ImmutableList.toImmutableList());
        for (CatalogFunctionMetadata candidate : genericCandidates) {
            if (!this.canBindSignature(candidate.functionMetadata().getSignature(), signature)) continue;
            return this.toFunctionBinding(candidate, signature);
        }
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.FUNCTION_IMPLEMENTATION_MISSING, String.format("%s not found", signature));
    }

    private boolean canBindSignature(Signature declaredSignature, Signature actualSignature) {
        return new SignatureBinder(this.metadata, this.typeManager, declaredSignature, false).canBind(TypeSignatureProvider.fromTypeSignatures(actualSignature.getArgumentTypes()), actualSignature.getReturnType());
    }

    private CatalogFunctionBinding toFunctionBinding(CatalogFunctionMetadata functionMetadata, Signature signature) {
        BoundSignature boundSignature = new BoundSignature(functionMetadata.name(), this.typeManager.getType(signature.getReturnType()), (List)signature.getArgumentTypes().stream().map(arg_0 -> ((TypeManager)this.typeManager).getType(arg_0)).collect(ImmutableList.toImmutableList()));
        return new CatalogFunctionBinding(functionMetadata.catalogHandle(), SignatureBinder.bindFunction(functionMetadata.functionMetadata().getFunctionId(), functionMetadata.functionMetadata().getSignature(), boundSignature));
    }

    private static boolean possibleExactCastMatch(Signature signature, Signature declaredSignature) {
        if (!declaredSignature.getTypeVariableConstraints().isEmpty()) {
            return false;
        }
        if (!declaredSignature.getReturnType().getBase().equalsIgnoreCase(signature.getReturnType().getBase())) {
            return false;
        }
        return ((TypeSignature)declaredSignature.getArgumentTypes().get(0)).getBase().equalsIgnoreCase(((TypeSignature)signature.getArgumentTypes().get(0)).getBase());
    }

    CatalogFunctionBinding resolveFunction(Session session, QualifiedName name, List<TypeSignatureProvider> parameterTypes, Function<CatalogSchemaFunctionName, Collection<CatalogFunctionMetadata>> candidateLoader) {
        ImmutableList.Builder allCandidates = ImmutableList.builder();
        for (CatalogSchemaFunctionName catalogSchemaFunctionName : FunctionResolver.toPath(session, name)) {
            Collection<CatalogFunctionMetadata> candidates = candidateLoader.apply(catalogSchemaFunctionName);
            Optional<CatalogFunctionBinding> match = this.match(parameterTypes, candidates);
            if (match.isPresent()) {
                return match.get();
            }
            allCandidates.addAll(candidates);
        }
        ImmutableList candidates = allCandidates.build();
        throw FunctionResolver.functionNotFound(name.toString(), parameterTypes, (Collection<CatalogFunctionMetadata>)candidates);
    }

    CatalogFunctionBinding resolveFullyQualifiedFunction(CatalogSchemaFunctionName name, List<TypeSignatureProvider> parameterTypes, Collection<CatalogFunctionMetadata> candidates) {
        Optional<CatalogFunctionBinding> match = this.match(parameterTypes, candidates);
        if (match.isPresent()) {
            return match.get();
        }
        throw FunctionResolver.functionNotFound(name.toString(), parameterTypes, candidates);
    }

    private static TrinoException functionNotFound(String name, List<TypeSignatureProvider> parameterTypes, Collection<CatalogFunctionMetadata> candidates) {
        if (candidates.isEmpty()) {
            return new TrinoException((ErrorCodeSupplier)StandardErrorCode.FUNCTION_NOT_FOUND, String.format("Function '%s' not registered", name));
        }
        ArrayList<String> expectedParameters = new ArrayList<String>();
        for (CatalogFunctionMetadata function : candidates) {
            String arguments = Joiner.on((String)", ").join((Iterable)function.functionMetadata().getSignature().getArgumentTypes());
            String constraints = Joiner.on((String)", ").join((Iterable)function.functionMetadata().getSignature().getTypeVariableConstraints());
            expectedParameters.add(String.format("%s(%s) %s", name, arguments, constraints).stripTrailing());
        }
        String parameters = Joiner.on((String)", ").join(parameterTypes);
        String expected = Joiner.on((String)", ").join(expectedParameters);
        String message = String.format("Unexpected parameters (%s) for function %s. Expected: %s", parameters, name, expected);
        return new TrinoException((ErrorCodeSupplier)StandardErrorCode.FUNCTION_NOT_FOUND, message);
    }

    private Optional<CatalogFunctionBinding> match(List<TypeSignatureProvider> parameterTypes, Collection<CatalogFunctionMetadata> candidates) {
        List exactCandidates = (List)candidates.stream().filter(function -> function.functionMetadata().getSignature().getTypeVariableConstraints().isEmpty()).collect(ImmutableList.toImmutableList());
        Optional<CatalogFunctionBinding> match = this.matchFunctionExact(exactCandidates, parameterTypes);
        if (match.isPresent()) {
            return match;
        }
        List genericCandidates = (List)candidates.stream().filter(function -> !function.functionMetadata().getSignature().getTypeVariableConstraints().isEmpty()).collect(ImmutableList.toImmutableList());
        match = this.matchFunctionExact(genericCandidates, parameterTypes);
        if (match.isPresent()) {
            return match;
        }
        return this.matchFunctionWithCoercion(candidates, parameterTypes);
    }

    public static List<CatalogSchemaFunctionName> toPath(Session session, QualifiedName name) {
        List parts = name.getParts();
        if (parts.size() > 3) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.FUNCTION_NOT_FOUND, "Invalid function name: " + name);
        }
        if (parts.size() == 3) {
            return ImmutableList.of((Object)new CatalogSchemaFunctionName((String)parts.get(0), (String)parts.get(1), (String)parts.get(2)));
        }
        if (parts.size() == 2) {
            String currentCatalog = session.getCatalog().orElseThrow(() -> new TrinoException((ErrorCodeSupplier)StandardErrorCode.MISSING_CATALOG_NAME, "Session default catalog must be set to resolve a partial function name: " + name));
            return ImmutableList.of((Object)new CatalogSchemaFunctionName(currentCatalog, (String)parts.get(0), (String)parts.get(1)));
        }
        ImmutableList.Builder names = ImmutableList.builder();
        names.add((Object)GlobalFunctionCatalog.builtinFunctionName((String)parts.get(0)));
        for (SqlPathElement sqlPathElement : session.getPath().getParsedPath()) {
            String catalog = sqlPathElement.getCatalog().map(Identifier::getCanonicalValue).or(session::getCatalog).orElseThrow(() -> new TrinoException((ErrorCodeSupplier)StandardErrorCode.MISSING_CATALOG_NAME, "Session default catalog must be set to resolve a partial function name: " + name));
            names.add((Object)new CatalogSchemaFunctionName(catalog, sqlPathElement.getSchema().getCanonicalValue(), (String)parts.get(0)));
        }
        return names.build();
    }

    private Optional<CatalogFunctionBinding> matchFunctionExact(List<CatalogFunctionMetadata> candidates, List<TypeSignatureProvider> actualParameters) {
        return this.matchFunction(candidates, actualParameters, false);
    }

    private Optional<CatalogFunctionBinding> matchFunctionWithCoercion(Collection<CatalogFunctionMetadata> candidates, List<TypeSignatureProvider> actualParameters) {
        return this.matchFunction(candidates, actualParameters, true);
    }

    private Optional<CatalogFunctionBinding> matchFunction(Collection<CatalogFunctionMetadata> candidates, List<TypeSignatureProvider> parameters, boolean coercionAllowed) {
        List<ApplicableFunction> applicableFunctions = this.identifyApplicableFunctions(candidates, parameters, coercionAllowed);
        if (applicableFunctions.isEmpty()) {
            return Optional.empty();
        }
        if (coercionAllowed) {
            Preconditions.checkState((!(applicableFunctions = this.selectMostSpecificFunctions(applicableFunctions, parameters)).isEmpty() ? 1 : 0) != 0, (Object)"at least single function must be left");
        }
        if (applicableFunctions.size() == 1) {
            ApplicableFunction applicableFunction = (ApplicableFunction)Iterables.getOnlyElement(applicableFunctions);
            return Optional.of(this.toFunctionBinding(applicableFunction.function(), applicableFunction.boundSignature()));
        }
        StringBuilder errorMessageBuilder = new StringBuilder();
        errorMessageBuilder.append("Could not choose a best candidate operator. Explicit type casts must be added.\n");
        errorMessageBuilder.append("Candidates are:\n");
        for (ApplicableFunction function : applicableFunctions) {
            errorMessageBuilder.append("\t * ");
            errorMessageBuilder.append(function.boundSignature());
            errorMessageBuilder.append("\n");
        }
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.AMBIGUOUS_FUNCTION_CALL, errorMessageBuilder.toString());
    }

    private List<ApplicableFunction> identifyApplicableFunctions(Collection<CatalogFunctionMetadata> candidates, List<TypeSignatureProvider> actualParameters, boolean allowCoercion) {
        ImmutableList.Builder applicableFunctions = ImmutableList.builder();
        for (CatalogFunctionMetadata function : candidates) {
            new SignatureBinder(this.metadata, this.typeManager, function.functionMetadata().getSignature(), allowCoercion).bind(actualParameters).ifPresent(signature -> applicableFunctions.add((Object)new ApplicableFunction(function, (Signature)signature)));
        }
        return applicableFunctions.build();
    }

    private List<ApplicableFunction> selectMostSpecificFunctions(List<ApplicableFunction> applicableFunctions, List<TypeSignatureProvider> parameters) {
        Preconditions.checkArgument((!applicableFunctions.isEmpty() ? 1 : 0) != 0);
        List<ApplicableFunction> mostSpecificFunctions = this.selectMostSpecificFunctions(applicableFunctions);
        if (mostSpecificFunctions.size() <= 1) {
            return mostSpecificFunctions;
        }
        Optional<List<Type>> optionalParameterTypes = this.toTypes(parameters);
        if (optionalParameterTypes.isEmpty()) {
            return mostSpecificFunctions;
        }
        List<Type> parameterTypes = optionalParameterTypes.get();
        if (!FunctionResolver.someParameterIsUnknown(parameterTypes)) {
            return mostSpecificFunctions;
        }
        List<ApplicableFunction> unknownOnlyCastFunctions = this.getUnknownOnlyCastFunctions(applicableFunctions, parameterTypes);
        if (!unknownOnlyCastFunctions.isEmpty() && (mostSpecificFunctions = unknownOnlyCastFunctions).size() == 1) {
            return mostSpecificFunctions;
        }
        if (this.returnTypeIsTheSame(mostSpecificFunctions) && FunctionResolver.allReturnNullOnGivenInputTypes(mostSpecificFunctions, parameterTypes)) {
            ApplicableFunction selectedFunction = (ApplicableFunction)Ordering.usingToString().reverse().sortedCopy(mostSpecificFunctions).get(0);
            return ImmutableList.of((Object)selectedFunction);
        }
        return mostSpecificFunctions;
    }

    private List<ApplicableFunction> selectMostSpecificFunctions(List<ApplicableFunction> candidates) {
        ArrayList<ApplicableFunction> representatives = new ArrayList<ApplicableFunction>();
        for (ApplicableFunction current : candidates) {
            boolean found = false;
            for (int i = 0; i < representatives.size(); ++i) {
                ApplicableFunction representative = (ApplicableFunction)representatives.get(i);
                if (this.isMoreSpecificThan(current, representative)) {
                    representatives.set(i, current);
                }
                if (!this.isMoreSpecificThan(current, representative) && !this.isMoreSpecificThan(representative, current)) continue;
                found = true;
                break;
            }
            if (found) continue;
            representatives.add(current);
        }
        return representatives;
    }

    private static boolean someParameterIsUnknown(List<Type> parameters) {
        return parameters.stream().anyMatch(type -> type.equals((Object)UnknownType.UNKNOWN));
    }

    private List<ApplicableFunction> getUnknownOnlyCastFunctions(List<ApplicableFunction> applicableFunction, List<Type> actualParameters) {
        return (List)applicableFunction.stream().filter(function -> this.onlyCastsUnknown((ApplicableFunction)function, actualParameters)).collect(ImmutableList.toImmutableList());
    }

    private boolean onlyCastsUnknown(ApplicableFunction applicableFunction, List<Type> actualParameters) {
        List boundTypes = (List)applicableFunction.boundSignature().getArgumentTypes().stream().map(arg_0 -> ((TypeManager)this.typeManager).getType(arg_0)).collect(ImmutableList.toImmutableList());
        Preconditions.checkState((actualParameters.size() == boundTypes.size() ? 1 : 0) != 0, (Object)"type lists are of different lengths");
        for (int i = 0; i < actualParameters.size(); ++i) {
            if (((Type)boundTypes.get(i)).equals(actualParameters.get(i)) || actualParameters.get(i) == UnknownType.UNKNOWN) continue;
            return false;
        }
        return true;
    }

    private boolean returnTypeIsTheSame(List<ApplicableFunction> applicableFunctions) {
        Set returnTypes = applicableFunctions.stream().map(function -> this.typeManager.getType(function.boundSignature().getReturnType())).collect(Collectors.toSet());
        return returnTypes.size() == 1;
    }

    private static boolean allReturnNullOnGivenInputTypes(List<ApplicableFunction> applicableFunctions, List<Type> parameters) {
        return applicableFunctions.stream().allMatch(x -> FunctionResolver.returnsNullOnGivenInputTypes(x, parameters));
    }

    private static boolean returnsNullOnGivenInputTypes(ApplicableFunction applicableFunction, List<Type> parameterTypes) {
        FunctionMetadata function = applicableFunction.functionMetadata();
        if (function.getKind() != FunctionKind.SCALAR) {
            return true;
        }
        FunctionNullability functionNullability = function.getFunctionNullability();
        for (int i = 0; i < parameterTypes.size(); ++i) {
            if (!parameterTypes.get(i).equals((Object)UnknownType.UNKNOWN) || functionNullability.isArgumentNullable(i)) continue;
            return true;
        }
        return false;
    }

    private Optional<List<Type>> toTypes(List<TypeSignatureProvider> typeSignatureProviders) {
        ImmutableList.Builder resultBuilder = ImmutableList.builder();
        for (TypeSignatureProvider typeSignatureProvider : typeSignatureProviders) {
            if (typeSignatureProvider.hasDependency()) {
                return Optional.empty();
            }
            resultBuilder.add((Object)this.typeManager.getType(typeSignatureProvider.getTypeSignature()));
        }
        return Optional.of(resultBuilder.build());
    }

    private boolean isMoreSpecificThan(ApplicableFunction left, ApplicableFunction right) {
        List<TypeSignatureProvider> resolvedTypes = TypeSignatureProvider.fromTypeSignatures(left.boundSignature().getArgumentTypes());
        return new SignatureBinder(this.metadata, this.typeManager, right.declaredSignature(), true).canBind(resolvedTypes);
    }

    record CatalogFunctionMetadata(CatalogSchemaFunctionName name, CatalogHandle catalogHandle, FunctionMetadata functionMetadata) {
        CatalogFunctionMetadata {
            Objects.requireNonNull(name, "name is null");
            Objects.requireNonNull(catalogHandle, "catalogHandle is null");
            Objects.requireNonNull(functionMetadata, "functionMetadata is null");
        }
    }

    record CatalogFunctionBinding(CatalogHandle catalogHandle, FunctionBinding functionBinding) {
        CatalogFunctionBinding {
            Objects.requireNonNull(catalogHandle, "catalogHandle is null");
            Objects.requireNonNull(functionBinding, "functionBinding is null");
        }
    }

    private record ApplicableFunction(CatalogFunctionMetadata function, Signature boundSignature) {
        public FunctionMetadata functionMetadata() {
            return this.function.functionMetadata();
        }

        public Signature declaredSignature() {
            return this.function.functionMetadata().getSignature();
        }

        @Override
        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("declaredSignature", (Object)this.function.functionMetadata().getSignature()).add("boundSignature", (Object)this.boundSignature).toString();
        }
    }
}

