/*
 * Decompiled with CFR 0.152.
 */
package io.trino.metadata;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import com.google.errorprone.annotations.ThreadSafe;
import io.trino.metadata.FunctionBundle;
import io.trino.metadata.OperatorNameUtil;
import io.trino.operator.table.ExcludeColumns;
import io.trino.operator.table.Sequence;
import io.trino.spi.function.AggregationFunctionMetadata;
import io.trino.spi.function.AggregationImplementation;
import io.trino.spi.function.BoundSignature;
import io.trino.spi.function.CatalogSchemaFunctionName;
import io.trino.spi.function.FunctionDependencies;
import io.trino.spi.function.FunctionDependencyDeclaration;
import io.trino.spi.function.FunctionId;
import io.trino.spi.function.FunctionKind;
import io.trino.spi.function.FunctionMetadata;
import io.trino.spi.function.FunctionProvider;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.function.OperatorType;
import io.trino.spi.function.ScalarFunctionImplementation;
import io.trino.spi.function.Signature;
import io.trino.spi.function.WindowFunctionSupplier;
import io.trino.spi.function.table.ConnectorTableFunctionHandle;
import io.trino.spi.function.table.TableFunctionProcessorProvider;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;

@ThreadSafe
public class GlobalFunctionCatalog
implements FunctionProvider {
    public static final String BUILTIN_SCHEMA = "builtin";
    private volatile FunctionMap functions = new FunctionMap();

    public final synchronized void addFunctions(FunctionBundle functionBundle) {
        for (FunctionMetadata functionMetadata : functionBundle.getFunctions()) {
            Preconditions.checkArgument((!functionMetadata.getSignature().getName().contains("|") ? 1 : 0) != 0, (String)"Function name cannot contain '|' character: %s", (Object)functionMetadata.getSignature());
            Preconditions.checkArgument((!functionMetadata.getSignature().getName().contains("@") ? 1 : 0) != 0, (String)"Function name cannot contain '@' character: %s", (Object)functionMetadata.getSignature());
            GlobalFunctionCatalog.checkNotSpecializedTypeOperator(functionMetadata.getSignature());
            for (FunctionMetadata existingFunction : this.functions.list()) {
                Preconditions.checkArgument((!functionMetadata.getFunctionId().equals((Object)existingFunction.getFunctionId()) ? 1 : 0) != 0, (String)"Function already registered: %s", (Object)functionMetadata.getFunctionId());
                Preconditions.checkArgument((!functionMetadata.getSignature().equals((Object)existingFunction.getSignature()) ? 1 : 0) != 0, (String)"Function already registered: %s", (Object)functionMetadata.getSignature());
            }
        }
        this.functions = new FunctionMap(this.functions, functionBundle);
    }

    private static void checkNotSpecializedTypeOperator(Signature signature) {
        String name = signature.getName();
        if (!OperatorNameUtil.isOperatorName(name)) {
            return;
        }
        OperatorType operatorType = OperatorNameUtil.unmangleOperator(name);
        Signature.Builder expectedSignature = Signature.builder().name(signature.getName()).argumentTypes(Collections.nCopies(operatorType.getArgumentCount(), new TypeSignature("T", new TypeSignatureParameter[0])));
        switch (operatorType) {
            case EQUAL: 
            case IS_DISTINCT_FROM: 
            case INDETERMINATE: {
                expectedSignature.returnType((Type)BooleanType.BOOLEAN);
                expectedSignature.comparableTypeParameter("T");
                break;
            }
            case HASH_CODE: 
            case XX_HASH_64: {
                expectedSignature.returnType((Type)BigintType.BIGINT);
                expectedSignature.comparableTypeParameter("T");
                break;
            }
            case COMPARISON_UNORDERED_FIRST: 
            case COMPARISON_UNORDERED_LAST: {
                expectedSignature.returnType((Type)IntegerType.INTEGER);
                expectedSignature.orderableTypeParameter("T");
                break;
            }
            case LESS_THAN: 
            case LESS_THAN_OR_EQUAL: {
                expectedSignature.returnType((Type)BooleanType.BOOLEAN);
                expectedSignature.orderableTypeParameter("T");
                break;
            }
            default: {
                return;
            }
        }
        Preconditions.checkArgument((boolean)signature.equals((Object)expectedSignature.build()), (String)"Can not register %s functionMetadata: %s", (Object)operatorType, (Object)signature);
    }

    public List<FunctionMetadata> listFunctions() {
        return this.functions.list();
    }

    public Collection<FunctionMetadata> getBuiltInFunctions(String functionName) {
        return this.functions.get(functionName);
    }

    public FunctionMetadata getFunctionMetadata(FunctionId functionId) {
        return this.functions.get(functionId);
    }

    public AggregationFunctionMetadata getAggregationFunctionMetadata(FunctionId functionId) {
        return this.functions.getFunctionBundle(functionId).getAggregationFunctionMetadata(functionId);
    }

    public WindowFunctionSupplier getWindowFunctionSupplier(FunctionId functionId, BoundSignature boundSignature, FunctionDependencies functionDependencies) {
        return this.functions.getFunctionBundle(functionId).getWindowFunctionSupplier(functionId, boundSignature, functionDependencies);
    }

    public AggregationImplementation getAggregationImplementation(FunctionId functionId, BoundSignature boundSignature, FunctionDependencies functionDependencies) {
        return this.functions.getFunctionBundle(functionId).getAggregationImplementation(functionId, boundSignature, functionDependencies);
    }

    public FunctionDependencyDeclaration getFunctionDependencies(FunctionId functionId, BoundSignature boundSignature) {
        return this.functions.getFunctionBundle(functionId).getFunctionDependencies(functionId, boundSignature);
    }

    public ScalarFunctionImplementation getScalarFunctionImplementation(FunctionId functionId, BoundSignature boundSignature, FunctionDependencies functionDependencies, InvocationConvention invocationConvention) {
        return this.functions.getFunctionBundle(functionId).getScalarFunctionImplementation(functionId, boundSignature, functionDependencies, invocationConvention);
    }

    public TableFunctionProcessorProvider getTableFunctionProcessorProvider(ConnectorTableFunctionHandle functionHandle) {
        if (functionHandle instanceof ExcludeColumns.ExcludeColumnsFunctionHandle) {
            return ExcludeColumns.getExcludeColumnsFunctionProcessorProvider();
        }
        if (functionHandle instanceof Sequence.SequenceFunctionHandle) {
            return Sequence.getSequenceFunctionProcessorProvider();
        }
        return null;
    }

    public static CatalogSchemaFunctionName builtinFunctionName(OperatorType operatorType) {
        return GlobalFunctionCatalog.builtinFunctionName(OperatorNameUtil.mangleOperatorName(operatorType));
    }

    public static CatalogSchemaFunctionName builtinFunctionName(String functionName) {
        return new CatalogSchemaFunctionName("system", BUILTIN_SCHEMA, functionName);
    }

    private static class FunctionMap {
        private final Map<FunctionId, FunctionBundle> functionBundlesById;
        private final Map<FunctionId, FunctionMetadata> functionsById;
        private final Multimap<String, FunctionMetadata> functionsByLowerCaseName;

        public FunctionMap() {
            this.functionBundlesById = ImmutableMap.of();
            this.functionsById = ImmutableMap.of();
            this.functionsByLowerCaseName = ImmutableListMultimap.of();
        }

        public FunctionMap(FunctionMap map, FunctionBundle functionBundle) {
            this.functionBundlesById = ImmutableMap.builder().putAll(map.functionBundlesById).putAll((Map)functionBundle.getFunctions().stream().collect(ImmutableMap.toImmutableMap(FunctionMetadata::getFunctionId, functionMetadata -> functionBundle))).buildOrThrow();
            this.functionsById = ImmutableMap.builder().putAll(map.functionsById).putAll((Map)functionBundle.getFunctions().stream().collect(ImmutableMap.toImmutableMap(FunctionMetadata::getFunctionId, Function.identity()))).buildOrThrow();
            ImmutableListMultimap.Builder functionsByName = ImmutableListMultimap.builder().putAll(map.functionsByLowerCaseName);
            functionBundle.getFunctions().forEach(functionMetadata -> functionsByName.put((Object)functionMetadata.getSignature().getName().toLowerCase(Locale.ENGLISH), functionMetadata));
            this.functionsByLowerCaseName = functionsByName.build();
            for (Map.Entry entry : this.functionsByLowerCaseName.asMap().entrySet()) {
                Collection values = (Collection)entry.getValue();
                long aggregations = values.stream().map(FunctionMetadata::getKind).filter(kind -> kind == FunctionKind.AGGREGATE).count();
                Preconditions.checkState((aggregations == 0L || aggregations == (long)values.size() ? 1 : 0) != 0, (String)"'%s' is both an aggregation and a scalar function", entry.getKey());
            }
        }

        public List<FunctionMetadata> list() {
            return ImmutableList.copyOf((Collection)this.functionsByLowerCaseName.values());
        }

        public Collection<FunctionMetadata> get(String functionName) {
            return this.functionsByLowerCaseName.get((Object)functionName.toLowerCase(Locale.ENGLISH));
        }

        public FunctionMetadata get(FunctionId functionId) {
            FunctionMetadata functionMetadata = this.functionsById.get(functionId);
            Preconditions.checkArgument((functionMetadata != null ? 1 : 0) != 0, (Object)("Unknown function implementation: " + functionId));
            return functionMetadata;
        }

        public FunctionBundle getFunctionBundle(FunctionId functionId) {
            FunctionBundle functionBundle = this.functionBundlesById.get(functionId);
            Preconditions.checkArgument((functionBundle != null ? 1 : 0) != 0, (Object)("Unknown function implementation: " + functionId));
            return functionBundle;
        }
    }
}

