/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.collect.ImmutableList;
import io.airlift.bytecode.Access;
import io.airlift.bytecode.BytecodeBlock;
import io.airlift.bytecode.BytecodeNode;
import io.airlift.bytecode.ClassDefinition;
import io.airlift.bytecode.FieldDefinition;
import io.airlift.bytecode.MethodDefinition;
import io.airlift.bytecode.Parameter;
import io.airlift.bytecode.ParameterizedType;
import io.airlift.bytecode.Scope;
import io.airlift.bytecode.Variable;
import io.airlift.bytecode.control.IfStatement;
import io.airlift.bytecode.expression.BytecodeExpression;
import io.airlift.bytecode.expression.BytecodeExpressions;
import io.trino.operator.FlatHashStrategy;
import io.trino.operator.scalar.CombineHashFunction;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeOperators;
import io.trino.sql.gen.Bootstrap;
import io.trino.sql.gen.BytecodeUtils;
import io.trino.sql.gen.CallSiteBinder;
import io.trino.sql.gen.SqlTypeBytecodeExpression;
import io.trino.util.CompilerUtils;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public final class FlatHashStrategyCompiler {
    private FlatHashStrategyCompiler() {
    }

    public static FlatHashStrategy compileFlatHashStrategy(List<Type> types, TypeOperators typeOperators) {
        boolean anyVariableWidth = (int)types.stream().filter(Type::isFlatVariableWidth).count() > 0;
        ArrayList<KeyField> keyFields = new ArrayList<KeyField>();
        int fixedOffset = 0;
        for (int i = 0; i < types.size(); ++i) {
            Type type = types.get(i);
            keyFields.add(new KeyField(i, type, fixedOffset, fixedOffset + 1, typeOperators.getReadValueOperator(type, InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.BLOCK_BUILDER, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.FLAT})), typeOperators.getReadValueOperator(type, InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.FLAT_RETURN, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION_NOT_NULL})), typeOperators.getDistinctFromOperator(type, InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.FLAT, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION_NOT_NULL})), typeOperators.getHashCodeOperator(type, InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.FLAT})), typeOperators.getHashCodeOperator(type, InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION_NOT_NULL}))));
            fixedOffset += 1 + type.getFlatFixedSize();
        }
        CallSiteBinder callSiteBinder = new CallSiteBinder();
        ClassDefinition definition = new ClassDefinition(Access.a((Access[])new Access[]{Access.PUBLIC, Access.FINAL}), CompilerUtils.makeClassName("FlatHashStrategy"), ParameterizedType.type(Object.class), new ParameterizedType[]{ParameterizedType.type(FlatHashStrategy.class)});
        FieldDefinition typesField = definition.declareField(Access.a((Access[])new Access[]{Access.PRIVATE, Access.FINAL}), "types", ParameterizedType.type(List.class, (Class[])new Class[]{Type.class}));
        MethodDefinition constructor = definition.declareConstructor(Access.a((Access[])new Access[]{Access.PUBLIC}), new Parameter[0]);
        constructor.getBody().append((BytecodeNode)constructor.getThis()).invokeConstructor(Object.class, new Class[0]).append((BytecodeNode)constructor.getThis().setField(typesField, BytecodeUtils.loadConstant(callSiteBinder, ImmutableList.copyOf(types), List.class))).ret();
        definition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "isAnyVariableWidth", ParameterizedType.type(Boolean.TYPE), new Parameter[0]).getBody().append((BytecodeNode)BytecodeExpressions.constantBoolean((boolean)anyVariableWidth).ret());
        definition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "getTotalFlatFixedLength", ParameterizedType.type(Integer.TYPE), new Parameter[0]).getBody().append((BytecodeNode)BytecodeExpressions.constantInt((int)fixedOffset).ret());
        FlatHashStrategyCompiler.generateGetTotalVariableWidth(definition, keyFields, callSiteBinder);
        FlatHashStrategyCompiler.generateReadFlat(definition, keyFields, callSiteBinder);
        FlatHashStrategyCompiler.generateWriteFlat(definition, keyFields, callSiteBinder);
        FlatHashStrategyCompiler.generateNotDistinctFromMethod(definition, keyFields, callSiteBinder);
        FlatHashStrategyCompiler.generateHashBlock(definition, keyFields, callSiteBinder);
        FlatHashStrategyCompiler.generateHashFlat(definition, keyFields, callSiteBinder);
        try {
            return CompilerUtils.defineClass(definition, FlatHashStrategy.class, callSiteBinder.getBindings(), FlatHashStrategyCompiler.class.getClassLoader()).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    private static void generateGetTotalVariableWidth(ClassDefinition definition, List<KeyField> keyFields, CallSiteBinder callSiteBinder) {
        Parameter blocks = Parameter.arg((String)"blocks", (ParameterizedType)ParameterizedType.type(Block[].class));
        Parameter position = Parameter.arg((String)"position", (ParameterizedType)ParameterizedType.type(Integer.TYPE));
        MethodDefinition methodDefinition = definition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "getTotalVariableWidth", ParameterizedType.type(Integer.TYPE), new Parameter[]{blocks, position});
        BytecodeBlock body = methodDefinition.getBody();
        Scope scope = methodDefinition.getScope();
        Variable variableWidth = scope.declareVariable("variableWidth", body, BytecodeExpressions.constantLong((long)0L));
        for (KeyField keyField : keyFields) {
            Type type = keyField.type();
            if (!type.isFlatVariableWidth()) continue;
            body.append((BytecodeNode)new IfStatement().condition((BytecodeNode)BytecodeExpressions.not((BytecodeExpression)blocks.getElement(keyField.index()).invoke("isNull", Boolean.TYPE, new BytecodeExpression[]{position}))).ifTrue((BytecodeNode)variableWidth.set(BytecodeExpressions.add((BytecodeExpression)variableWidth, (BytecodeExpression)SqlTypeBytecodeExpression.constantType(callSiteBinder, type).invoke("getFlatVariableWidthSize", Integer.TYPE, new BytecodeExpression[]{blocks.getElement(keyField.index()), position}).cast(Long.TYPE)))));
        }
        body.append((BytecodeNode)BytecodeExpressions.invokeStatic(Math.class, (String)"toIntExact", Integer.TYPE, (BytecodeExpression[])new BytecodeExpression[]{variableWidth}).ret());
    }

    private static void generateReadFlat(ClassDefinition definition, List<KeyField> keyFields, CallSiteBinder callSiteBinder) {
        Parameter fixedChunk = Parameter.arg((String)"fixedChunk", (ParameterizedType)ParameterizedType.type(byte[].class));
        Parameter fixedOffset = Parameter.arg((String)"fixedOffset", (ParameterizedType)ParameterizedType.type(Integer.TYPE));
        Parameter variableChunk = Parameter.arg((String)"variableChunk", (ParameterizedType)ParameterizedType.type(byte[].class));
        Parameter blockBuilders = Parameter.arg((String)"blockBuilders", (ParameterizedType)ParameterizedType.type(BlockBuilder[].class));
        MethodDefinition methodDefinition = definition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "readFlat", ParameterizedType.type(Void.TYPE), new Parameter[]{fixedChunk, fixedOffset, variableChunk, blockBuilders});
        BytecodeBlock body = methodDefinition.getBody();
        for (KeyField keyField : keyFields) {
            body.append((BytecodeNode)new IfStatement().condition((BytecodeNode)BytecodeExpressions.notEqual((BytecodeExpression)fixedChunk.getElement(BytecodeExpressions.add((BytecodeExpression)fixedOffset, (BytecodeExpression)BytecodeExpressions.constantInt((int)keyField.fieldIsNullOffset()))).cast(Integer.TYPE), (BytecodeExpression)BytecodeExpressions.constantInt((int)0))).ifTrue((BytecodeNode)blockBuilders.getElement(keyField.index()).invoke("appendNull", BlockBuilder.class, new BytecodeExpression[0]).pop()).ifFalse((BytecodeNode)new BytecodeBlock().append((BytecodeNode)BytecodeExpressions.invokeDynamic((Method)Bootstrap.BOOTSTRAP_METHOD, (Iterable)ImmutableList.of((Object)callSiteBinder.bind(keyField.readFlatMethod()).getBindingId()), (String)"readFlat", Void.TYPE, (BytecodeExpression[])new BytecodeExpression[]{fixedChunk, BytecodeExpressions.add((BytecodeExpression)fixedOffset, (BytecodeExpression)BytecodeExpressions.constantInt((int)keyField.fieldFixedOffset())), variableChunk, blockBuilders.getElement(keyField.index())}))));
        }
        body.ret();
    }

    private static void generateWriteFlat(ClassDefinition definition, List<KeyField> keyFields, CallSiteBinder callSiteBinder) {
        Parameter blocks = Parameter.arg((String)"blocks", (ParameterizedType)ParameterizedType.type(Block[].class));
        Parameter position = Parameter.arg((String)"position", (ParameterizedType)ParameterizedType.type(Integer.TYPE));
        Parameter fixedChunk = Parameter.arg((String)"fixedChunk", (ParameterizedType)ParameterizedType.type(byte[].class));
        Parameter fixedOffset = Parameter.arg((String)"fixedOffset", (ParameterizedType)ParameterizedType.type(Integer.TYPE));
        Parameter variableChunk = Parameter.arg((String)"variableChunk", (ParameterizedType)ParameterizedType.type(byte[].class));
        Parameter variableOffset = Parameter.arg((String)"variableOffset", (ParameterizedType)ParameterizedType.type(Integer.TYPE));
        MethodDefinition methodDefinition = definition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "writeFlat", ParameterizedType.type(Void.TYPE), new Parameter[]{blocks, position, fixedChunk, fixedOffset, variableChunk, variableOffset});
        BytecodeBlock body = methodDefinition.getBody();
        for (KeyField keyField : keyFields) {
            BytecodeBlock writeNonNullFlat = new BytecodeBlock().append((BytecodeNode)BytecodeExpressions.invokeDynamic((Method)Bootstrap.BOOTSTRAP_METHOD, (Iterable)ImmutableList.of((Object)callSiteBinder.bind(keyField.writeFlatMethod()).getBindingId()), (String)"writeFlat", Void.TYPE, (BytecodeExpression[])new BytecodeExpression[]{blocks.getElement(keyField.index()), position, fixedChunk, BytecodeExpressions.add((BytecodeExpression)fixedOffset, (BytecodeExpression)BytecodeExpressions.constantInt((int)keyField.fieldFixedOffset())), variableChunk, variableOffset}));
            if (keyField.type().isFlatVariableWidth()) {
                writeNonNullFlat.append((BytecodeNode)variableOffset.set(BytecodeExpressions.add((BytecodeExpression)variableOffset, (BytecodeExpression)SqlTypeBytecodeExpression.constantType(callSiteBinder, keyField.type()).invoke("getFlatVariableWidthSize", Integer.TYPE, new BytecodeExpression[]{blocks.getElement(keyField.index()), position}))));
            }
            body.append((BytecodeNode)new IfStatement().condition((BytecodeNode)blocks.getElement(keyField.index()).invoke("isNull", Boolean.TYPE, new BytecodeExpression[]{position})).ifTrue((BytecodeNode)fixedChunk.setElement(BytecodeExpressions.add((BytecodeExpression)fixedOffset, (BytecodeExpression)BytecodeExpressions.constantInt((int)keyField.fieldIsNullOffset())), BytecodeExpressions.constantInt((int)1).cast(Byte.TYPE))).ifFalse((BytecodeNode)writeNonNullFlat));
        }
        body.ret();
    }

    private static void generateNotDistinctFromMethod(ClassDefinition definition, List<KeyField> keyFields, CallSiteBinder callSiteBinder) {
        Parameter leftFixedChunk = Parameter.arg((String)"leftFixedChunk", (ParameterizedType)ParameterizedType.type(byte[].class));
        Parameter leftFixedOffset = Parameter.arg((String)"leftFixedOffset", (ParameterizedType)ParameterizedType.type(Integer.TYPE));
        Parameter leftVariableChunk = Parameter.arg((String)"leftVariableChunk", (ParameterizedType)ParameterizedType.type(byte[].class));
        Parameter rightBlocks = Parameter.arg((String)"rightBlocks", (ParameterizedType)ParameterizedType.type(Block[].class));
        Parameter rightPosition = Parameter.arg((String)"rightPosition", (ParameterizedType)ParameterizedType.type(Integer.TYPE));
        MethodDefinition methodDefinition = definition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "valueNotDistinctFrom", ParameterizedType.type(Boolean.TYPE), new Parameter[]{leftFixedChunk, leftFixedOffset, leftVariableChunk, rightBlocks, rightPosition});
        BytecodeBlock body = methodDefinition.getBody();
        for (KeyField keyField : keyFields) {
            MethodDefinition distinctFromMethod = FlatHashStrategyCompiler.generateDistinctFromMethod(definition, keyField, callSiteBinder);
            body.append((BytecodeNode)new IfStatement().condition((BytecodeNode)BytecodeExpressions.invokeStatic((MethodDefinition)distinctFromMethod, (BytecodeExpression[])new BytecodeExpression[]{leftFixedChunk, leftFixedOffset, leftVariableChunk, rightBlocks.getElement(keyField.index()), rightPosition})).ifTrue((BytecodeNode)BytecodeExpressions.constantFalse().ret()));
        }
        body.append((BytecodeNode)BytecodeExpressions.constantTrue().ret());
    }

    private static MethodDefinition generateDistinctFromMethod(ClassDefinition definition, KeyField keyField, CallSiteBinder callSiteBinder) {
        Parameter leftFixedChunk = Parameter.arg((String)"leftFixedChunk", (ParameterizedType)ParameterizedType.type(byte[].class));
        Parameter leftFixedOffset = Parameter.arg((String)"leftFixedOffset", (ParameterizedType)ParameterizedType.type(Integer.TYPE));
        Parameter leftVariableChunk = Parameter.arg((String)"leftVariableChunk", (ParameterizedType)ParameterizedType.type(byte[].class));
        Parameter rightBlock = Parameter.arg((String)"rightBlock", (ParameterizedType)ParameterizedType.type(Block.class));
        Parameter rightPosition = Parameter.arg((String)"rightPosition", (ParameterizedType)ParameterizedType.type(Integer.TYPE));
        MethodDefinition methodDefinition = definition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC, Access.STATIC}), "valueDistinctFrom" + keyField.index(), ParameterizedType.type(Boolean.TYPE), new Parameter[]{leftFixedChunk, leftFixedOffset, leftVariableChunk, rightBlock, rightPosition});
        BytecodeBlock body = methodDefinition.getBody();
        Scope scope = methodDefinition.getScope();
        Variable leftIsNull = scope.declareVariable("leftIsNull", body, BytecodeExpressions.notEqual((BytecodeExpression)leftFixedChunk.getElement(BytecodeExpressions.add((BytecodeExpression)leftFixedOffset, (BytecodeExpression)BytecodeExpressions.constantInt((int)keyField.fieldIsNullOffset()))).cast(Integer.TYPE), (BytecodeExpression)BytecodeExpressions.constantInt((int)0)));
        Variable rightIsNull = scope.declareVariable("rightIsNull", body, rightBlock.invoke("isNull", Boolean.TYPE, new BytecodeExpression[]{rightPosition}));
        body.append((BytecodeNode)new IfStatement().condition((BytecodeNode)leftIsNull).ifTrue((BytecodeNode)BytecodeExpressions.not((BytecodeExpression)rightIsNull).ret()));
        body.append((BytecodeNode)new IfStatement().condition((BytecodeNode)rightIsNull).ifTrue((BytecodeNode)BytecodeExpressions.constantTrue().ret()));
        body.append((BytecodeNode)BytecodeExpressions.invokeDynamic((Method)Bootstrap.BOOTSTRAP_METHOD, (Iterable)ImmutableList.of((Object)callSiteBinder.bind(keyField.distinctFlatBlockMethod()).getBindingId()), (String)"distinctFrom", Boolean.TYPE, (BytecodeExpression[])new BytecodeExpression[]{leftFixedChunk, BytecodeExpressions.add((BytecodeExpression)leftFixedOffset, (BytecodeExpression)BytecodeExpressions.constantInt((int)keyField.fieldFixedOffset())), leftVariableChunk, rightBlock, rightPosition}).ret());
        return methodDefinition;
    }

    private static void generateHashBlock(ClassDefinition definition, List<KeyField> keyFields, CallSiteBinder callSiteBinder) {
        Parameter blocks = Parameter.arg((String)"blocks", (ParameterizedType)ParameterizedType.type(Block[].class));
        Parameter position = Parameter.arg((String)"position", (ParameterizedType)ParameterizedType.type(Integer.TYPE));
        MethodDefinition methodDefinition = definition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "hash", ParameterizedType.type(Long.TYPE), new Parameter[]{blocks, position});
        BytecodeBlock body = methodDefinition.getBody();
        Scope scope = methodDefinition.getScope();
        Variable result = scope.declareVariable("result", body, BytecodeExpressions.constantLong((long)0L));
        Variable hash = scope.declareVariable(Long.TYPE, "hash");
        Variable block = scope.declareVariable(Block.class, "block");
        for (KeyField keyField : keyFields) {
            body.append((BytecodeNode)block.set(blocks.getElement(keyField.index())));
            body.append((BytecodeNode)new IfStatement().condition((BytecodeNode)block.invoke("isNull", Boolean.TYPE, new BytecodeExpression[]{position})).ifTrue((BytecodeNode)hash.set(BytecodeExpressions.constantLong((long)0L))).ifFalse((BytecodeNode)hash.set(BytecodeExpressions.invokeDynamic((Method)Bootstrap.BOOTSTRAP_METHOD, (Iterable)ImmutableList.of((Object)callSiteBinder.bind(keyField.hashBlockMethod()).getBindingId()), (String)"hash", Long.TYPE, (BytecodeExpression[])new BytecodeExpression[]{block, position}))));
            body.append((BytecodeNode)result.set(BytecodeExpressions.invokeStatic(CombineHashFunction.class, (String)"getHash", Long.TYPE, (BytecodeExpression[])new BytecodeExpression[]{result, hash})));
        }
        body.append((BytecodeNode)result.ret());
    }

    private static void generateHashFlat(ClassDefinition definition, List<KeyField> keyFields, CallSiteBinder callSiteBinder) {
        Parameter fixedChunk = Parameter.arg((String)"fixedChunk", (ParameterizedType)ParameterizedType.type(byte[].class));
        Parameter fixedOffset = Parameter.arg((String)"fixedOffset", (ParameterizedType)ParameterizedType.type(Integer.TYPE));
        Parameter variableChunk = Parameter.arg((String)"variableChunk", (ParameterizedType)ParameterizedType.type(byte[].class));
        MethodDefinition methodDefinition = definition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "hash", ParameterizedType.type(Long.TYPE), new Parameter[]{fixedChunk, fixedOffset, variableChunk});
        BytecodeBlock body = methodDefinition.getBody();
        Scope scope = methodDefinition.getScope();
        Variable result = scope.declareVariable("result", body, BytecodeExpressions.constantLong((long)0L));
        Variable hash = scope.declareVariable(Long.TYPE, "hash");
        for (KeyField keyField : keyFields) {
            body.append((BytecodeNode)new IfStatement().condition((BytecodeNode)BytecodeExpressions.notEqual((BytecodeExpression)fixedChunk.getElement(BytecodeExpressions.add((BytecodeExpression)fixedOffset, (BytecodeExpression)BytecodeExpressions.constantInt((int)keyField.fieldIsNullOffset()))).cast(Integer.TYPE), (BytecodeExpression)BytecodeExpressions.constantInt((int)0))).ifTrue((BytecodeNode)hash.set(BytecodeExpressions.constantLong((long)0L))).ifFalse((BytecodeNode)hash.set(BytecodeExpressions.invokeDynamic((Method)Bootstrap.BOOTSTRAP_METHOD, (Iterable)ImmutableList.of((Object)callSiteBinder.bind(keyField.hashFlatMethod()).getBindingId()), (String)"hash", Long.TYPE, (BytecodeExpression[])new BytecodeExpression[]{fixedChunk, BytecodeExpressions.add((BytecodeExpression)fixedOffset, (BytecodeExpression)BytecodeExpressions.constantInt((int)keyField.fieldFixedOffset())), variableChunk}))));
            body.append((BytecodeNode)result.set(BytecodeExpressions.invokeStatic(CombineHashFunction.class, (String)"getHash", Long.TYPE, (BytecodeExpression[])new BytecodeExpression[]{result, hash})));
        }
        body.append((BytecodeNode)result.ret());
    }

    private record KeyField(int index, Type type, int fieldIsNullOffset, int fieldFixedOffset, MethodHandle readFlatMethod, MethodHandle writeFlatMethod, MethodHandle distinctFlatBlockMethod, MethodHandle hashFlatMethod, MethodHandle hashBlockMethod) {
    }
}

