/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.base.Verify;
import io.trino.operator.GroupByHash;
import io.trino.operator.UpdateMemory;
import io.trino.operator.Work;
import io.trino.spi.Page;
import io.trino.spi.PageIndexer;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeOperators;
import io.trino.sql.gen.JoinCompiler;
import java.util.List;
import java.util.Objects;

public class GroupByHashPageIndexer
implements PageIndexer {
    private final GroupByHash hash;

    public GroupByHashPageIndexer(List<Type> hashTypes, JoinCompiler joinCompiler, TypeOperators typeOperators) {
        this(GroupByHash.createGroupByHash(hashTypes, false, 20, false, joinCompiler, typeOperators, UpdateMemory.NOOP));
    }

    public GroupByHashPageIndexer(GroupByHash hash) {
        this.hash = Objects.requireNonNull(hash, "hash is null");
    }

    public int[] indexPage(Page page) {
        Work<int[]> work = this.hash.getGroupIds(page);
        boolean done = work.process();
        Verify.verify((boolean)done);
        return work.getResult();
    }

    public int getMaxIndex() {
        return this.hash.getGroupCount() - 1;
    }
}

