/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import io.airlift.slice.SizeOf;
import io.trino.operator.CompletedWork;
import io.trino.operator.GroupByHash;
import io.trino.operator.Work;
import io.trino.spi.Page;
import io.trino.spi.PageBuilder;

public class NoChannelGroupByHash
implements GroupByHash {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(NoChannelGroupByHash.class);
    private int groupCount;

    @Override
    public long getEstimatedSize() {
        return INSTANCE_SIZE;
    }

    @Override
    public int getGroupCount() {
        return this.groupCount;
    }

    @Override
    public void appendValuesTo(int groupId, PageBuilder pageBuilder) {
        throw new UnsupportedOperationException("NoChannelGroupByHash does not support appendValuesTo");
    }

    @Override
    public Work<?> addPage(Page page) {
        this.updateGroupCount(page);
        return new CompletedWork<Integer>(0);
    }

    @Override
    public Work<int[]> getGroupIds(Page page) {
        this.updateGroupCount(page);
        return new CompletedWork<int[]>(new int[page.getPositionCount()]);
    }

    @Override
    public long getRawHash(int groupId) {
        throw new UnsupportedOperationException("NoChannelGroupByHash does not support getHashCollisions");
    }

    @Override
    public int getCapacity() {
        return 2;
    }

    private void updateGroupCount(Page page) {
        if (page.getPositionCount() > 0 && this.groupCount == 0) {
            this.groupCount = 1;
        }
    }
}

