/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import io.airlift.log.Logger;
import io.airlift.slice.SizeOf;
import io.airlift.slice.Slice;
import io.airlift.units.DataSize;
import io.trino.FeaturesConfig;
import io.trino.Session;
import io.trino.geospatial.Rectangle;
import io.trino.operator.HashArraySizeSupplier;
import io.trino.operator.PagesHashStrategy;
import io.trino.operator.PagesIndexComparator;
import io.trino.operator.PagesIndexOrdering;
import io.trino.operator.PagesSpatialIndexSupplier;
import io.trino.operator.SimpleChannelComparator;
import io.trino.operator.SimplePagesHashStrategy;
import io.trino.operator.SpatialIndexBuilderOperator;
import io.trino.operator.SyntheticAddress;
import io.trino.operator.join.JoinHashSupplier;
import io.trino.operator.join.JoinUtils;
import io.trino.operator.join.LookupSource;
import io.trino.operator.join.LookupSourceSupplier;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.Page;
import io.trino.spi.PageBuilder;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.connector.SortOrder;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeOperators;
import io.trino.sql.gen.JoinCompiler;
import io.trino.sql.gen.JoinFilterFunctionCompiler;
import io.trino.sql.gen.OrderingCompiler;
import io.trino.type.BlockTypeOperators;
import it.unimi.dsi.fastutil.Swapper;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class PagesIndex
implements Swapper {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(PagesIndex.class);
    private static final Logger log = Logger.get(PagesIndex.class);
    private final OrderingCompiler orderingCompiler;
    private final JoinCompiler joinCompiler;
    private final BlockTypeOperators blockTypeOperators;
    private final List<Type> types;
    private final LongArrayList valueAddresses;
    private final ObjectArrayList<Block>[] channels;
    private final IntArrayList positionCounts;
    private final boolean eagerCompact;
    private int modificationCount;
    private int pageCount;
    private int nextBlockToCompact;
    private int positionCount;
    private long pagesMemorySize;
    private long estimatedSize;

    private PagesIndex(OrderingCompiler orderingCompiler, JoinCompiler joinCompiler, BlockTypeOperators blockTypeOperators, List<Type> types, int expectedPositions, boolean eagerCompact) {
        this.orderingCompiler = Objects.requireNonNull(orderingCompiler, "orderingCompiler is null");
        this.joinCompiler = Objects.requireNonNull(joinCompiler, "joinCompiler is null");
        this.blockTypeOperators = Objects.requireNonNull(blockTypeOperators, "blockTypeOperators is null");
        this.types = ImmutableList.copyOf((Collection)Objects.requireNonNull(types, "types is null"));
        this.valueAddresses = new LongArrayList(expectedPositions);
        this.eagerCompact = eagerCompact;
        this.channels = new ObjectArrayList[types.size()];
        for (int i = 0; i < this.channels.length; ++i) {
            this.channels[i] = ObjectArrayList.wrap((Object[])new Block[1024], (int)0);
        }
        this.positionCounts = new IntArrayList(1024);
        this.estimatedSize = this.calculateEstimatedSize();
    }

    public List<Type> getTypes() {
        return this.types;
    }

    public int getPositionCount() {
        return this.positionCount;
    }

    public LongArrayList getValueAddresses() {
        return this.valueAddresses;
    }

    public ObjectArrayList<Block> getChannel(int channel) {
        return this.channels[channel];
    }

    public void clear() {
        ++this.modificationCount;
        for (ObjectArrayList<Block> channel : this.channels) {
            channel.clear();
            channel.trim();
        }
        this.valueAddresses.clear();
        this.valueAddresses.trim();
        this.positionCount = 0;
        this.nextBlockToCompact = 0;
        this.pagesMemorySize = 0L;
        this.positionCounts.clear();
        this.positionCounts.trim();
        this.pageCount = 0;
        this.estimatedSize = this.calculateEstimatedSize();
    }

    public void addPage(Page page) {
        ++this.modificationCount;
        if (page.getPositionCount() == 0) {
            return;
        }
        ++this.pageCount;
        this.positionCount += page.getPositionCount();
        this.positionCounts.add(page.getPositionCount());
        int pageIndex = this.channels.length > 0 ? this.channels[0].size() : 0;
        for (int i = 0; i < this.channels.length; ++i) {
            Block block = page.getBlock(i);
            if (this.eagerCompact) {
                block = block.copyRegion(0, block.getPositionCount());
            }
            this.channels[i].add((Object)block);
            this.pagesMemorySize += block.getRetainedSizeInBytes();
        }
        int resultingSize = this.valueAddresses.size() + page.getPositionCount();
        if (resultingSize < 0 || resultingSize >= 2000000000) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INSUFFICIENT_RESOURCES, "Size of pages index cannot exceed 2 billion entries");
        }
        for (int position = 0; position < page.getPositionCount(); ++position) {
            this.valueAddresses.add(SyntheticAddress.encodeSyntheticAddress(pageIndex, position));
        }
        this.estimatedSize = this.calculateEstimatedSize();
    }

    public DataSize getEstimatedSize() {
        return DataSize.ofBytes((long)this.estimatedSize);
    }

    public void compact() {
        ++this.modificationCount;
        if (this.eagerCompact || this.channels.length == 0) {
            return;
        }
        for (int channel = 0; channel < this.types.size(); ++channel) {
            ObjectArrayList<Block> blocks = this.channels[channel];
            for (int i = this.nextBlockToCompact; i < blocks.size(); ++i) {
                Block block = (Block)blocks.get(i);
                Block compactedBlock = block.copyRegion(0, block.getPositionCount());
                blocks.set(i, (Object)compactedBlock);
                this.pagesMemorySize -= block.getRetainedSizeInBytes();
                this.pagesMemorySize += compactedBlock.getRetainedSizeInBytes();
            }
        }
        this.nextBlockToCompact = this.channels[0].size();
        this.estimatedSize = this.calculateEstimatedSize();
    }

    private long calculateEstimatedSize() {
        long elementsSize = this.channels.length > 0 ? SizeOf.sizeOf((Object[])this.channels[0].elements()) : 0L;
        long channelsArraySize = elementsSize * (long)this.channels.length;
        long addressesArraySize = SizeOf.sizeOf((long[])this.valueAddresses.elements());
        long positionCountsSize = SizeOf.sizeOf((int[])this.positionCounts.elements());
        return (long)INSTANCE_SIZE + this.pagesMemorySize + channelsArraySize + addressesArraySize + positionCountsSize;
    }

    public Type getType(int channel) {
        return this.types.get(channel);
    }

    public void swap(int a, int b) {
        long[] elements = this.valueAddresses.elements();
        long temp = elements[a];
        elements[a] = elements[b];
        elements[b] = temp;
    }

    private int buildPage(int position, int endPosition, PageBuilder pageBuilder) {
        while (!pageBuilder.isFull() && position < endPosition) {
            long pageAddress = this.valueAddresses.getLong(position);
            int blockIndex = SyntheticAddress.decodeSliceIndex(pageAddress);
            int blockPosition = SyntheticAddress.decodePosition(pageAddress);
            pageBuilder.declarePosition();
            for (int channel = 0; channel < this.channels.length; ++channel) {
                Type type = this.types.get(channel);
                Block block = (Block)this.channels[channel].get(blockIndex);
                type.appendTo(block, blockPosition, pageBuilder.getBlockBuilder(channel));
            }
            ++position;
        }
        return position;
    }

    public void appendTo(int channel, int position, BlockBuilder output) {
        long pageAddress = this.valueAddresses.getLong(position);
        Type type = this.types.get(channel);
        Block block = (Block)this.channels[channel].get(SyntheticAddress.decodeSliceIndex(pageAddress));
        int blockPosition = SyntheticAddress.decodePosition(pageAddress);
        type.appendTo(block, blockPosition, output);
    }

    public boolean isNull(int channel, int position) {
        long pageAddress = this.valueAddresses.getLong(position);
        Block block = (Block)this.channels[channel].get(SyntheticAddress.decodeSliceIndex(pageAddress));
        int blockPosition = SyntheticAddress.decodePosition(pageAddress);
        return block.isNull(blockPosition);
    }

    public boolean getBoolean(int channel, int position) {
        long pageAddress = this.valueAddresses.getLong(position);
        Block block = (Block)this.channels[channel].get(SyntheticAddress.decodeSliceIndex(pageAddress));
        int blockPosition = SyntheticAddress.decodePosition(pageAddress);
        return this.types.get(channel).getBoolean(block, blockPosition);
    }

    public long getLong(int channel, int position) {
        long pageAddress = this.valueAddresses.getLong(position);
        Block block = (Block)this.channels[channel].get(SyntheticAddress.decodeSliceIndex(pageAddress));
        int blockPosition = SyntheticAddress.decodePosition(pageAddress);
        return this.types.get(channel).getLong(block, blockPosition);
    }

    public double getDouble(int channel, int position) {
        long pageAddress = this.valueAddresses.getLong(position);
        Block block = (Block)this.channels[channel].get(SyntheticAddress.decodeSliceIndex(pageAddress));
        int blockPosition = SyntheticAddress.decodePosition(pageAddress);
        return this.types.get(channel).getDouble(block, blockPosition);
    }

    public Slice getSlice(int channel, int position) {
        long pageAddress = this.valueAddresses.getLong(position);
        Block block = (Block)this.channels[channel].get(SyntheticAddress.decodeSliceIndex(pageAddress));
        int blockPosition = SyntheticAddress.decodePosition(pageAddress);
        return this.types.get(channel).getSlice(block, blockPosition);
    }

    public Object getObject(int channel, int position) {
        long pageAddress = this.valueAddresses.getLong(position);
        Block block = (Block)this.channels[channel].get(SyntheticAddress.decodeSliceIndex(pageAddress));
        int blockPosition = SyntheticAddress.decodePosition(pageAddress);
        return this.types.get(channel).getObject(block, blockPosition);
    }

    public Block getSingleValueBlock(int channel, int position) {
        long pageAddress = this.valueAddresses.getLong(position);
        Block block = (Block)this.channels[channel].get(SyntheticAddress.decodeSliceIndex(pageAddress));
        int blockPosition = SyntheticAddress.decodePosition(pageAddress);
        return block.getSingleValueBlock(blockPosition);
    }

    public Block getRawBlock(int channel, int position) {
        long pageAddress = this.valueAddresses.getLong(position);
        return (Block)this.channels[channel].get(SyntheticAddress.decodeSliceIndex(pageAddress));
    }

    public int getRawBlockPosition(int position) {
        long pageAddress = this.valueAddresses.getLong(position);
        return SyntheticAddress.decodePosition(pageAddress);
    }

    public void sort(List<Integer> sortChannels, List<SortOrder> sortOrders) {
        this.sort(sortChannels, sortOrders, 0, this.getPositionCount());
    }

    public void sort(List<Integer> sortChannels, List<SortOrder> sortOrders, int startPosition, int endPosition) {
        ++this.modificationCount;
        this.createPagesIndexComparator(sortChannels, sortOrders).sort(this, startPosition, endPosition);
    }

    public boolean positionNotDistinctFromPosition(PagesHashStrategy partitionHashStrategy, int leftPosition, int rightPosition) {
        long leftAddress = this.valueAddresses.getLong(leftPosition);
        int leftPageIndex = SyntheticAddress.decodeSliceIndex(leftAddress);
        int leftPagePosition = SyntheticAddress.decodePosition(leftAddress);
        long rightAddress = this.valueAddresses.getLong(rightPosition);
        int rightPageIndex = SyntheticAddress.decodeSliceIndex(rightAddress);
        int rightPagePosition = SyntheticAddress.decodePosition(rightAddress);
        return partitionHashStrategy.positionNotDistinctFromPosition(leftPageIndex, leftPagePosition, rightPageIndex, rightPagePosition);
    }

    public boolean positionNotDistinctFromRow(PagesHashStrategy pagesHashStrategy, int indexPosition, int rightPosition, Page rightPage) {
        long pageAddress = this.valueAddresses.getLong(indexPosition);
        int pageIndex = SyntheticAddress.decodeSliceIndex(pageAddress);
        int pagePosition = SyntheticAddress.decodePosition(pageAddress);
        return pagesHashStrategy.positionNotDistinctFromRow(pageIndex, pagePosition, rightPosition, rightPage);
    }

    private PagesIndexOrdering createPagesIndexComparator(List<Integer> sortChannels, List<SortOrder> sortOrders) {
        List sortTypes = (List)sortChannels.stream().map(this.types::get).collect(ImmutableList.toImmutableList());
        return this.orderingCompiler.compilePagesIndexOrdering(sortTypes, sortChannels, sortOrders);
    }

    public Supplier<LookupSource> createLookupSourceSupplier(Session session, List<Integer> joinChannels) {
        return this.createLookupSourceSupplier(session, joinChannels, OptionalInt.empty(), Optional.empty(), Optional.empty(), (List<JoinFilterFunctionCompiler.JoinFilterFunctionFactory>)ImmutableList.of());
    }

    public PagesHashStrategy createPagesHashStrategy(List<Integer> joinChannels, OptionalInt hashChannel) {
        return this.createPagesHashStrategy(joinChannels, hashChannel, Optional.empty());
    }

    private PagesHashStrategy createPagesHashStrategy(List<Integer> joinChannels, OptionalInt hashChannel, Optional<List<Integer>> outputChannels) {
        try {
            return this.joinCompiler.compilePagesHashStrategyFactory(this.types, joinChannels, outputChannels).createPagesHashStrategy((List<ObjectArrayList<Block>>)ImmutableList.copyOf((Object[])this.channels), hashChannel);
        }
        catch (Exception e) {
            log.error((Throwable)e, "Lookup source compile failed for types=%s error=%s", new Object[]{this.types, e});
            return new SimplePagesHashStrategy(this.types, outputChannels.orElseGet(() -> PagesIndex.rangeList(this.types.size())), (List<ObjectArrayList<Block>>)ImmutableList.copyOf((Object[])this.channels), joinChannels, hashChannel, Optional.empty(), this.blockTypeOperators);
        }
    }

    public PagesIndexComparator createChannelComparator(int leftChannel, int rightChannel) {
        Preconditions.checkArgument((boolean)this.types.get(leftChannel).equals(this.types.get(rightChannel)), (String)"comparing channels of different types: %s and %s", (Object)this.types.get(leftChannel), (Object)this.types.get(rightChannel));
        return new SimpleChannelComparator(leftChannel, rightChannel, this.blockTypeOperators.getComparisonUnorderedLastOperator(this.types.get(leftChannel)));
    }

    public LookupSourceSupplier createLookupSourceSupplier(Session session, List<Integer> joinChannels, OptionalInt hashChannel, Optional<JoinFilterFunctionCompiler.JoinFilterFunctionFactory> filterFunctionFactory, Optional<Integer> sortChannel, List<JoinFilterFunctionCompiler.JoinFilterFunctionFactory> searchFunctionFactories) {
        return this.createLookupSourceSupplier(session, joinChannels, hashChannel, filterFunctionFactory, sortChannel, searchFunctionFactories, Optional.empty(), HashArraySizeSupplier.defaultHashArraySizeSupplier());
    }

    public PagesSpatialIndexSupplier createPagesSpatialIndex(Session session, int geometryChannel, Optional<Integer> radiusChannel, Optional<Integer> partitionChannel, SpatialIndexBuilderOperator.SpatialPredicate spatialRelationshipTest, Optional<JoinFilterFunctionCompiler.JoinFilterFunctionFactory> filterFunctionFactory, List<Integer> outputChannels, Map<Integer, Rectangle> partitions) {
        ImmutableList channels = ImmutableList.copyOf((Object[])this.channels);
        return new PagesSpatialIndexSupplier(session, this.valueAddresses, this.types, outputChannels, (List<ObjectArrayList<Block>>)channels, geometryChannel, radiusChannel, partitionChannel, spatialRelationshipTest, filterFunctionFactory, partitions);
    }

    public LookupSourceSupplier createLookupSourceSupplier(Session session, List<Integer> joinChannels, OptionalInt hashChannel, Optional<JoinFilterFunctionCompiler.JoinFilterFunctionFactory> filterFunctionFactory, Optional<Integer> sortChannel, List<JoinFilterFunctionCompiler.JoinFilterFunctionFactory> searchFunctionFactories, Optional<List<Integer>> outputChannels, HashArraySizeSupplier hashArraySizeSupplier) {
        ImmutableList channels = ImmutableList.copyOf((Object[])this.channels);
        if (!joinChannels.isEmpty()) {
            JoinCompiler.LookupSourceSupplierFactory lookupSourceFactory = this.joinCompiler.compileLookupSourceFactory(this.types, joinChannels, sortChannel, outputChannels);
            return lookupSourceFactory.createLookupSourceSupplier(session, this.valueAddresses, (List<ObjectArrayList<Block>>)channels, hashChannel, filterFunctionFactory, sortChannel, searchFunctionFactories, hashArraySizeSupplier);
        }
        SimplePagesHashStrategy hashStrategy = new SimplePagesHashStrategy(this.types, outputChannels.orElseGet(() -> PagesIndex.rangeList(this.types.size())), (List<ObjectArrayList<Block>>)channels, joinChannels, hashChannel, sortChannel, this.blockTypeOperators);
        return new JoinHashSupplier(session, hashStrategy, this.valueAddresses, (List<ObjectArrayList<Block>>)channels, filterFunctionFactory, sortChannel, searchFunctionFactories, hashArraySizeSupplier, OptionalInt.empty());
    }

    private static List<Integer> rangeList(int endExclusive) {
        return (List)IntStream.range(0, endExclusive).boxed().collect(ImmutableList.toImmutableList());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("positionCount", this.positionCount).add("types", this.types).add("estimatedSize", this.estimatedSize).toString();
    }

    public Iterator<Page> getPages() {
        return new AbstractIterator<Page>(){
            private final int startingModificationCount;
            private int currentPage;
            {
                this.startingModificationCount = PagesIndex.this.modificationCount;
            }

            protected Page computeNext() {
                if (this.currentPage == PagesIndex.this.pageCount) {
                    if (this.startingModificationCount != PagesIndex.this.modificationCount) {
                        throw new ConcurrentModificationException("PagesIndex mutated during iteration: %s != %s".formatted(this.startingModificationCount, PagesIndex.this.modificationCount));
                    }
                    return (Page)this.endOfData();
                }
                int positions = PagesIndex.this.positionCounts.getInt(this.currentPage);
                Block[] blocks = (Block[])Stream.of(PagesIndex.this.channels).map(channel -> (Block)channel.get(this.currentPage)).toArray(Block[]::new);
                ++this.currentPage;
                return new Page(positions, blocks);
            }
        };
    }

    public Iterator<Page> getSortedPages() {
        return this.getSortedPagesFromRange(0, this.positionCount);
    }

    public Iterator<Page> getSortedPages(int start, int end) {
        Preconditions.checkArgument((start >= 0 && end <= this.positionCount ? 1 : 0) != 0, (Object)"position range out of bounds");
        Preconditions.checkArgument((start <= end ? 1 : 0) != 0, (Object)"invalid position range");
        return this.getSortedPagesFromRange(start, end);
    }

    private Iterator<Page> getSortedPagesFromRange(final int start, final int end) {
        return new AbstractIterator<Page>(){
            private final int startingModificationCount;
            private int currentPosition;
            private final PageBuilder pageBuilder;
            {
                this.startingModificationCount = PagesIndex.this.modificationCount;
                this.currentPosition = start;
                this.pageBuilder = new PageBuilder(PagesIndex.this.types);
            }

            public Page computeNext() {
                this.currentPosition = PagesIndex.this.buildPage(this.currentPosition, end, this.pageBuilder);
                if (this.pageBuilder.isEmpty()) {
                    if (this.startingModificationCount != PagesIndex.this.modificationCount) {
                        throw new ConcurrentModificationException("PagesIndex mutated during iteration: %s != %s".formatted(this.startingModificationCount, PagesIndex.this.modificationCount));
                    }
                    return (Page)this.endOfData();
                }
                Page page = this.pageBuilder.build();
                this.pageBuilder.reset();
                return page;
            }
        };
    }

    public long getEstimatedMemoryRequiredToCreateLookupSource(HashArraySizeSupplier hashArraySizeSupplier, Optional<Integer> sortChannel, List<Integer> joinChannels) {
        long lookupSourceEstimatedRetainedSizeInBytes = JoinHashSupplier.getEstimatedRetainedSizeInBytes(this.positionCount, this.valueAddresses, (List<ObjectArrayList<Block>>)ImmutableList.copyOf((Object[])this.channels), this.pagesMemorySize, sortChannel, JoinUtils.getSingleBigintJoinChannel(joinChannels, this.types), hashArraySizeSupplier);
        long pagesIndexAdditionalRetainedSizeInBytes = (long)INSTANCE_SIZE + SizeOf.sizeOf((int[])this.positionCounts.elements());
        return pagesIndexAdditionalRetainedSizeInBytes + lookupSourceEstimatedRetainedSizeInBytes;
    }

    public static class DefaultFactory
    implements Factory {
        private final OrderingCompiler orderingCompiler;
        private final JoinCompiler joinCompiler;
        private final boolean eagerCompact;
        private final BlockTypeOperators blockTypeOperators;

        @Inject
        public DefaultFactory(OrderingCompiler orderingCompiler, JoinCompiler joinCompiler, FeaturesConfig featuresConfig, BlockTypeOperators blockTypeOperators) {
            this.orderingCompiler = Objects.requireNonNull(orderingCompiler, "orderingCompiler is null");
            this.joinCompiler = Objects.requireNonNull(joinCompiler, "joinCompiler is null");
            this.eagerCompact = featuresConfig.isPagesIndexEagerCompactionEnabled();
            this.blockTypeOperators = Objects.requireNonNull(blockTypeOperators, "blockTypeOperators is null");
        }

        @Override
        public PagesIndex newPagesIndex(List<Type> types, int expectedPositions) {
            return new PagesIndex(this.orderingCompiler, this.joinCompiler, this.blockTypeOperators, types, expectedPositions, this.eagerCompact);
        }
    }

    public static class TestingFactory
    implements Factory {
        public static final TypeOperators TYPE_OPERATORS = new TypeOperators();
        private static final OrderingCompiler ORDERING_COMPILER = new OrderingCompiler(TYPE_OPERATORS);
        private final JoinCompiler joinCompiler;
        private static final BlockTypeOperators TYPE_OPERATOR_FACTORY = new BlockTypeOperators(TYPE_OPERATORS);
        private final boolean eagerCompact;

        public TestingFactory(boolean eagerCompact) {
            this(eagerCompact, true);
        }

        public TestingFactory(boolean eagerCompact, boolean enableSingleChannelBigintLookupSource) {
            this.eagerCompact = eagerCompact;
            this.joinCompiler = new JoinCompiler(TYPE_OPERATORS, enableSingleChannelBigintLookupSource);
        }

        @Override
        public PagesIndex newPagesIndex(List<Type> types, int expectedPositions) {
            return new PagesIndex(ORDERING_COMPILER, this.joinCompiler, TYPE_OPERATOR_FACTORY, types, expectedPositions, this.eagerCompact);
        }
    }

    public static interface Factory {
        public PagesIndex newPagesIndex(List<Type> var1, int var2);
    }
}

