/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation;

import io.airlift.stats.QuantileDigest;
import io.trino.operator.aggregation.FloatingPointBitsConverterUtil;
import io.trino.operator.aggregation.state.QuantileDigestState;
import io.trino.operator.scalar.QuantileDigestFunctions;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.function.AggregationFunction;
import io.trino.spi.function.AggregationState;
import io.trino.spi.function.CombineFunction;
import io.trino.spi.function.Description;
import io.trino.spi.function.InputFunction;
import io.trino.spi.function.OutputFunction;
import io.trino.spi.function.SqlType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.QuantileDigestType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.Type;

public final class QuantileDigestAggregationFunction {
    private static void internalInput(QuantileDigestState state, long value, long weight, double accuracy) {
        QuantileDigest qdigest = QuantileDigestAggregationFunction.getOrCreateQuantileDigest(state, QuantileDigestFunctions.verifyAccuracy(accuracy));
        state.addMemoryUsage(-qdigest.estimatedInMemorySizeInBytes());
        qdigest.add(value, QuantileDigestFunctions.verifyWeight(weight));
        state.addMemoryUsage(qdigest.estimatedInMemorySizeInBytes());
    }

    private static QuantileDigest getOrCreateQuantileDigest(QuantileDigestState state, double accuracy) {
        QuantileDigest qdigest = state.getQuantileDigest();
        if (qdigest == null) {
            qdigest = new QuantileDigest(accuracy);
            state.setQuantileDigest(qdigest);
            state.addMemoryUsage(qdigest.estimatedInMemorySizeInBytes());
        }
        return qdigest;
    }

    private static void internalCombine(QuantileDigestState state, QuantileDigestState otherState) {
        QuantileDigest input = otherState.getQuantileDigest();
        QuantileDigest previous = state.getQuantileDigest();
        if (previous == null) {
            state.setQuantileDigest(input);
            state.addMemoryUsage(input.estimatedInMemorySizeInBytes());
        } else {
            state.addMemoryUsage(-previous.estimatedInMemorySizeInBytes());
            previous.merge(input);
            state.addMemoryUsage(previous.estimatedInMemorySizeInBytes());
        }
    }

    private static void internalOutput(Type type, QuantileDigestState state, BlockBuilder out) {
        if (state.getQuantileDigest() == null) {
            out.appendNull();
        } else {
            type.writeSlice(out, state.getQuantileDigest().serialize());
        }
    }

    @AggregationFunction(value="qdigest_agg", isOrderSensitive=true)
    @Description(value="Returns a qdigest from the set of bigints")
    public static final class BigintQuantileDigestAggregationFunction {
        private static final QuantileDigestType OUTPUT_TYPE = new QuantileDigestType((Type)BigintType.BIGINT);

        private BigintQuantileDigestAggregationFunction() {
        }

        @InputFunction
        public static void input(@AggregationState QuantileDigestState state, @SqlType(value="BIGINT") long value) {
            BigintQuantileDigestAggregationFunction.input(state, value, 1L, 0.01);
        }

        @InputFunction
        public static void input(@AggregationState QuantileDigestState state, @SqlType(value="BIGINT") long value, @SqlType(value="BIGINT") long weight) {
            BigintQuantileDigestAggregationFunction.input(state, value, weight, 0.01);
        }

        @InputFunction
        public static void input(@AggregationState QuantileDigestState state, @SqlType(value="BIGINT") long value, @SqlType(value="BIGINT") long weight, @SqlType(value="DOUBLE") double accuracy) {
            QuantileDigestAggregationFunction.internalInput(state, value, weight, accuracy);
        }

        @CombineFunction
        public static void combine(@AggregationState QuantileDigestState state, @AggregationState QuantileDigestState otherState) {
            QuantileDigestAggregationFunction.internalCombine(state, otherState);
        }

        @OutputFunction(value="qdigest(BIGINT)")
        public static void output(@AggregationState QuantileDigestState state, BlockBuilder out) {
            QuantileDigestAggregationFunction.internalOutput((Type)OUTPUT_TYPE, state, out);
        }
    }

    @AggregationFunction(value="qdigest_agg", isOrderSensitive=true)
    @Description(value="Returns a qdigest from the set of reals")
    public static final class RealQuantileDigestAggregationFunction {
        private static final QuantileDigestType OUTPUT_TYPE = new QuantileDigestType((Type)RealType.REAL);

        private RealQuantileDigestAggregationFunction() {
        }

        @InputFunction
        public static void input(@AggregationState QuantileDigestState state, @SqlType(value="REAL") long value) {
            RealQuantileDigestAggregationFunction.input(state, value, 1L, 0.01);
        }

        @InputFunction
        public static void input(@AggregationState QuantileDigestState state, @SqlType(value="REAL") long value, @SqlType(value="BIGINT") long weight) {
            RealQuantileDigestAggregationFunction.input(state, value, weight, 0.01);
        }

        @InputFunction
        public static void input(@AggregationState QuantileDigestState state, @SqlType(value="REAL") long value, @SqlType(value="BIGINT") long weight, @SqlType(value="DOUBLE") double accuracy) {
            QuantileDigestAggregationFunction.internalInput(state, FloatingPointBitsConverterUtil.floatToSortableInt(Float.intBitsToFloat((int)value)), weight, accuracy);
        }

        @CombineFunction
        public static void combine(@AggregationState QuantileDigestState state, @AggregationState QuantileDigestState otherState) {
            QuantileDigestAggregationFunction.internalCombine(state, otherState);
        }

        @OutputFunction(value="qdigest(REAL)")
        public static void output(@AggregationState QuantileDigestState state, BlockBuilder out) {
            QuantileDigestAggregationFunction.internalOutput((Type)OUTPUT_TYPE, state, out);
        }
    }

    @AggregationFunction(value="qdigest_agg", isOrderSensitive=true)
    @Description(value="Returns a qdigest from the set of doubles")
    public static final class DoubleQuantileDigestAggregationFunction {
        private static final QuantileDigestType OUTPUT_TYPE = new QuantileDigestType((Type)DoubleType.DOUBLE);

        private DoubleQuantileDigestAggregationFunction() {
        }

        @InputFunction
        public static void input(@AggregationState QuantileDigestState state, @SqlType(value="DOUBLE") double value) {
            DoubleQuantileDigestAggregationFunction.input(state, value, 1L, 0.01);
        }

        @InputFunction
        public static void input(@AggregationState QuantileDigestState state, @SqlType(value="DOUBLE") double value, @SqlType(value="BIGINT") long weight) {
            DoubleQuantileDigestAggregationFunction.input(state, value, weight, 0.01);
        }

        @InputFunction
        public static void input(@AggregationState QuantileDigestState state, @SqlType(value="DOUBLE") double value, @SqlType(value="BIGINT") long weight, @SqlType(value="DOUBLE") double accuracy) {
            QuantileDigestAggregationFunction.internalInput(state, FloatingPointBitsConverterUtil.doubleToSortableLong(value), weight, accuracy);
        }

        @CombineFunction
        public static void combine(@AggregationState QuantileDigestState state, @AggregationState QuantileDigestState otherState) {
            QuantileDigestAggregationFunction.internalCombine(state, otherState);
        }

        @OutputFunction(value="qdigest(DOUBLE)")
        public static void output(@AggregationState QuantileDigestState state, BlockBuilder out) {
            QuantileDigestAggregationFunction.internalOutput((Type)OUTPUT_TYPE, state, out);
        }
    }
}

