/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation;

import com.google.common.base.Preconditions;
import io.trino.operator.aggregation.AbstractMapAggregationState;
import io.trino.spi.block.Block;
import io.trino.spi.block.MapBlockBuilder;
import io.trino.spi.block.SingleMapBlock;
import io.trino.spi.function.AccumulatorState;
import io.trino.spi.type.Type;
import java.lang.invoke.MethodHandle;

public class SingleMapAggregationState
extends AbstractMapAggregationState {
    private SingleMapBlock tempSerializedState;

    public SingleMapAggregationState(Type keyType, MethodHandle keyReadFlat, MethodHandle keyWriteFlat, MethodHandle hashFlat, MethodHandle distinctFlatBlock, MethodHandle keyHashBlock, Type valueType, MethodHandle valueReadFlat, MethodHandle valueWriteFlat) {
        super(keyType, keyReadFlat, keyWriteFlat, hashFlat, distinctFlatBlock, keyHashBlock, valueType, valueReadFlat, valueWriteFlat, false);
    }

    private SingleMapAggregationState(SingleMapAggregationState state) {
        super(state);
        Preconditions.checkArgument((state.tempSerializedState == null ? 1 : 0) != 0, (Object)"state.tempSerializedState is not null");
        this.tempSerializedState = null;
    }

    @Override
    public void add(Block keyBlock, int keyPosition, Block valueBlock, int valuePosition) {
        this.add(0, keyBlock, keyPosition, valueBlock, valuePosition);
    }

    @Override
    public void writeAll(MapBlockBuilder out) {
        this.serialize(0, out);
    }

    public AccumulatorState copy() {
        return new SingleMapAggregationState(this);
    }

    void setTempSerializedState(SingleMapBlock tempSerializedState) {
        this.tempSerializedState = tempSerializedState;
    }

    SingleMapBlock removeTempSerializedState() {
        SingleMapBlock block = this.tempSerializedState;
        Preconditions.checkState((block != null ? 1 : 0) != 0, (Object)"tempDeserializeBlock is null");
        this.tempSerializedState = null;
        return block;
    }
}

