/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation.arrayagg;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import io.airlift.slice.SizeOf;
import io.trino.operator.VariableWidthData;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.Type;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class FlatArrayBuilder {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(FlatArrayBuilder.class);
    private static final int RECORDS_PER_GROUP_SHIFT = 10;
    private static final int RECORDS_PER_GROUP = 1024;
    private static final int RECORDS_PER_GROUP_MASK = 1023;
    private static final VarHandle LONG_HANDLE = MethodHandles.byteArrayViewVarHandle(long[].class, ByteOrder.LITTLE_ENDIAN);
    private final Type type;
    private final MethodHandle readFlat;
    private final MethodHandle writeFlat;
    private final boolean hasNextIndex;
    private final int recordNextIndexOffset;
    private final int recordNullOffset;
    private final int recordValueOffset;
    private final int recordSize;
    private final List<byte[]> closedRecordGroups = new ArrayList<byte[]>();
    private byte[] openRecordGroup;
    private final VariableWidthData variableWidthData;
    private long capacity;
    private long size;

    public FlatArrayBuilder(Type type, MethodHandle readFlat, MethodHandle writeFlat, boolean hasNextIndex) {
        this.type = Objects.requireNonNull(type, "type is null");
        this.readFlat = Objects.requireNonNull(readFlat, "readFlat is null");
        this.writeFlat = Objects.requireNonNull(writeFlat, "writeFlat is null");
        this.hasNextIndex = hasNextIndex;
        boolean variableWidth = type.isFlatVariableWidth();
        VariableWidthData variableWidthData = this.variableWidthData = variableWidth ? new VariableWidthData() : null;
        if (hasNextIndex) {
            this.recordNextIndexOffset = variableWidth ? 12 : 0;
            this.recordNullOffset = this.recordNextIndexOffset + 8;
        } else {
            this.recordNextIndexOffset = Integer.MIN_VALUE;
            this.recordNullOffset = variableWidth ? 12 : 0;
        }
        this.recordValueOffset = this.recordNullOffset + 1;
        this.recordSize = this.recordValueOffset + type.getFlatFixedSize();
    }

    private FlatArrayBuilder(FlatArrayBuilder state) {
        this.type = state.type;
        this.readFlat = state.readFlat;
        this.writeFlat = state.writeFlat;
        this.hasNextIndex = state.hasNextIndex;
        this.recordNextIndexOffset = state.recordNextIndexOffset;
        this.recordNullOffset = state.recordNullOffset;
        this.recordValueOffset = state.recordValueOffset;
        this.recordSize = state.recordSize;
        this.variableWidthData = state.variableWidthData;
        this.capacity = state.capacity;
        this.size = state.size;
        this.closedRecordGroups.addAll(state.closedRecordGroups);
        if (state.openRecordGroup != null) {
            this.openRecordGroup = (byte[])state.openRecordGroup.clone();
        }
    }

    public long getEstimatedSize() {
        return (long)INSTANCE_SIZE + SizeOf.sizeOfObjectArray((int)this.closedRecordGroups.size()) + (long)this.closedRecordGroups.size() * 1024L * (long)this.recordSize + (this.openRecordGroup == null ? 0L : SizeOf.sizeOf((byte[])this.openRecordGroup)) + (this.variableWidthData == null ? 0L : this.variableWidthData.getRetainedSizeBytes());
    }

    public Type type() {
        return this.type;
    }

    public long size() {
        return this.size;
    }

    public void setNextIndex(long tailIndex, long nextIndex) {
        Preconditions.checkArgument((boolean)this.hasNextIndex, (Object)"nextIndex is not supported");
        byte[] records = this.getRecords(tailIndex);
        int recordOffset = this.getRecordOffset(tailIndex);
        LONG_HANDLE.set(records, recordOffset + this.recordNextIndexOffset, nextIndex);
    }

    public void add(Block block, int position) {
        if (this.size == this.capacity) {
            this.growCapacity();
        }
        byte[] records = this.openRecordGroup;
        int recordOffset = this.getRecordOffset(this.size);
        ++this.size;
        if (this.hasNextIndex) {
            LONG_HANDLE.set(records, recordOffset + this.recordNextIndexOffset, -1L);
        }
        if (block.isNull(position)) {
            records[recordOffset + this.recordNullOffset] = 1;
            return;
        }
        byte[] variableWidthChunk = VariableWidthData.EMPTY_CHUNK;
        int variableWidthChunkOffset = 0;
        if (this.variableWidthData != null) {
            int variableWidthLength = this.type.getFlatVariableWidthSize(block, position);
            variableWidthChunk = this.variableWidthData.allocate(records, recordOffset, variableWidthLength);
            variableWidthChunkOffset = VariableWidthData.getChunkOffset(records, recordOffset);
        }
        try {
            this.writeFlat.invokeExact(block, position, records, recordOffset + this.recordValueOffset, variableWidthChunk, variableWidthChunkOffset);
        }
        catch (Throwable throwable) {
            Throwables.throwIfUnchecked((Throwable)throwable);
            throw new RuntimeException(throwable);
        }
    }

    private void growCapacity() {
        if (this.openRecordGroup != null) {
            this.closedRecordGroups.add(this.openRecordGroup);
        }
        this.openRecordGroup = new byte[this.recordSize * 1024];
        this.capacity += 1024L;
    }

    public void writeAll(BlockBuilder blockBuilder) {
        for (byte[] records : this.closedRecordGroups) {
            int recordOffset = 0;
            for (int recordIndex = 0; recordIndex < 1024; ++recordIndex) {
                this.write(records, recordOffset, blockBuilder);
                recordOffset += this.recordSize;
            }
        }
        int recordsInOpenGroup = (int)this.size & 0x3FF;
        int recordOffset = 0;
        for (int recordIndex = 0; recordIndex < recordsInOpenGroup; ++recordIndex) {
            this.write(this.openRecordGroup, recordOffset, blockBuilder);
            recordOffset += this.recordSize;
        }
    }

    public long write(long index, BlockBuilder blockBuilder) {
        Objects.checkIndex(index, this.size);
        byte[] records = this.getRecords(index);
        int recordOffset = this.getRecordOffset(index);
        this.write(records, recordOffset, blockBuilder);
        if (this.hasNextIndex) {
            return LONG_HANDLE.get(records, recordOffset + this.recordNextIndexOffset);
        }
        return -1L;
    }

    private void write(byte[] records, int recordOffset, BlockBuilder blockBuilder) {
        if (records[recordOffset + this.recordNullOffset] != 0) {
            blockBuilder.appendNull();
            return;
        }
        byte[] variableWidthChunk = VariableWidthData.EMPTY_CHUNK;
        if (this.variableWidthData != null) {
            variableWidthChunk = this.variableWidthData.getChunk(records, recordOffset);
        }
        try {
            this.readFlat.invokeExact(records, recordOffset + this.recordValueOffset, variableWidthChunk, blockBuilder);
        }
        catch (Throwable throwable) {
            Throwables.throwIfUnchecked((Throwable)throwable);
            throw new RuntimeException(throwable);
        }
    }

    public FlatArrayBuilder copy() {
        return new FlatArrayBuilder(this);
    }

    private byte[] getRecords(long index) {
        byte[] records;
        int recordGroupIndex = (int)(index >>> 10);
        if (recordGroupIndex < this.closedRecordGroups.size()) {
            records = this.closedRecordGroups.get(recordGroupIndex);
        } else {
            Preconditions.checkState((recordGroupIndex == this.closedRecordGroups.size() ? 1 : 0) != 0);
            records = this.openRecordGroup;
        }
        return records;
    }

    private int getRecordOffset(long index) {
        return ((int)index & 0x3FF) * this.recordSize;
    }
}

