/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation.arrayagg;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import io.airlift.slice.SizeOf;
import io.trino.operator.aggregation.arrayagg.ArrayAggregationState;
import io.trino.operator.aggregation.arrayagg.FlatArrayBuilder;
import io.trino.operator.aggregation.state.AbstractGroupedAccumulatorState;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.Type;
import java.lang.invoke.MethodHandle;
import java.util.Arrays;

public final class GroupArrayAggregationState
extends AbstractGroupedAccumulatorState
implements ArrayAggregationState {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(GroupArrayAggregationState.class);
    private static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;
    private final FlatArrayBuilder arrayBuilder;
    private long[] groupHeadPositions = new long[0];
    private long[] groupTailPositions = new long[0];

    public GroupArrayAggregationState(Type type, MethodHandle readFlat, MethodHandle writeFlat) {
        this.arrayBuilder = new FlatArrayBuilder(type, readFlat, writeFlat, true);
    }

    public long getEstimatedSize() {
        return (long)INSTANCE_SIZE + SizeOf.sizeOf((long[])this.groupHeadPositions) + SizeOf.sizeOf((long[])this.groupTailPositions) + this.arrayBuilder.getEstimatedSize();
    }

    public void ensureCapacity(long maxGroupId) {
        Preconditions.checkArgument((maxGroupId + 1L < 0x7FFFFFF7L ? 1 : 0) != 0, (Object)"Maximum array size exceeded");
        int requiredSize = Math.toIntExact(maxGroupId + 1L);
        if (requiredSize > this.groupHeadPositions.length) {
            int newSize = Ints.constrainToRange((int)(requiredSize * 2), (int)1024, (int)0x7FFFFFF7);
            int oldSize = this.groupHeadPositions.length;
            this.groupHeadPositions = Arrays.copyOf(this.groupHeadPositions, newSize);
            Arrays.fill(this.groupHeadPositions, oldSize, newSize, -1L);
            this.groupTailPositions = Arrays.copyOf(this.groupTailPositions, newSize);
            Arrays.fill(this.groupTailPositions, oldSize, newSize, -1L);
        }
    }

    @Override
    public void addAll(Block block) {
        for (int position = 0; position < block.getPositionCount(); ++position) {
            this.add(block, position);
        }
    }

    @Override
    public void add(Block block, int position) {
        int groupId = (int)this.getGroupId();
        long index = this.arrayBuilder.size();
        if (this.groupTailPositions[groupId] == -1L) {
            this.groupHeadPositions[groupId] = index;
        } else {
            this.arrayBuilder.setNextIndex(this.groupTailPositions[groupId], index);
        }
        this.groupTailPositions[groupId] = index;
        this.arrayBuilder.add(block, position);
    }

    @Override
    public void writeAll(BlockBuilder blockBuilder) {
        long nextIndex = this.getGroupHeadPosition();
        Preconditions.checkArgument((nextIndex != -1L ? 1 : 0) != 0, (Object)"Group is empty");
        while (nextIndex != -1L) {
            nextIndex = this.arrayBuilder.write(nextIndex, blockBuilder);
        }
    }

    private long getGroupHeadPosition() {
        int groupId = (int)this.getGroupId();
        if (groupId >= this.groupHeadPositions.length) {
            return -1L;
        }
        return this.groupHeadPositions[groupId];
    }

    @Override
    public boolean isEmpty() {
        return this.getGroupHeadPosition() == -1L;
    }
}

