/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation.listagg;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.airlift.slice.SizeOf;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;
import io.airlift.slice.Slices;
import io.trino.operator.VariableWidthData;
import io.trino.operator.aggregation.listagg.ListaggAggregationState;
import io.trino.operator.aggregation.listagg.SingleListaggAggregationState;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.ArrayBlockBuilder;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.RowBlockBuilder;
import io.trino.spi.block.SingleRowBlock;
import io.trino.spi.block.VariableWidthBlockBuilder;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public abstract class AbstractListaggAggregationState
implements ListaggAggregationState {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(AbstractListaggAggregationState.class);
    private static final int MAX_OUTPUT_LENGTH = 0x100000;
    private static final int MAX_OVERFLOW_FILLER_LENGTH = 65536;
    private static final int RECORDS_PER_GROUP_SHIFT = 10;
    protected static final int RECORDS_PER_GROUP = 1024;
    protected static final int RECORDS_PER_GROUP_MASK = 1023;
    private boolean initialized;
    private Slice separator;
    private boolean overflowError;
    private Slice overflowFiller;
    private boolean showOverflowEntryCount;
    private int maxOutputLength = 0x100000;
    protected final int recordSize;
    protected final List<byte[]> closedRecordGroups = new ArrayList<byte[]>();
    protected byte[] openRecordGroup;
    private final VariableWidthData variableWidthData;
    private long capacity;
    private long size;

    public AbstractListaggAggregationState(int extraRecordBytes) {
        this.variableWidthData = new VariableWidthData();
        this.recordSize = 12 + extraRecordBytes;
        this.openRecordGroup = new byte[this.recordSize * 1024];
        this.capacity = 1024L;
    }

    public AbstractListaggAggregationState(AbstractListaggAggregationState state) {
        this.initialized = state.initialized;
        this.separator = state.separator;
        this.overflowError = state.overflowError;
        this.overflowFiller = state.overflowFiller;
        this.showOverflowEntryCount = state.showOverflowEntryCount;
        this.maxOutputLength = state.maxOutputLength;
        this.recordSize = state.recordSize;
        this.variableWidthData = state.variableWidthData;
        this.capacity = state.capacity;
        this.size = state.size;
        this.closedRecordGroups.addAll(state.closedRecordGroups);
        if (state.openRecordGroup != null) {
            this.openRecordGroup = (byte[])state.openRecordGroup.clone();
        }
    }

    public long getEstimatedSize() {
        return (long)INSTANCE_SIZE + SizeOf.sizeOfObjectArray((int)this.closedRecordGroups.size()) + (long)this.closedRecordGroups.size() * 1024L * (long)this.recordSize + (this.openRecordGroup == null ? 0L : SizeOf.sizeOf((byte[])this.openRecordGroup)) + (this.variableWidthData == null ? 0L : this.variableWidthData.getRetainedSizeBytes());
    }

    protected final long size() {
        return this.size;
    }

    @Override
    public final void initialize(Slice separator, boolean overflowError, Slice overflowFiller, boolean showOverflowEntryCount) {
        if (this.initialized) {
            return;
        }
        Objects.requireNonNull(separator, "separator is null");
        Objects.requireNonNull(overflowFiller, "overflowFiller is null");
        if (overflowFiller.length() > 65536) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, String.format("Overflow filler length %d exceeds maximum length %d", overflowFiller.length(), 65536));
        }
        this.separator = separator;
        this.overflowError = overflowError;
        this.overflowFiller = overflowFiller;
        this.showOverflowEntryCount = showOverflowEntryCount;
        this.initialized = true;
    }

    @VisibleForTesting
    void setMaxOutputLength(int maxOutputLength) {
        this.maxOutputLength = maxOutputLength;
    }

    @Override
    public void add(Block block, int position) {
        Preconditions.checkArgument((!block.isNull(position) ? 1 : 0) != 0, (Object)"element is null");
        if (this.size == this.capacity) {
            this.closedRecordGroups.add(this.openRecordGroup);
            this.openRecordGroup = new byte[this.recordSize * 1024];
            this.capacity += 1024L;
        }
        byte[] records = this.openRecordGroup;
        int recordOffset = this.getRecordOffset(this.size);
        Slice slice = VarcharType.VARCHAR.getSlice(block, position);
        int variableWidthLength = slice.length();
        byte[] variableWidthChunk = this.variableWidthData.allocate(records, recordOffset, variableWidthLength);
        int variableWidthChunkOffset = VariableWidthData.getChunkOffset(records, recordOffset);
        slice.getBytes(0, variableWidthChunk, variableWidthChunkOffset, variableWidthLength);
        ++this.size;
    }

    @Override
    public void serialize(RowBlockBuilder rowBlockBuilder) {
        if (this.size == 0L) {
            rowBlockBuilder.appendNull();
            return;
        }
        rowBlockBuilder.buildEntry(fieldBuilders -> {
            VarcharType.VARCHAR.writeSlice((BlockBuilder)fieldBuilders.get(0), this.separator);
            BooleanType.BOOLEAN.writeBoolean((BlockBuilder)fieldBuilders.get(1), this.overflowError);
            VarcharType.VARCHAR.writeSlice((BlockBuilder)fieldBuilders.get(2), this.overflowFiller);
            BooleanType.BOOLEAN.writeBoolean((BlockBuilder)fieldBuilders.get(3), this.showOverflowEntryCount);
            ((ArrayBlockBuilder)fieldBuilders.get(4)).buildEntry(elementBuilder -> {
                VariableWidthBlockBuilder valueBuilder = (VariableWidthBlockBuilder)elementBuilder;
                for (byte[] records : this.closedRecordGroups) {
                    int recordOffset = 0;
                    for (int recordIndex = 0; recordIndex < 1024; ++recordIndex) {
                        this.writeValue(records, recordOffset, valueBuilder);
                        recordOffset += this.recordSize;
                    }
                }
                int recordsInOpenGroup = (int)this.size & 0x3FF;
                int recordOffset = 0;
                for (int recordIndex = 0; recordIndex < recordsInOpenGroup; ++recordIndex) {
                    this.writeValue(this.openRecordGroup, recordOffset, valueBuilder);
                    recordOffset += this.recordSize;
                }
            });
        });
    }

    private void writeValue(byte[] records, int recordOffset, VariableWidthBlockBuilder elementBuilder) {
        byte[] variableWidthChunk = this.variableWidthData.getChunk(records, recordOffset);
        int valueOffset = VariableWidthData.getChunkOffset(records, recordOffset);
        int valueLength = VariableWidthData.getValueLength(records, recordOffset);
        elementBuilder.writeEntry(variableWidthChunk, valueOffset, valueLength);
    }

    @Override
    public void merge(ListaggAggregationState other) {
        SingleRowBlock serializedState = ((SingleListaggAggregationState)other).removeTempSerializedState();
        List fields = serializedState.getChildren();
        int index = serializedState.getRowIndex();
        Slice separator = VarcharType.VARCHAR.getSlice((Block)fields.get(0), index);
        boolean overflowError = BooleanType.BOOLEAN.getBoolean((Block)fields.get(1), index);
        Slice overflowFiller = VarcharType.VARCHAR.getSlice((Block)fields.get(2), index);
        boolean showOverflowEntryCount = BooleanType.BOOLEAN.getBoolean((Block)fields.get(3), index);
        this.initialize(separator, overflowError, overflowFiller, showOverflowEntryCount);
        Block values = new ArrayType((Type)VarcharType.VARCHAR).getObject((Block)fields.get(4), index);
        for (int i = 0; i < values.getPositionCount(); ++i) {
            this.add(values, i);
        }
    }

    protected final boolean writeEntry(byte[] records, int recordOffset, SliceOutput out, int totalEntryCount, int emittedCount) {
        byte[] variableWidthChunk = this.variableWidthData.getChunk(records, recordOffset);
        int valueOffset = VariableWidthData.getChunkOffset(records, recordOffset);
        int valueLength = VariableWidthData.getValueLength(records, recordOffset);
        int spaceRequired = valueLength + (emittedCount > 0 ? this.separator.length() : 0);
        if (out.size() + spaceRequired > this.maxOutputLength) {
            this.writeOverflow(out, totalEntryCount, emittedCount);
            return false;
        }
        if (emittedCount > 0) {
            out.writeBytes(this.separator);
        }
        out.writeBytes(variableWidthChunk, valueOffset, valueLength);
        return true;
    }

    private void writeOverflow(SliceOutput out, int entryCount, int emittedCount) {
        if (this.overflowError) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.EXCEEDED_FUNCTION_MEMORY_LIMIT, String.format("Concatenated string has the length in bytes larger than the maximum output length %d", this.maxOutputLength));
        }
        if (emittedCount > 0) {
            out.writeBytes(this.separator);
        }
        out.writeBytes(this.overflowFiller);
        if (this.showOverflowEntryCount) {
            out.writeBytes(Slices.utf8Slice((String)"("), 0, 1);
            Slice count = Slices.utf8Slice((String)Integer.toString(entryCount - emittedCount));
            out.writeBytes(count, 0, count.length());
            out.writeBytes(Slices.utf8Slice((String)")"), 0, 1);
        }
    }

    protected final byte[] getRecords(long index) {
        byte[] records;
        int recordGroupIndex = (int)(index >>> 10);
        if (recordGroupIndex < this.closedRecordGroups.size()) {
            records = this.closedRecordGroups.get(recordGroupIndex);
        } else {
            Preconditions.checkState((recordGroupIndex == this.closedRecordGroups.size() ? 1 : 0) != 0);
            records = this.openRecordGroup;
        }
        return records;
    }

    protected final int getRecordOffset(long index) {
        return ((int)index & 0x3FF) * this.recordSize;
    }
}

