/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation.listagg;

import com.google.common.base.Preconditions;
import io.airlift.slice.SliceOutput;
import io.trino.operator.aggregation.listagg.AbstractListaggAggregationState;
import io.trino.spi.block.SingleRowBlock;
import io.trino.spi.block.VariableWidthBlockBuilder;
import io.trino.spi.function.AccumulatorState;

public class SingleListaggAggregationState
extends AbstractListaggAggregationState {
    private SingleRowBlock tempSerializedState;

    public SingleListaggAggregationState() {
        super(0);
    }

    private SingleListaggAggregationState(SingleListaggAggregationState state) {
        super(state);
        Preconditions.checkArgument((state.tempSerializedState == null ? 1 : 0) != 0, (Object)"state.tempSerializedState is not null");
        this.tempSerializedState = null;
    }

    @Override
    public void write(VariableWidthBlockBuilder blockBuilder) {
        if (this.size() == 0L) {
            blockBuilder.appendNull();
            return;
        }
        blockBuilder.buildEntry(this::writeNotGrouped);
    }

    private void writeNotGrouped(SliceOutput out) {
        int entryCount = Math.toIntExact(this.size());
        int emittedCount = 0;
        for (byte[] records : this.closedRecordGroups) {
            int recordOffset = 0;
            for (int recordIndex = 0; recordIndex < 1024; ++recordIndex) {
                if (!this.writeEntry(records, recordOffset, out, entryCount, emittedCount)) {
                    return;
                }
                ++emittedCount;
                recordOffset += this.recordSize;
            }
        }
        int recordsInOpenGroup = entryCount & 0x3FF;
        int recordOffset = 0;
        for (int recordIndex = 0; recordIndex < recordsInOpenGroup; ++recordIndex) {
            if (!this.writeEntry(this.openRecordGroup, recordOffset, out, entryCount, emittedCount)) {
                return;
            }
            ++emittedCount;
            recordOffset += this.recordSize;
        }
    }

    public AccumulatorState copy() {
        return new SingleListaggAggregationState(this);
    }

    void setTempSerializedState(SingleRowBlock tempSerializedState) {
        this.tempSerializedState = tempSerializedState;
    }

    SingleRowBlock removeTempSerializedState() {
        SingleRowBlock block = this.tempSerializedState;
        Preconditions.checkState((block != null ? 1 : 0) != 0, (Object)"tempDeserializeBlock is null");
        this.tempSerializedState = null;
        return block;
    }
}

