/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation.multimapagg;

import io.trino.operator.aggregation.multimapagg.AbstractMultimapAggregationState;
import io.trino.operator.aggregation.multimapagg.MultimapAggregationState;
import io.trino.operator.aggregation.multimapagg.SingleMultimapAggregationState;
import io.trino.spi.block.Block;
import io.trino.spi.block.MapBlockBuilder;
import io.trino.spi.block.SingleMapBlock;
import io.trino.spi.function.GroupedAccumulatorState;
import io.trino.spi.type.Type;
import java.lang.invoke.MethodHandle;

public final class GroupedMultimapAggregationState
extends AbstractMultimapAggregationState
implements GroupedAccumulatorState {
    private int groupId;

    public GroupedMultimapAggregationState(Type keyType, MethodHandle keyReadFlat, MethodHandle keyWriteFlat, MethodHandle hashFlat, MethodHandle distinctFlatBlock, MethodHandle keyHashBlock, Type valueType, MethodHandle valueReadFlat, MethodHandle valueWriteFlat) {
        super(keyType, keyReadFlat, keyWriteFlat, hashFlat, distinctFlatBlock, keyHashBlock, valueType, valueReadFlat, valueWriteFlat, true);
    }

    public void setGroupId(long groupId) {
        this.groupId = Math.toIntExact(groupId);
    }

    public void ensureCapacity(long size) {
        this.setMaxGroupId(Math.toIntExact(size));
    }

    @Override
    public void add(Block keyBlock, int keyPosition, Block valueBlock, int valuePosition) {
        this.add(this.groupId, keyBlock, keyPosition, valueBlock, valuePosition);
    }

    @Override
    public void merge(MultimapAggregationState other) {
        SingleMapBlock serializedState = ((SingleMultimapAggregationState)other).removeTempSerializedState();
        this.deserialize(this.groupId, serializedState);
    }

    @Override
    public void writeAll(MapBlockBuilder out) {
        this.serialize(this.groupId, out);
    }
}

