/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.join;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.optimizations.PlanNodeSearcher;
import io.trino.sql.planner.plan.DynamicFilterId;
import io.trino.sql.planner.plan.DynamicFilterSourceNode;
import io.trino.sql.planner.plan.ExchangeNode;
import io.trino.sql.planner.plan.JoinNode;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.ProjectNode;
import io.trino.sql.planner.plan.RemoteSourceNode;
import io.trino.sql.planner.plan.SemiJoinNode;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;

public final class JoinUtils {
    private JoinUtils() {
    }

    public static List<Page> channelsToPages(List<ObjectArrayList<Block>> channels) {
        if (channels.isEmpty()) {
            return ImmutableList.of();
        }
        int pagesCount = channels.get(0).size();
        ImmutableList.Builder pagesBuilder = ImmutableList.builderWithExpectedSize((int)pagesCount);
        for (int pageIndex = 0; pageIndex < pagesCount; ++pageIndex) {
            Block[] blocks = new Block[channels.size()];
            for (int channelIndex = 0; channelIndex < blocks.length; ++channelIndex) {
                blocks[channelIndex] = (Block)channels.get(channelIndex).get(pageIndex);
            }
            pagesBuilder.add((Object)new Page(blocks));
        }
        return pagesBuilder.build();
    }

    public static OptionalInt getSingleBigintJoinChannel(List<Integer> joinChannels, List<Type> types) {
        if (joinChannels.size() == 1 && types.get((Integer)Iterables.getOnlyElement(joinChannels)) == BigintType.BIGINT) {
            return OptionalInt.of((Integer)Iterables.getOnlyElement(joinChannels));
        }
        return OptionalInt.empty();
    }

    public static boolean isBuildSideReplicated(PlanNode node) {
        Preconditions.checkArgument((node instanceof JoinNode || node instanceof SemiJoinNode ? 1 : 0) != 0);
        if (node instanceof JoinNode) {
            return PlanNodeSearcher.searchFrom(((JoinNode)node).getRight()).recurseOnlyWhen(planNode -> planNode instanceof ProjectNode || JoinUtils.isLocalRepartitionExchange(planNode) || JoinUtils.isLocalGatherExchange(planNode)).where(planNode -> JoinUtils.isRemoteReplicatedExchange(planNode) || JoinUtils.isRemoteReplicatedSourceNode(planNode)).matches();
        }
        return PlanNodeSearcher.searchFrom(((SemiJoinNode)node).getFilteringSource()).recurseOnlyWhen(planNode -> planNode instanceof ProjectNode || JoinUtils.isLocalGatherExchange(planNode)).where(joinNode -> JoinUtils.isRemoteReplicatedExchange(joinNode) || JoinUtils.isRemoteReplicatedSourceNode(joinNode)).matches();
    }

    public static Map<DynamicFilterId, Symbol> getJoinDynamicFilters(JoinNode joinNode) {
        List dynamicFilterSourceNodes = PlanNodeSearcher.searchFrom(joinNode.getRight()).where(DynamicFilterSourceNode.class::isInstance).recurseOnlyWhen(node -> node instanceof ExchangeNode || node instanceof ProjectNode).findAll();
        Map<DynamicFilterId, Symbol> dynamicFilters = joinNode.getDynamicFilters();
        if (dynamicFilterSourceNodes.isEmpty()) {
            return dynamicFilters;
        }
        Verify.verify((boolean)dynamicFilters.isEmpty(), (String)"Dynamic filters %s present in a join with a DynamicFilterSourceNode on it's build side", dynamicFilters);
        Verify.verify((dynamicFilterSourceNodes.size() == 1 ? 1 : 0) != 0, (String)"Expected only 1 dynamic filter source node", (Object[])new Object[0]);
        return ((DynamicFilterSourceNode)dynamicFilterSourceNodes.get(0)).getDynamicFilters();
    }

    public static Optional<DynamicFilterId> getSemiJoinDynamicFilterId(SemiJoinNode semiJoinNode) {
        List dynamicFilterSourceNodes = PlanNodeSearcher.searchFrom(semiJoinNode.getFilteringSource()).where(DynamicFilterSourceNode.class::isInstance).recurseOnlyWhen(node -> node instanceof ExchangeNode || node instanceof ProjectNode).findAll();
        Optional<DynamicFilterId> dynamicFilterId = semiJoinNode.getDynamicFilterId();
        if (dynamicFilterSourceNodes.isEmpty()) {
            return dynamicFilterId;
        }
        Verify.verify((boolean)dynamicFilterId.isEmpty(), (String)"Dynamic filter %s present in a semi join with a DynamicFilterSourceNode on it's filtering source side", dynamicFilterId);
        Verify.verify((dynamicFilterSourceNodes.size() == 1 ? 1 : 0) != 0, (String)"Expected only 1 dynamic filter source node", (Object[])new Object[0]);
        return Optional.of((DynamicFilterId)Iterables.getOnlyElement(((DynamicFilterSourceNode)dynamicFilterSourceNodes.get(0)).getDynamicFilters().keySet()));
    }

    private static boolean isRemoteReplicatedExchange(PlanNode node) {
        if (!(node instanceof ExchangeNode)) {
            return false;
        }
        ExchangeNode exchangeNode = (ExchangeNode)node;
        return exchangeNode.getScope() == ExchangeNode.Scope.REMOTE && exchangeNode.getType() == ExchangeNode.Type.REPLICATE;
    }

    private static boolean isRemoteReplicatedSourceNode(PlanNode node) {
        if (!(node instanceof RemoteSourceNode)) {
            return false;
        }
        RemoteSourceNode remoteSourceNode = (RemoteSourceNode)node;
        return remoteSourceNode.getExchangeType() == ExchangeNode.Type.REPLICATE;
    }

    private static boolean isLocalRepartitionExchange(PlanNode node) {
        if (!(node instanceof ExchangeNode)) {
            return false;
        }
        ExchangeNode exchangeNode = (ExchangeNode)node;
        return exchangeNode.getScope() == ExchangeNode.Scope.LOCAL && exchangeNode.getType() == ExchangeNode.Type.REPARTITION;
    }

    private static boolean isLocalGatherExchange(PlanNode node) {
        if (!(node instanceof ExchangeNode)) {
            return false;
        }
        ExchangeNode exchangeNode = (ExchangeNode)node;
        return exchangeNode.getScope() == ExchangeNode.Scope.LOCAL && exchangeNode.getType() == ExchangeNode.Type.GATHER;
    }
}

