/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import io.airlift.slice.Slice;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.block.BufferedMapValueBuilder;
import io.trino.spi.function.Description;
import io.trino.spi.function.ScalarFunction;
import io.trino.spi.function.SqlType;
import io.trino.spi.function.TypeParameter;
import io.trino.spi.type.MapType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.util.Failures;
import java.util.HashMap;

@Description(value="Creates a map using entryDelimiter and keyValueDelimiter")
@ScalarFunction(value="split_to_map")
public class SplitToMapFunction {
    private final BufferedMapValueBuilder mapValueBuilder;

    public SplitToMapFunction(@TypeParameter(value="map(varchar,varchar)") Type mapType) {
        this.mapValueBuilder = BufferedMapValueBuilder.createBuffered((MapType)((MapType)mapType));
    }

    @SqlType(value="map(varchar,varchar)")
    public Block splitToMap(@TypeParameter(value="map(varchar,varchar)") Type mapType, @SqlType(value="varchar") Slice string, @SqlType(value="varchar") Slice entryDelimiter, @SqlType(value="varchar") Slice keyValueDelimiter) {
        Failures.checkCondition(entryDelimiter.length() > 0, (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "entryDelimiter is empty", new Object[0]);
        Failures.checkCondition(keyValueDelimiter.length() > 0, (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "keyValueDelimiter is empty", new Object[0]);
        Failures.checkCondition(!entryDelimiter.equals((Object)keyValueDelimiter), (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "entryDelimiter and keyValueDelimiter must not be the same", new Object[0]);
        HashMap<Slice, Slice> map = new HashMap<Slice, Slice>();
        int entryStart = 0;
        while (entryStart < string.length()) {
            Slice value;
            Slice key;
            int entryEnd = string.indexOf(entryDelimiter, entryStart);
            Slice keyValuePair = entryEnd >= 0 ? string.slice(entryStart, entryEnd - entryStart) : string.slice(entryStart, string.length() - entryStart);
            int keyEnd = keyValuePair.indexOf(keyValueDelimiter);
            if (keyEnd >= 0) {
                int valueStart = keyEnd + keyValueDelimiter.length();
                key = keyValuePair.slice(0, keyEnd);
                value = keyValuePair.slice(valueStart, keyValuePair.length() - valueStart);
                if (value.indexOf(keyValueDelimiter) >= 0) {
                    throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Key-value delimiter must appear exactly once in each entry. Bad input: '" + keyValuePair.toStringUtf8() + "'");
                }
                if (map.containsKey(key)) {
                    throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, String.format("Duplicate keys (%s) are not allowed", key.toStringUtf8()));
                }
            } else {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Key-value delimiter must appear exactly once in each entry. Bad input: '" + keyValuePair.toStringUtf8() + "'");
            }
            map.put(key, value);
            if (entryEnd < 0) break;
            entryStart = entryEnd + entryDelimiter.length();
        }
        return this.mapValueBuilder.build(map.size(), (keyBuilder, valueBuilder) -> map.forEach((key, value) -> {
            VarcharType.VARCHAR.writeSlice(keyBuilder, key);
            VarcharType.VARCHAR.writeSlice(valueBuilder, value);
        }));
    }
}

