/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.airlift.slice.Slice;
import io.trino.annotation.UsedByGeneratedCode;
import io.trino.json.JsonInputErrorNode;
import io.trino.json.JsonPathEvaluator;
import io.trino.json.JsonPathInvocationContext;
import io.trino.json.PathEvaluationError;
import io.trino.json.ir.IrJsonPath;
import io.trino.json.ir.SqlJsonLiteralConverter;
import io.trino.json.ir.TypedValue;
import io.trino.metadata.FunctionManager;
import io.trino.metadata.Metadata;
import io.trino.metadata.OperatorNotFoundException;
import io.trino.metadata.ResolvedFunction;
import io.trino.metadata.SqlScalarFunction;
import io.trino.operator.scalar.ChoicesSpecializedSqlScalarFunction;
import io.trino.operator.scalar.SpecializedSqlScalarFunction;
import io.trino.operator.scalar.json.JsonInputConversionError;
import io.trino.operator.scalar.json.ParameterUtil;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.function.BoundSignature;
import io.trino.spi.function.FunctionMetadata;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.function.Signature;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;
import io.trino.sql.InterpretedFunctionInvoker;
import io.trino.sql.tree.JsonValue;
import io.trino.util.Reflection;
import java.lang.invoke.MethodHandle;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;

public class JsonValueFunction
extends SqlScalarFunction {
    public static final String JSON_VALUE_FUNCTION_NAME = "$json_value";
    private static final MethodHandle METHOD_HANDLE_LONG = Reflection.methodHandle(JsonValueFunction.class, "jsonValueLong", FunctionManager.class, Metadata.class, TypeManager.class, Type.class, Type.class, JsonPathInvocationContext.class, ConnectorSession.class, JsonNode.class, IrJsonPath.class, Block.class, Long.TYPE, Long.class, Long.TYPE, Long.class);
    private static final MethodHandle METHOD_HANDLE_DOUBLE = Reflection.methodHandle(JsonValueFunction.class, "jsonValueDouble", FunctionManager.class, Metadata.class, TypeManager.class, Type.class, Type.class, JsonPathInvocationContext.class, ConnectorSession.class, JsonNode.class, IrJsonPath.class, Block.class, Long.TYPE, Double.class, Long.TYPE, Double.class);
    private static final MethodHandle METHOD_HANDLE_BOOLEAN = Reflection.methodHandle(JsonValueFunction.class, "jsonValueBoolean", FunctionManager.class, Metadata.class, TypeManager.class, Type.class, Type.class, JsonPathInvocationContext.class, ConnectorSession.class, JsonNode.class, IrJsonPath.class, Block.class, Long.TYPE, Boolean.class, Long.TYPE, Boolean.class);
    private static final MethodHandle METHOD_HANDLE_SLICE = Reflection.methodHandle(JsonValueFunction.class, "jsonValueSlice", FunctionManager.class, Metadata.class, TypeManager.class, Type.class, Type.class, JsonPathInvocationContext.class, ConnectorSession.class, JsonNode.class, IrJsonPath.class, Block.class, Long.TYPE, Slice.class, Long.TYPE, Slice.class);
    private static final MethodHandle METHOD_HANDLE = Reflection.methodHandle(JsonValueFunction.class, "jsonValue", FunctionManager.class, Metadata.class, TypeManager.class, Type.class, Type.class, JsonPathInvocationContext.class, ConnectorSession.class, JsonNode.class, IrJsonPath.class, Block.class, Long.TYPE, Object.class, Long.TYPE, Object.class);
    private final FunctionManager functionManager;
    private final Metadata metadata;
    private final TypeManager typeManager;

    public JsonValueFunction(FunctionManager functionManager, Metadata metadata, TypeManager typeManager) {
        super(FunctionMetadata.scalarBuilder().signature(Signature.builder().name(JSON_VALUE_FUNCTION_NAME).typeVariable("R").typeVariable("T").returnType(new TypeSignature("R", new TypeSignatureParameter[0])).argumentTypes((List)ImmutableList.of((Object)new TypeSignature("json2016", new TypeSignatureParameter[0]), (Object)new TypeSignature("JsonPath2016", new TypeSignatureParameter[0]), (Object)new TypeSignature("T", new TypeSignatureParameter[0]), (Object)new TypeSignature("tinyint", new TypeSignatureParameter[0]), (Object)new TypeSignature("R", new TypeSignatureParameter[0]), (Object)new TypeSignature("tinyint", new TypeSignatureParameter[0]), (Object)new TypeSignature("R", new TypeSignatureParameter[0]))).build()).nullable().argumentNullability(new boolean[]{false, false, true, false, true, false, true}).hidden().description("Extracts an SQL scalar from a JSON value").build());
        this.functionManager = Objects.requireNonNull(functionManager, "functionManager is null");
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
    }

    @Override
    protected SpecializedSqlScalarFunction specialize(BoundSignature boundSignature) {
        Type parametersRowType = boundSignature.getArgumentType(2);
        Type returnType = boundSignature.getReturnType();
        MethodHandle handle = returnType.getJavaType().equals(Long.TYPE) ? METHOD_HANDLE_LONG : (returnType.getJavaType().equals(Double.TYPE) ? METHOD_HANDLE_DOUBLE : (returnType.getJavaType().equals(Boolean.TYPE) ? METHOD_HANDLE_BOOLEAN : (returnType.getJavaType().equals(Slice.class) ? METHOD_HANDLE_SLICE : METHOD_HANDLE)));
        MethodHandle methodHandle = handle.bindTo(this.functionManager).bindTo(this.metadata).bindTo(this.typeManager).bindTo(parametersRowType).bindTo(returnType);
        MethodHandle instanceFactory = Reflection.constructorMethodHandle(JsonPathInvocationContext.class, new Class[0]);
        return new ChoicesSpecializedSqlScalarFunction(boundSignature, InvocationConvention.InvocationReturnConvention.NULLABLE_RETURN, (List<InvocationConvention.InvocationArgumentConvention>)ImmutableList.of((Object)InvocationConvention.InvocationArgumentConvention.BOXED_NULLABLE, (Object)InvocationConvention.InvocationArgumentConvention.BOXED_NULLABLE, (Object)InvocationConvention.InvocationArgumentConvention.BOXED_NULLABLE, (Object)InvocationConvention.InvocationArgumentConvention.NEVER_NULL, (Object)InvocationConvention.InvocationArgumentConvention.BOXED_NULLABLE, (Object)InvocationConvention.InvocationArgumentConvention.NEVER_NULL, (Object)InvocationConvention.InvocationArgumentConvention.BOXED_NULLABLE), methodHandle, Optional.of(instanceFactory));
    }

    @UsedByGeneratedCode
    public static Long jsonValueLong(FunctionManager functionManager, Metadata metadata, TypeManager typeManager, Type parametersRowType, Type returnType, JsonPathInvocationContext invocationContext, ConnectorSession session, JsonNode inputExpression, IrJsonPath jsonPath, Block parametersRow, long emptyBehavior, Long emptyDefault, long errorBehavior, Long errorDefault) {
        return (Long)JsonValueFunction.jsonValue(functionManager, metadata, typeManager, parametersRowType, returnType, invocationContext, session, inputExpression, jsonPath, parametersRow, emptyBehavior, emptyDefault, errorBehavior, errorDefault);
    }

    @UsedByGeneratedCode
    public static Double jsonValueDouble(FunctionManager functionManager, Metadata metadata, TypeManager typeManager, Type parametersRowType, Type returnType, JsonPathInvocationContext invocationContext, ConnectorSession session, JsonNode inputExpression, IrJsonPath jsonPath, Block parametersRow, long emptyBehavior, Double emptyDefault, long errorBehavior, Double errorDefault) {
        return (Double)JsonValueFunction.jsonValue(functionManager, metadata, typeManager, parametersRowType, returnType, invocationContext, session, inputExpression, jsonPath, parametersRow, emptyBehavior, emptyDefault, errorBehavior, errorDefault);
    }

    @UsedByGeneratedCode
    public static Boolean jsonValueBoolean(FunctionManager functionManager, Metadata metadata, TypeManager typeManager, Type parametersRowType, Type returnType, JsonPathInvocationContext invocationContext, ConnectorSession session, JsonNode inputExpression, IrJsonPath jsonPath, Block parametersRow, long emptyBehavior, Boolean emptyDefault, long errorBehavior, Boolean errorDefault) {
        return (Boolean)JsonValueFunction.jsonValue(functionManager, metadata, typeManager, parametersRowType, returnType, invocationContext, session, inputExpression, jsonPath, parametersRow, emptyBehavior, emptyDefault, errorBehavior, errorDefault);
    }

    @UsedByGeneratedCode
    public static Slice jsonValueSlice(FunctionManager functionManager, Metadata metadata, TypeManager typeManager, Type parametersRowType, Type returnType, JsonPathInvocationContext invocationContext, ConnectorSession session, JsonNode inputExpression, IrJsonPath jsonPath, Block parametersRow, long emptyBehavior, Slice emptyDefault, long errorBehavior, Slice errorDefault) {
        return (Slice)JsonValueFunction.jsonValue(functionManager, metadata, typeManager, parametersRowType, returnType, invocationContext, session, inputExpression, jsonPath, parametersRow, emptyBehavior, emptyDefault, errorBehavior, errorDefault);
    }

    @UsedByGeneratedCode
    public static Object jsonValue(FunctionManager functionManager, Metadata metadata, TypeManager typeManager, Type parametersRowType, Type returnType, JsonPathInvocationContext invocationContext, ConnectorSession session, JsonNode inputExpression, IrJsonPath jsonPath, Block parametersRow, long emptyBehavior, Object emptyDefault, long errorBehavior, Object errorDefault) {
        ResolvedFunction coercion;
        TypedValue typedValue;
        List<Object> pathResult;
        Object[] parameters;
        if (inputExpression.equals((Object)JsonInputErrorNode.JSON_ERROR)) {
            return JsonValueFunction.handleSpecialCase(errorBehavior, errorDefault, () -> new JsonInputConversionError("malformed input argument to JSON_VALUE function"));
        }
        for (Object parameter : parameters = ParameterUtil.getParametersArray(parametersRowType, parametersRow)) {
            if (!parameter.equals((Object)JsonInputErrorNode.JSON_ERROR)) continue;
            return JsonValueFunction.handleSpecialCase(errorBehavior, errorDefault, () -> new JsonInputConversionError("malformed JSON path parameter to JSON_VALUE function"));
        }
        JsonPathEvaluator evaluator = invocationContext.getEvaluator();
        if (evaluator == null) {
            evaluator = new JsonPathEvaluator(jsonPath, session, metadata, typeManager, functionManager);
            invocationContext.setEvaluator(evaluator);
        }
        try {
            pathResult = evaluator.evaluate(inputExpression, parameters);
        }
        catch (PathEvaluationError e) {
            return JsonValueFunction.handleSpecialCase(errorBehavior, errorDefault, () -> e);
        }
        if (pathResult.isEmpty()) {
            return JsonValueFunction.handleSpecialCase(emptyBehavior, emptyDefault, () -> new JsonValueResultError("JSON path found no items"));
        }
        if (pathResult.size() > 1) {
            return JsonValueFunction.handleSpecialCase(errorBehavior, errorDefault, () -> new JsonValueResultError("JSON path found multiple items"));
        }
        Object item = Iterables.getOnlyElement(pathResult);
        if (item instanceof JsonNode) {
            Optional<TypedValue> itemValue;
            if (item.equals(NullNode.instance)) {
                return null;
            }
            try {
                itemValue = SqlJsonLiteralConverter.getTypedValue((JsonNode)item);
            }
            catch (SqlJsonLiteralConverter.JsonLiteralConversionError e) {
                return JsonValueFunction.handleSpecialCase(errorBehavior, errorDefault, () -> new JsonValueResultError("JSON path found an item that cannot be converted to an SQL value", (Throwable)((Object)e)));
            }
            if (itemValue.isEmpty()) {
                return JsonValueFunction.handleSpecialCase(errorBehavior, errorDefault, () -> new JsonValueResultError("JSON path found an item that cannot be converted to an SQL value"));
            }
            typedValue = itemValue.get();
        } else {
            typedValue = (TypedValue)item;
        }
        if (returnType.equals(typedValue.getType())) {
            return typedValue.getValueAsObject();
        }
        try {
            coercion = metadata.getCoercion(typedValue.getType(), returnType);
        }
        catch (OperatorNotFoundException e) {
            return JsonValueFunction.handleSpecialCase(errorBehavior, errorDefault, () -> new JsonValueResultError(String.format("Cannot cast value of type %s to declared return type of function JSON_VALUE: %s", typedValue.getType(), returnType)));
        }
        try {
            return new InterpretedFunctionInvoker(functionManager).invoke(coercion, session, (List<Object>)ImmutableList.of((Object)typedValue.getValueAsObject()));
        }
        catch (RuntimeException e) {
            return JsonValueFunction.handleSpecialCase(errorBehavior, errorDefault, () -> new JsonValueResultError(String.format("Cannot cast value of type %s to declared return type of function JSON_VALUE: %s", typedValue.getType(), returnType)));
        }
    }

    private static Object handleSpecialCase(long behavior, Object defaultValue, Supplier<TrinoException> error) {
        switch (JsonValue.EmptyOrErrorBehavior.values()[(int)behavior]) {
            case NULL: {
                return null;
            }
            case ERROR: {
                throw error.get();
            }
            case DEFAULT: {
                return defaultValue;
            }
        }
        throw new IllegalStateException("unexpected behavior");
    }

    public static class JsonValueResultError
    extends TrinoException {
        public JsonValueResultError(String message) {
            super((ErrorCodeSupplier)StandardErrorCode.JSON_VALUE_RESULT_ERROR, "cannot extract SQL scalar from JSON: " + message);
        }

        public JsonValueResultError(String message, Throwable cause) {
            super((ErrorCodeSupplier)StandardErrorCode.JSON_VALUE_RESULT_ERROR, "cannot extract SQL scalar from JSON: " + message, cause);
        }
    }
}

