/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import io.opentelemetry.api.trace.Span;
import io.trino.SessionRepresentation;
import io.trino.execution.SplitAssignment;
import io.trino.execution.buffer.OutputBuffers;
import io.trino.spi.predicate.Domain;
import io.trino.sql.planner.PlanFragment;
import io.trino.sql.planner.plan.DynamicFilterId;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class TaskUpdateRequest {
    private final SessionRepresentation session;
    private final Map<String, String> extraCredentials;
    private final Span stageSpan;
    private final Optional<PlanFragment> fragment;
    private final List<SplitAssignment> splitAssignments;
    private final OutputBuffers outputIds;
    private final Map<DynamicFilterId, Domain> dynamicFilterDomains;
    private final Optional<Slice> exchangeEncryptionKey;
    private final boolean speculative;

    @JsonCreator
    public TaskUpdateRequest(@JsonProperty(value="session") SessionRepresentation session, @JsonProperty(value="extraCredentials") Map<String, String> extraCredentials, @JsonProperty(value="stageSpan") Span stageSpan, @JsonProperty(value="fragment") Optional<PlanFragment> fragment, @JsonProperty(value="splitAssignments") List<SplitAssignment> splitAssignments, @JsonProperty(value="outputIds") OutputBuffers outputIds, @JsonProperty(value="dynamicFilterDomains") Map<DynamicFilterId, Domain> dynamicFilterDomains, @JsonProperty(value="exchangeEncryptionKey") Optional<Slice> exchangeEncryptionKey, @JsonProperty(value="speculative") boolean speculative) {
        Objects.requireNonNull(session, "session is null");
        Objects.requireNonNull(extraCredentials, "extraCredentials is null");
        Objects.requireNonNull(stageSpan, "stageSpan is null");
        Objects.requireNonNull(fragment, "fragment is null");
        Objects.requireNonNull(splitAssignments, "splitAssignments is null");
        Objects.requireNonNull(outputIds, "outputIds is null");
        Objects.requireNonNull(dynamicFilterDomains, "dynamicFilterDomains is null");
        Objects.requireNonNull(exchangeEncryptionKey, "exchangeEncryptionKey is null");
        this.session = session;
        this.extraCredentials = extraCredentials;
        this.stageSpan = stageSpan;
        this.fragment = fragment;
        this.splitAssignments = ImmutableList.copyOf(splitAssignments);
        this.outputIds = outputIds;
        this.dynamicFilterDomains = dynamicFilterDomains;
        this.exchangeEncryptionKey = exchangeEncryptionKey;
        this.speculative = speculative;
    }

    @JsonProperty
    public SessionRepresentation getSession() {
        return this.session;
    }

    @JsonProperty
    public Map<String, String> getExtraCredentials() {
        return this.extraCredentials;
    }

    @JsonProperty
    public Span getStageSpan() {
        return this.stageSpan;
    }

    @JsonProperty
    public Optional<PlanFragment> getFragment() {
        return this.fragment;
    }

    @JsonProperty
    public List<SplitAssignment> getSplitAssignments() {
        return this.splitAssignments;
    }

    @JsonProperty
    public OutputBuffers getOutputIds() {
        return this.outputIds;
    }

    @JsonProperty
    public Map<DynamicFilterId, Domain> getDynamicFilterDomains() {
        return this.dynamicFilterDomains;
    }

    @JsonProperty
    public Optional<Slice> getExchangeEncryptionKey() {
        return this.exchangeEncryptionKey;
    }

    @JsonProperty
    public boolean isSpeculative() {
        return this.speculative;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("session", (Object)this.session).add("extraCredentials", this.extraCredentials.keySet()).add("fragment", this.fragment).add("splitAssignments", this.splitAssignments).add("outputIds", (Object)this.outputIds).add("dynamicFilterDomains", this.dynamicFilterDomains).add("exchangeEncryptionKey", this.exchangeEncryptionKey.map(key -> "[REDACTED]")).toString();
    }
}

