/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import io.trino.matching.Captures;
import io.trino.matching.Pattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.optimizations.QueryCardinalityUtil;
import io.trino.sql.planner.plan.Patterns;
import io.trino.sql.planner.plan.TableFunctionProcessorNode;
import io.trino.sql.planner.plan.ValuesNode;
import io.trino.sql.tree.Expression;
import java.util.List;

public class RemoveRedundantTableFunction
implements Rule<TableFunctionProcessorNode> {
    private static final Pattern<TableFunctionProcessorNode> PATTERN = Patterns.tableFunctionProcessor();

    @Override
    public Pattern<TableFunctionProcessorNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(TableFunctionProcessorNode node, Captures captures, Rule.Context context) {
        if (node.isPruneWhenEmpty() && node.getSource().isPresent() && QueryCardinalityUtil.isEmpty(node.getSource().orElseThrow(), context.getLookup())) {
            return Rule.Result.ofPlanNode(new ValuesNode(node.getId(), node.getOutputSymbols(), (List<Expression>)ImmutableList.of()));
        }
        return Rule.Result.empty();
    }
}

