/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.optimizations;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import io.trino.Session;
import io.trino.cost.TableStatsProvider;
import io.trino.execution.querystats.PlanOptimizersStatsCollector;
import io.trino.execution.warnings.WarningCollector;
import io.trino.metadata.Metadata;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.Type;
import io.trino.sql.ExpressionUtils;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.sql.analyzer.TypeSignatureTranslator;
import io.trino.sql.planner.PlanNodeIdAllocator;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.SymbolAllocator;
import io.trino.sql.planner.TypeProvider;
import io.trino.sql.planner.optimizations.PlanOptimizer;
import io.trino.sql.planner.plan.AggregationNode;
import io.trino.sql.planner.plan.ApplyNode;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.CorrelatedJoinNode;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.ProjectNode;
import io.trino.sql.planner.plan.SimplePlanRewriter;
import io.trino.sql.tree.BooleanLiteral;
import io.trino.sql.tree.Cast;
import io.trino.sql.tree.ComparisonExpression;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.GenericLiteral;
import io.trino.sql.tree.NullLiteral;
import io.trino.sql.tree.QuantifiedComparisonExpression;
import io.trino.sql.tree.SearchedCaseExpression;
import io.trino.sql.tree.SimpleCaseExpression;
import io.trino.sql.tree.WhenClause;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;

public class TransformQuantifiedComparisonApplyToCorrelatedJoin
implements PlanOptimizer {
    private final Metadata metadata;

    public TransformQuantifiedComparisonApplyToCorrelatedJoin(Metadata metadata) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
    }

    @Override
    public PlanNode optimize(PlanNode plan, Session session, TypeProvider types, SymbolAllocator symbolAllocator, PlanNodeIdAllocator idAllocator, WarningCollector warningCollector, PlanOptimizersStatsCollector planOptimizersStatsCollector, TableStatsProvider tableStatsProvider) {
        return SimplePlanRewriter.rewriteWith(new Rewriter(idAllocator, types, symbolAllocator, this.metadata), plan, null);
    }

    private static class Rewriter
    extends SimplePlanRewriter<PlanNode> {
        private final PlanNodeIdAllocator idAllocator;
        private final TypeProvider types;
        private final SymbolAllocator symbolAllocator;
        private final Metadata metadata;

        public Rewriter(PlanNodeIdAllocator idAllocator, TypeProvider types, SymbolAllocator symbolAllocator, Metadata metadata) {
            this.idAllocator = Objects.requireNonNull(idAllocator, "idAllocator is null");
            this.types = Objects.requireNonNull(types, "types is null");
            this.symbolAllocator = Objects.requireNonNull(symbolAllocator, "symbolAllocator is null");
            this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        }

        @Override
        public PlanNode visitApply(ApplyNode node, SimplePlanRewriter.RewriteContext<PlanNode> context) {
            if (node.getSubqueryAssignments().size() != 1) {
                return context.defaultRewrite(node);
            }
            Expression expression = (Expression)Iterables.getOnlyElement(node.getSubqueryAssignments().getExpressions());
            if (!(expression instanceof QuantifiedComparisonExpression)) {
                return context.defaultRewrite(node);
            }
            QuantifiedComparisonExpression quantifiedComparison = (QuantifiedComparisonExpression)expression;
            return this.rewriteQuantifiedApplyNode(node, quantifiedComparison, context);
        }

        private PlanNode rewriteQuantifiedApplyNode(ApplyNode node, QuantifiedComparisonExpression quantifiedComparison, SimplePlanRewriter.RewriteContext<PlanNode> context) {
            PlanNode subqueryPlan = context.rewrite(node.getSubquery());
            Symbol outputColumn = (Symbol)Iterables.getOnlyElement(subqueryPlan.getOutputSymbols());
            Type outputColumnType = this.types.get(outputColumn);
            Preconditions.checkState((boolean)outputColumnType.isOrderable(), (Object)"Subquery result type must be orderable");
            Symbol minValue = this.symbolAllocator.newSymbol("min", outputColumnType);
            Symbol maxValue = this.symbolAllocator.newSymbol("max", outputColumnType);
            Symbol countAllValue = this.symbolAllocator.newSymbol("count_all", (Type)BigintType.BIGINT);
            Symbol countNonNullValue = this.symbolAllocator.newSymbol("count_non_null", (Type)BigintType.BIGINT);
            ImmutableList outputColumnReferences = ImmutableList.of((Object)outputColumn.toSymbolReference());
            subqueryPlan = AggregationNode.singleAggregation(this.idAllocator.getNextId(), subqueryPlan, (Map<Symbol, AggregationNode.Aggregation>)ImmutableMap.of((Object)minValue, (Object)new AggregationNode.Aggregation(this.metadata.resolveBuiltinFunction("min", TypeSignatureProvider.fromTypes(outputColumnType)), (List<Expression>)outputColumnReferences, false, Optional.empty(), Optional.empty(), Optional.empty()), (Object)maxValue, (Object)new AggregationNode.Aggregation(this.metadata.resolveBuiltinFunction("max", TypeSignatureProvider.fromTypes(outputColumnType)), (List<Expression>)outputColumnReferences, false, Optional.empty(), Optional.empty(), Optional.empty()), (Object)countAllValue, (Object)new AggregationNode.Aggregation(this.metadata.resolveBuiltinFunction("count", Collections.emptyList()), (List<Expression>)ImmutableList.of(), false, Optional.empty(), Optional.empty(), Optional.empty()), (Object)countNonNullValue, (Object)new AggregationNode.Aggregation(this.metadata.resolveBuiltinFunction("count", TypeSignatureProvider.fromTypes(outputColumnType)), (List<Expression>)outputColumnReferences, false, Optional.empty(), Optional.empty(), Optional.empty())), AggregationNode.globalAggregation());
            CorrelatedJoinNode join = new CorrelatedJoinNode(node.getId(), context.rewrite(node.getInput()), subqueryPlan, node.getCorrelation(), CorrelatedJoinNode.Type.INNER, (Expression)BooleanLiteral.TRUE_LITERAL, node.getOriginSubquery());
            Expression valueComparedToSubquery = this.rewriteUsingBounds(quantifiedComparison, minValue, maxValue, countAllValue, countNonNullValue);
            Symbol quantifiedComparisonSymbol = (Symbol)Iterables.getOnlyElement(node.getSubqueryAssignments().getSymbols());
            return this.projectExpressions(join, Assignments.of(quantifiedComparisonSymbol, valueComparedToSubquery));
        }

        public Expression rewriteUsingBounds(QuantifiedComparisonExpression quantifiedComparison, Symbol minValue, Symbol maxValue, Symbol countAllValue, Symbol countNonNullValue) {
            Function<List, Expression> quantifier;
            BooleanLiteral emptySetResult;
            if (quantifiedComparison.getQuantifier() == QuantifiedComparisonExpression.Quantifier.ALL) {
                emptySetResult = BooleanLiteral.TRUE_LITERAL;
                quantifier = expressions -> ExpressionUtils.combineConjuncts(this.metadata, expressions);
            } else {
                emptySetResult = BooleanLiteral.FALSE_LITERAL;
                quantifier = expressions -> ExpressionUtils.combineDisjuncts(this.metadata, expressions);
            }
            Expression comparisonWithExtremeValue = this.getBoundComparisons(quantifiedComparison, minValue, maxValue);
            return new SimpleCaseExpression((Expression)countAllValue.toSymbolReference(), (List)ImmutableList.of((Object)new WhenClause((Expression)new GenericLiteral("bigint", "0"), (Expression)emptySetResult)), Optional.of(quantifier.apply((List)ImmutableList.of((Object)comparisonWithExtremeValue, (Object)new SearchedCaseExpression((List)ImmutableList.of((Object)new WhenClause((Expression)new ComparisonExpression(ComparisonExpression.Operator.NOT_EQUAL, (Expression)countAllValue.toSymbolReference(), (Expression)countNonNullValue.toSymbolReference()), (Expression)new Cast((Expression)new NullLiteral(), TypeSignatureTranslator.toSqlType((Type)BooleanType.BOOLEAN)))), Optional.of(emptySetResult))))));
        }

        private Expression getBoundComparisons(QuantifiedComparisonExpression quantifiedComparison, Symbol minValue, Symbol maxValue) {
            if (quantifiedComparison.getOperator() == ComparisonExpression.Operator.EQUAL && quantifiedComparison.getQuantifier() == QuantifiedComparisonExpression.Quantifier.ALL) {
                return ExpressionUtils.combineConjuncts(this.metadata, new Expression[]{new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)minValue.toSymbolReference(), (Expression)maxValue.toSymbolReference()), new ComparisonExpression(ComparisonExpression.Operator.EQUAL, quantifiedComparison.getValue(), (Expression)maxValue.toSymbolReference())});
            }
            if (EnumSet.of(ComparisonExpression.Operator.LESS_THAN, ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, ComparisonExpression.Operator.GREATER_THAN, ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL).contains(quantifiedComparison.getOperator())) {
                Symbol boundValue = Rewriter.shouldCompareValueWithLowerBound(quantifiedComparison) ? minValue : maxValue;
                return new ComparisonExpression(quantifiedComparison.getOperator(), quantifiedComparison.getValue(), (Expression)boundValue.toSymbolReference());
            }
            throw new IllegalArgumentException("Unsupported quantified comparison: " + quantifiedComparison);
        }

        private static boolean shouldCompareValueWithLowerBound(QuantifiedComparisonExpression quantifiedComparison) {
            return switch (quantifiedComparison.getQuantifier()) {
                default -> throw new IncompatibleClassChangeError();
                case QuantifiedComparisonExpression.Quantifier.ALL -> {
                    switch (quantifiedComparison.getOperator()) {
                        case LESS_THAN: 
                        case LESS_THAN_OR_EQUAL: {
                            yield true;
                        }
                        case GREATER_THAN: 
                        case GREATER_THAN_OR_EQUAL: {
                            yield false;
                        }
                    }
                    throw new IllegalArgumentException("Unexpected value: " + quantifiedComparison.getOperator());
                }
                case QuantifiedComparisonExpression.Quantifier.ANY, QuantifiedComparisonExpression.Quantifier.SOME -> {
                    switch (quantifiedComparison.getOperator()) {
                        case LESS_THAN: 
                        case LESS_THAN_OR_EQUAL: {
                            yield false;
                        }
                        case GREATER_THAN: 
                        case GREATER_THAN_OR_EQUAL: {
                            yield true;
                        }
                    }
                    throw new IllegalArgumentException("Unexpected value: " + quantifiedComparison.getOperator());
                }
            };
        }

        private ProjectNode projectExpressions(PlanNode input, Assignments subqueryAssignments) {
            Assignments assignments = Assignments.builder().putIdentities(input.getOutputSymbols()).putAll(subqueryAssignments).build();
            return new ProjectNode(this.idAllocator.getNextId(), input, assignments);
        }
    }
}

